/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.commands;

import com.ibm.cognos.camaaa.internal.LPS.commands.LPSCommand;
import com.ibm.cognos.camaaa.internal.LPS.common.LegacyUtil;
import com.ibm.cognos.camaaa.internal.LPS.common.LegacyVisa;
import com.ibm.cognos.camaaa.internal.auth.AuthRedirectRequest;
import com.ibm.cognos.camaaa.internal.auth.AuthRedirectRequestImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.soap.SetCookieVar;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

public class AuthenticateCommand
extends LPSCommand {
    private static final String CAM = "CAM";
    private static final String HDR_SESSION = "hdrSession";
    private static final String FORMFIELD_VARS = "formFieldVars";
    private static final String NAMESPACE = "CAMNamespace";
    private static final String AUTHENTICATE_DOCUMENT = "authenticateDocument";
    private static final String CAM_TRUSTED_CREDENTIAL = "CAMTrustedCredential";
    private static final XPath VISA_PATH = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='visa']");
    private static final XPath CREDENTIAL_XPATH = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='credential']");
    private static final XPath SET_COOKIE_VARS_ITEMS_PATH = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='hdrSession']/*[local-name()='setCookieVars']/*[local-name()='item']");
    private static final XPath CAM_ACTION_XPATH = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='action']");
    private final SoapEnvelope request;
    private final Element additionalInfo;
    private final String namespaceID;
    private final Credential credential;
    private final String action;
    private final LegacyVisa visa;
    private final AuthRedirectRequest redirectRequest;
    private Credential responseCredential;
    private SetCookieVar[] responseSetCookieVar;
    private AuthRedirectRequest responseRedirectRequest;
    private LegacyVisa responseVisa;
    private String requestText;

    AuthenticateCommand(LegacyVisa reqVisa, LegacyVisa respVisa) {
        this.request = null;
        this.visa = reqVisa;
        this.responseVisa = respVisa;
        this.additionalInfo = null;
        this.namespaceID = null;
        this.credential = null;
        this.action = null;
        this.redirectRequest = null;
    }

    public AuthenticateCommand(AuthRedirectRequest theRedirectRequest) {
        this.request = null;
        this.visa = null;
        this.additionalInfo = null;
        this.namespaceID = null;
        this.credential = null;
        this.action = null;
        this.redirectRequest = theRedirectRequest;
    }

    public AuthenticateCommand(SoapEnvelope soapRequest, LegacyVisa legacyVisa, Credential theCredential, Element addInfo, String namespace, String theAction) {
        this.request = soapRequest;
        this.visa = legacyVisa;
        this.additionalInfo = addInfo;
        this.namespaceID = namespace;
        this.credential = theCredential;
        this.action = theAction;
        this.redirectRequest = null;
    }

    private void addAdditionalInfoToBiBusHeader(Element bibusElement) {
        Element orgAddInfoElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)"./*[local-name()='additionalInfo']", (Node)bibusElement);
        if (orgAddInfoElement == null && this.additionalInfo != null) {
            bibusElement.add(this.additionalInfo);
        }
    }

    private void addCAMNamespaceToHeader(Element bibusElement) {
        boolean foundNamespace;
        Element sessionElement = bibusElement.element(HDR_SESSION);
        String camNamespaceSelectionXPath = "./*[local-name()='formFieldVars']/*[local-name()='item']/*[local-name()='name'][camaaa:element-text(.)='CAMNamespace']";
        boolean bl = foundNamespace = sessionElement != null && com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectElements((String)"./*[local-name()='formFieldVars']/*[local-name()='item']/*[local-name()='name'][camaaa:element-text(.)='CAMNamespace']", (Node)sessionElement) != null;
        if (!foundNamespace) {
            Element formFieldElement;
            if (sessionElement == null) {
                sessionElement = bibusElement.addElement(HDR_SESSION);
            }
            if ((formFieldElement = sessionElement.element(FORMFIELD_VARS)) == null) {
                formFieldElement = sessionElement.addElement(FORMFIELD_VARS);
            }
            Element item = formFieldElement.addElement(QName.get((String)"item"));
            Element element = item.addElement("name");
            element.addText(NAMESPACE);
            element = item.addElement("value");
            element.addText(this.namespaceID);
            formFieldElement.addAttribute("arrayType", "bus:formFieldVar[" + formFieldElement.elements().size() + "]");
        }
    }

    private void fillResponseCredential(Element responseElement) {
        Node credentialElement = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((XPath)CREDENTIAL_XPATH, (Node)responseElement);
        if (credentialElement != null) {
            List credentials = credentialElement.selectNodes("./*");
            if (credentials.size() > 0) {
                this.responseCredential = new CredentialImpl();
            }
            for (int i = 0; i < credentials.size(); ++i) {
                String elementName = ((Element)credentials.get(i)).getName();
                String elementValue = ((Element)credentials.get(i)).getText();
                this.responseCredential.addCredentialPair(elementName, new String[]{elementValue});
            }
        }
    }

    private void fillResponseRedirectRequest(Element responseElement) {
        if (responseElement != null) {
            this.responseRedirectRequest = new AuthRedirectRequestImpl(responseElement);
        }
    }

    private void fillResponseSetCookieVars(Element responseElement) {
        List setCookieVarElements = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectNodes((XPath)SET_COOKIE_VARS_ITEMS_PATH, (Node)responseElement);
        ArrayList<SetCookieVar> setCookieVars = new ArrayList<SetCookieVar>();
        for (Element setCookieVarElement : setCookieVarElements) {
            setCookieVars.add(new SetCookieVar(setCookieVarElement));
        }
        this.responseSetCookieVar = setCookieVars.toArray(new SetCookieVar[0]);
    }

    private void fillResponseVisa(Element responseElement) {
        Element visaElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((XPath)VISA_PATH, (Node)responseElement);
        if (visaElement != null) {
            this.responseVisa = new LegacyVisa(visaElement);
        }
    }

    @Override
    public String getRequestType() {
        return "authenticate";
    }

    public Credential getResponseCredential() {
        return this.responseCredential;
    }

    public AuthRedirectRequest getResponseRedirectRequest() {
        return this.responseRedirectRequest;
    }

    public SetCookieVar[] getResponseSetCookieVar() {
        return this.responseSetCookieVar;
    }

    public LegacyVisa getResponseVisa() {
        return this.responseVisa;
    }

    @Override
    public void parseResponse(InputStream stream) throws LocalizableException {
        Document response = this.getResponseDocument(stream);
        int status = this.getResponseStatus(response);
        if (status >= 0) {
            Element responseElement = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleElement((String)"./*[local-name()='authenticateResponse']", (Node)response.getRootElement());
            this.fillResponseCredential(responseElement);
            this.fillResponseSetCookieVars(responseElement);
            this.fillResponseVisa(responseElement);
        } else if (status == -50) {
            Element responseElement = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleElement((String)"./*[local-name()='authenticateDocument']", (Node)response.getRootElement());
            this.fillResponseRedirectRequest(responseElement);
        } else {
            this.throwFaultFromResponse(response);
        }
    }

    private void prepareCAMSection(Element bibusElement) {
        Element camSection = bibusElement.element(CAM);
        if (camSection == null) {
            camSection = bibusElement.addElement(CAM);
        }
        if (com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleElement((XPath)CAM_ACTION_XPATH, (Node)camSection) == null) {
            camSection.addElement("action").setText(this.action);
        }
        if (this.credential != null) {
            Element camTrustedCredential = camSection.element(CAM_TRUSTED_CREDENTIAL);
            if (camTrustedCredential == null) {
                camTrustedCredential = camSection.addElement(CAM_TRUSTED_CREDENTIAL);
            }
            String escapedValue = this.credential.toString();
            camTrustedCredential.setText(escapedValue);
        }
    }

    @Override
    public void writeRequest(Writer outputStream) throws IOException {
        if (this.redirectRequest != null) {
            outputStream.write(this.redirectRequest.getAuthDoc());
        }
        if (this.requestText == null) {
            Element bibusElement = LegacyUtil.getBiBusHeaderElement(this.request);
            this.addAdditionalInfoToBiBusHeader(bibusElement);
            this.addCAMNamespaceToHeader(bibusElement);
            this.prepareCAMSection(bibusElement);
            Document authDoc = DocumentHelper.createDocument();
            Element authenticateDocumentElement = authDoc.addElement(AUTHENTICATE_DOCUMENT);
            authenticateDocumentElement.add(bibusElement);
            if (this.visa != null) {
                authenticateDocumentElement.add(this.visa.serialize());
            }
            this.requestText = authenticateDocumentElement.asXML();
        }
        outputStream.write(this.requestText);
    }
}

