/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.commands;

import com.ibm.cognos.camaaa.internal.LPS.commands.LPSCommand;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class ConfigureCommand
extends LPSCommand {
    private static final String CONTENT_LOCALE = "contentLocale";
    private static final String PRODUCT_LOCALE = "productLocale";
    private static final String XSD_STRING = "xsd:string";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String PARAMETER = "parameter";
    private String request = "";
    private String[] capabilities;
    private HashMap<String, String> conformancePropertiesMap;

    private void addLocaleParameter(Element instanceConfig, String name, String value) {
        Element paramterElement = instanceConfig.addElement(PARAMETER);
        paramterElement.addAttribute(NAME, name);
        Element valueElement = paramterElement.addElement(VALUE);
        valueElement.addAttribute(TYPE, XSD_STRING);
        valueElement.setText(value);
    }

    public HashMap<String, String> getConformanceProperties() {
        return this.conformancePropertiesMap;
    }

    private List<?> getElementsFromQueryResult(Document response, String what) {
        List elements = response.getRootElement().selectNodes("/configureResponse/*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='" + what + "']/*[local-name()='value']/item");
        return elements;
    }

    public String[] getNamespaceCapabilities() {
        return this.capabilities;
    }

    @Override
    public String getRequestType() {
        return "configure";
    }

    private String[] parseCapabilities(Document response) {
        ArrayList<String> capabilitiesList = new ArrayList<String>();
        List<?> elements = this.getElementsFromQueryResult(response, "capabilities");
        for (Node node : elements) {
            capabilitiesList.add(node.getText());
        }
        return capabilitiesList.toArray(new String[0]);
    }

    private HashMap<String, String> parseConformanceProperties(Document response) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        List<?> elements = this.getElementsFromQueryResult(response, "comformanceProperties");
        if (elements == null) {
            return propMap;
        }
        for (Node node : elements) {
            String property = node.getText();
            if (property == null) continue;
            String[] values = property.split("=", 2);
            if (values.length == 2) {
                propMap.put(values[0], values[1]);
                continue;
            }
            propMap.put(values[0], null);
        }
        return propMap;
    }

    @Override
    public void parseResponse(InputStream stream) throws LocalizableException {
        Document response = this.getResponseDocument(stream);
        int status = this.getResponseStatus(response);
        if (status >= 0) {
            this.capabilities = this.parseCapabilities(response);
            this.conformancePropertiesMap = this.parseConformanceProperties(response);
        } else {
            this.throwFaultFromResponse(response);
        }
    }

    public void setupConfiguration(Configuration config) throws LocalizableException {
        Document instanceConfig;
        try {
            instanceConfig = DocumentHelper.parseText((String)config.export());
        }
        catch (DocumentException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"), (Throwable)e);
        }
        this.addLocaleParameter(instanceConfig.getRootElement(), PRODUCT_LOCALE, Locale.getDefault().toString());
        this.addLocaleParameter(instanceConfig.getRootElement(), CONTENT_LOCALE, Locale.getDefault().toString());
        this.request = instanceConfig.asXML();
    }

    @Override
    public void writeRequest(Writer outputStream) throws IOException {
        outputStream.write(this.request);
    }
}

