/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.commands;

import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.ibm.cognos.camaaa.internal.LPS.exception.ExceptionElementParserImpl;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public abstract class LPSCommand
implements MsgBodyGenerator {
    private static final String EXCEPTION = "exception";

    public static Element getResponseException(Document doc) {
        Element exception;
        block1: {
            Element subElement;
            Element root = doc.getRootElement();
            exception = root.element(EXCEPTION);
            if (exception != null) break block1;
            Iterator it2 = root.elementIterator();
            while (it2.hasNext() && (exception = (subElement = (Element)it2.next()).element(EXCEPTION)) == null) {
            }
        }
        return exception;
    }

    int getResponseStatus(Document doc) {
        Element root = doc.getRootElement();
        Element statusElement = root.element("status");
        String statusValue = null;
        if (statusElement != null) {
            statusValue = statusElement.getText();
        }
        int status = -1;
        try {
            if (statusValue != null) {
                status = Integer.parseInt(statusValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return status;
    }

    public abstract String getRequestType();

    public abstract void parseResponse(InputStream var1) throws LocalizableException;

    protected final Document getResponseDocument(InputStream stream) throws LocalizableException {
        try {
            return DocumentHelper.parse((InputStream)stream);
        }
        catch (DocumentException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_LPS_BROKEN_CONNECTION"), (Throwable)e);
        }
    }

    public boolean rewind() {
        return true;
    }

    protected void throwFaultFromResponse(Document response) throws SoapFaultException {
        Element exceptionElement = LPSCommand.getResponseException(response);
        SoapFaultException deserializedException = new ExceptionElementParserImpl().parseExceptionElement(exceptionElement);
        throw deserializedException;
    }

    public void writeBody(OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, "utf8");
        this.writeRequest(writer);
        ((Writer)writer).flush();
    }

    protected abstract void writeRequest(Writer var1) throws IOException;
}

