/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.commands;

import com.cognos.pogo.pdk.xml.PooledSAXReader;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.ibm.cognos.camaaa.internal.LPS.commands.LPSCommand;
import com.ibm.cognos.camaaa.internal.LPS.common.LegacyVisa;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.SearchResponseHandler;
import com.ibm.cognos.camaaa.internal.admin.soap.IQueryUtil;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpressionImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class QueryCommand
extends LPSCommand {
    private static final String SEARCH_REQUEST = "searchRequest";
    private final Element legacyQueryElement;
    private final Element bibusHeader;
    private final Element additionalInfo;
    private final LegacyVisa visa;
    private boolean searchForMemberOf;
    private final QueryResult queryResult;
    private final Namespace namespace;

    QueryCommand(LegacyVisa aVisa) {
        this.visa = aVisa;
        this.legacyQueryElement = null;
        this.additionalInfo = null;
        this.bibusHeader = null;
        this.queryResult = null;
        this.namespace = null;
    }

    public QueryCommand(Element theBibusHeader, Query theQuery, Element addInfo, LegacyVisa theVisa, QueryResult theQueryResult, Namespace theNamespace) throws SoapFaultException {
        this.namespace = theNamespace;
        this.queryResult = theQueryResult;
        this.bibusHeader = theBibusHeader == null ? DocumentHelper.createElement((String)"biBusHeader") : theBibusHeader;
        this.additionalInfo = addInfo;
        this.visa = theVisa;
        if (this.isUserInfoQuery(theQuery)) {
            ((QueryImpl)theQuery).setSearchExpression((SearchExpression)new SearchExpressionImpl("CAMID(\"" + this.visa.getUserID() + "\")"));
        }
        this.searchForMemberOf = false;
        String[] properties = theQuery.getProperties();
        boolean hasNameProperty = false;
        boolean hasDescriptionProperty = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].compareToIgnoreCase("memberOf") == 0) {
                this.searchForMemberOf = true;
            }
            if (properties[i].compareToIgnoreCase("name") == 0) {
                hasNameProperty = true;
            }
            if (properties[i].compareToIgnoreCase("description") != 0) continue;
            hasDescriptionProperty = true;
        }
        this.legacyQueryElement = IQueryUtil.toLegacyQueryElement((Query)theQuery);
        this.modifyQuery(hasNameProperty, hasDescriptionProperty);
    }

    private Element copyBiBusHdr() {
        Element newBiBusHeader;
        Element orgAddInfoElement = this.bibusHeader.element("additionalInfo");
        if (orgAddInfoElement == null && this.additionalInfo != null) {
            newBiBusHeader = this.bibusHeader.createCopy();
            newBiBusHeader.add(this.additionalInfo);
        } else {
            newBiBusHeader = this.bibusHeader;
        }
        return newBiBusHeader;
    }

    private OutputFormat createOutputFormat() {
        OutputFormat outformat = OutputFormat.createCompactFormat();
        outformat.setSuppressDeclaration(true);
        outformat.setEncoding("UTF-8");
        outformat.setExpandEmptyElements(true);
        outformat.setTrimText(false);
        return outformat;
    }

    private void detachMachingElement(String elementName, Element element) {
        if (elementName.equals(element.getText())) {
            element.detach();
        }
    }

    @Override
    public String getRequestType() {
        return "search";
    }

    private boolean isUserInfoQuery(Query query) {
        if (this.visa != null) {
            String search = "/child::home/child::account";
            return query.getSearchExpression().toString().equals("/child::home/child::account");
        }
        return false;
    }

    private void modifyQuery(boolean hasNameProperty, boolean hasDescriptionProperty) {
        if (hasDescriptionProperty || hasNameProperty) {
            Element propertiesElement = this.legacyQueryElement.element("properties");
            Iterator it = propertiesElement.elementIterator();
            while (it.hasNext()) {
                Element prop = (Element)it.next();
                if (hasDescriptionProperty) {
                    this.detachMachingElement("defaultDescription", prop);
                }
                if (!hasNameProperty) continue;
                this.detachMachingElement("defaultName", prop);
            }
        }
    }

    @Override
    public void parseResponse(InputStream in) throws LocalizableException {
        SAXReaderPool pool = SAXReaderPool.getInstance();
        PooledSAXReader pooledReader = pool.get();
        try {
            XMLReader reader = pooledReader.getRealReader().getXMLReader();
            SearchResponseHandler handler = new SearchResponseHandler(reader, this.queryResult, this.namespace, this.visa, this.searchForMemberOf);
            reader.setContentHandler(handler);
            reader.parse(new InputSource(in));
        }
        catch (IOException e) {
            throw new InternalErrorException(this.getClass().getName(), (Exception)e);
        }
        catch (SAXException e) {
            throw new InternalErrorException(this.getClass().getName(), (Exception)e);
        }
        finally {
            pooledReader.release();
        }
    }

    public void populateResults(QueryResult theQueryResult, Namespace theNamespace) throws SoapFaultException {
    }

    private void writeNamespaces(XMLWriter writer) throws SAXException {
        writer.startPrefixMapping("bus", "http://developer.cognos.com/schemas/bibus/3/");
        writer.startPrefixMapping("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        writer.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.startPrefixMapping("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
    }

    @Override
    public void writeRequest(Writer outputStream) throws IOException {
        OutputFormat outformat = this.createOutputFormat();
        XMLWriter writer = new XMLWriter(outputStream, outformat);
        try {
            AttributesImpl emptyAtts = new AttributesImpl();
            writer.startDocument();
            writer.startElement("", "", SEARCH_REQUEST, (Attributes)emptyAtts);
            writer.flush();
            outputStream.write(this.visa.toString());
            this.writeNamespaces(writer);
            writer.startElement(XMLConstants.SOAPENV_ENVELOPE.getNamespaceURI(), XMLConstants.SOAPENV_ENVELOPE.getName(), XMLConstants.SOAPENV_ENVELOPE.getQualifiedName(), (Attributes)emptyAtts);
            writer.startElement(XMLConstants.SOAPENV_HEADER.getNamespaceURI(), XMLConstants.SOAPENV_HEADER.getName(), XMLConstants.SOAPENV_HEADER.getQualifiedName(), (Attributes)emptyAtts);
            Element bibusHeaderCopy = this.copyBiBusHdr();
            writer.write(bibusHeaderCopy);
            writer.endElement(XMLConstants.SOAPENV_HEADER.getNamespaceURI(), XMLConstants.SOAPENV_HEADER.getName(), XMLConstants.SOAPENV_HEADER.getQualifiedName());
            writer.startElement(XMLConstants.SOAPENV_BODY.getNamespaceURI(), XMLConstants.SOAPENV_BODY.getName(), XMLConstants.SOAPENV_BODY.getQualifiedName(), (Attributes)emptyAtts);
            writer.write(this.legacyQueryElement);
            writer.endElement(XMLConstants.SOAPENV_BODY.getNamespaceURI(), XMLConstants.SOAPENV_BODY.getName(), XMLConstants.SOAPENV_BODY.getQualifiedName());
            writer.endElement(XMLConstants.SOAPENV_ENVELOPE.getNamespaceURI(), XMLConstants.SOAPENV_ENVELOPE.getName(), XMLConstants.SOAPENV_ENVELOPE.getQualifiedName());
            writer.endElement("", "", SEARCH_REQUEST);
            writer.endDocument();
            writer.flush();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

