/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.common;

import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.legacy.auth.BaseLegacyVisa;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class LegacyVisa
extends BaseLegacyVisa {
    private static final long serialVersionUID = 9364873652874L;
    private static final XPath VISA_NAMESPACE_XPATH = DocumentHelper.createXPath((String)"./@namespaceID");
    private static final XPath VISA_OBJECT_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='object'][@class=\"visa\"]/@id");
    private static final XPath PROVIDER_DATA_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='providerSpecificData']/*");
    private static final XPath VISA_USER_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='object'][@class=\"visa\"]/*[local-name()='object'][@class=\"user\"]/@id");
    private static final XPath VISA_GROUP_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='object'][@class=\"visa\"]/*[local-name()='object'][@class=\"group\"]/@id");
    private static final XPath VISA_ROLE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='object'][@class=\"visa\"]/*[local-name()='object'][@class=\"role\"]/@id");
    private static final int GROUP_OBJECT = 2;
    private static final int ROLE_OBJECT = 3;
    private String namespaceID;
    private String userID;
    private String passportID;
    private List<String> groups;
    private List<String> roles;
    private Element visaElement;
    private Credential providerSpecificData;
    private String visaDoc;
    private boolean dirty;

    public LegacyVisa() {
        this.visaDoc = null;
        this.dirty = true;
    }

    public LegacyVisa(Element theVisaElement) {
        this.visaElement = theVisaElement.createCopy();
        this.visaDoc = this.visaElement.asXML();
        this.parse();
    }

    public LegacyVisa(String xmlString) throws DocumentException {
        this.initialize(xmlString);
    }

    private void addObjectToTheList(List<String> objectList, List<?> objects) {
        for (int i = 0; i < objects.size(); ++i) {
            Node dataElement = (Node)objects.get(i);
            String objectID = dataElement.getText();
            objectList.add(objectID);
        }
    }

    public BaseLegacyVisa cloneVisa() {
        LegacyVisa clonedVisa = new LegacyVisa(this.visaElement);
        this.addRefs(clonedVisa);
        return clonedVisa;
    }

    private void fillGroupIdentity() {
        List<?> groupObjects = this.parseForIdentityObject(2);
        if (groupObjects != null && groupObjects.size() > 0) {
            this.groups = new ArrayList<String>();
            this.addObjectToTheList(this.groups, groupObjects);
        }
    }

    private void fillRoleIdentity() {
        List<?> roleObjects = this.parseForIdentityObject(3);
        if (roleObjects != null && roleObjects.size() > 0) {
            this.roles = new ArrayList<String>();
            this.addObjectToTheList(this.roles, roleObjects);
        }
    }

    public Credential getCredential() {
        return this.providerSpecificData;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.fillGroupIdentity();
        }
        return this.groups;
    }

    public String getNamespaceID() {
        return this.namespaceID;
    }

    public String getPassportID() {
        return this.passportID;
    }

    private void getProviderSpecificData() {
        List providerData = DocumentHelper.selectNodes((XPath)PROVIDER_DATA_XPATH, (Node)this.visaElement);
        if (providerData.size() > 0) {
            this.providerSpecificData = new CredentialImpl();
        }
        for (int i = 0; i < providerData.size(); ++i) {
            Element dataElement = (Element)providerData.get(i);
            String elementName = dataElement.getName();
            String elementValue = dataElement.getText();
            this.providerSpecificData.addCredentialPair(elementName, new String[]{elementValue});
        }
    }

    public List<String> getRoles() {
        if (this.roles == null) {
            this.fillRoleIdentity();
        }
        return this.roles;
    }

    public String getUserID() {
        return this.userID;
    }

    public boolean hasStateChanged() {
        return this.dirty;
    }

    private void initialize(String xmlString) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)xmlString);
        this.visaDoc = xmlString;
        this.visaElement = doc.getRootElement();
        this.parse();
    }

    private void parse() {
        this.namespaceID = DocumentHelper.valueOf((XPath)VISA_NAMESPACE_XPATH, (Node)this.visaElement);
        this.userID = DocumentHelper.valueOf((XPath)VISA_USER_XPATH, (Node)this.visaElement);
        this.passportID = DocumentHelper.valueOf((XPath)VISA_OBJECT_XPATH, (Node)this.visaElement);
        this.fillGroupIdentity();
        this.fillRoleIdentity();
        this.getProviderSpecificData();
        this.dirty = true;
    }

    private List<?> parseForIdentityObject(int objectType) {
        List objects = null;
        switch (objectType) {
            case 2: {
                objects = DocumentHelper.selectNodes((XPath)VISA_GROUP_XPATH, (Node)this.visaElement);
                break;
            }
            case 3: {
                objects = DocumentHelper.selectNodes((XPath)VISA_ROLE_XPATH, (Node)this.visaElement);
                break;
            }
        }
        return objects;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 9364873652874L) {
            throw new IOException("Unkown version: " + Long.toString(version));
        }
        this.visaDoc = in.readUTF();
        try {
            this.initialize(this.visaDoc);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    public void resetChangeIndicator() {
        this.dirty = false;
    }

    public Element serialize() {
        this.visaElement.detach();
        return this.visaElement;
    }

    public String toString() {
        return this.visaDoc;
    }

    public void transferFrom(LegacyVisa source) {
        if (!this.visaDoc.equals(source.visaDoc)) {
            this.visaDoc = source.visaDoc;
            source.visaDoc = null;
            this.namespaceID = source.namespaceID;
            source.namespaceID = null;
            this.userID = source.userID;
            source.userID = null;
            this.passportID = source.passportID;
            source.passportID = null;
            this.groups = source.groups;
            source.groups = null;
            this.roles = source.roles;
            source.roles = null;
            this.providerSpecificData = source.providerSpecificData;
            source.providerSpecificData = null;
            this.visaElement = source.visaElement;
            source.visaElement = null;
            this.dirty = true;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(9364873652874L);
        out.writeUTF(this.visaDoc);
    }
}

