/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.exception;

import com.ibm.cognos.camaaa.internal.LPS.exception.ExceptionElementParser;
import com.ibm.cognos.camaaa.internal.LPS.exception.SystemRecoverableExceptionParser;
import com.ibm.cognos.camaaa.internal.LPS.exception.UserRecoverableExceptionParser;
import com.ibm.cognos.camaaa.internal.auth.exception.AuthenticationException;
import com.ibm.cognos.camaaa.internal.auth.exception.NegotiateException;
import com.ibm.cognos.camaaa.internal.auth.exception.SystemRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizedMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class ExceptionElementParserImpl
implements ExceptionElementParser {
    private static final String CLASS_NAME = ExceptionElementParserImpl.class.getName();

    private void addCaptionsToAuthenticationException(Element exceptionElement, LocalizableException rootException) {
        List captionsList = DocumentHelper.selectNodes((String)"./*[local-name()='promptInfo']/*[local-name()='captions']/*[local-name()='item']", (Node)exceptionElement);
        if (captionsList.size() > 0) {
            for (int i = 0; i < captionsList.size(); ++i) {
                String caption = ((Element)captionsList.get(i)).getText();
                ((AuthenticationException)rootException).addCaption((LocalizableMessage)new LocalizedMessage(caption));
            }
        }
    }

    private void attachCauseExceptionChainToException(List causeMessagesList, LocalizableException rootException) {
        LocalizableException currentException = null;
        if (causeMessagesList.size() > 0) {
            String message = this.getExceptionMessageText((Element)causeMessagesList.get(causeMessagesList.size() - 1));
            currentException = new LocalizableException((LocalizableMessage)new LocalizedMessage(message), null);
            for (int i = causeMessagesList.size() - 2; i >= 0; --i) {
                LocalizableException tempException;
                message = this.getExceptionMessageText((Element)causeMessagesList.get(i));
                currentException = tempException = new LocalizableException((LocalizableMessage)new LocalizedMessage(message), (Throwable)currentException);
            }
        }
        rootException.initCause(currentException);
    }

    private SoapFaultException deserializeIntoException(Integer errorCodeInt, String errorCodeStr, List messagesList, Element exceptionElement) throws SoapFaultException {
        Object rootException;
        LocalizedMessage rootExceptionMessage = null;
        if (messagesList.size() > 0) {
            rootExceptionMessage = new LocalizedMessage(this.getExceptionMessageText((Element)messagesList.get(0)));
            messagesList.remove(0);
        }
        if (UserRecoverableException.ERROR_CODE.equals(errorCodeInt) || "camAuthUserRecoverable".equals(errorCodeStr)) {
            Element displayObjectsElement = DocumentHelper.selectSingleElement((String)"./*[local-name()='promptInfo']/*[local-name()='displayObjects']", (Node)exceptionElement);
            UserRecoverableExceptionParser parser = new UserRecoverableExceptionParser();
            rootException = parser.createUserRecoverableException(displayObjectsElement.createCopy(), rootExceptionMessage);
        } else if (SystemRecoverableException.ERROR_CODE.equals(errorCodeInt) || "camAuthSystemRecoverable".equals(errorCodeStr) || NegotiateException.ERROR_CODE.equals(errorCodeInt) || "camAuthNegotiate".equals(errorCodeStr)) {
            Element securityBlobElement = DocumentHelper.selectSingleElement((String)"./*[local-name()='promptInfo']/*[local-name()='securityBlob']", (Node)exceptionElement);
            SystemRecoverableExceptionParser parser = new SystemRecoverableExceptionParser();
            rootException = parser.createSystemRecoverableException(securityBlobElement.createCopy(), rootExceptionMessage, errorCodeStr);
        } else {
            rootException = UnrecoverableException.ERROR_CODE.equals(errorCodeInt) || "camAuthUnrecoverable".equals(errorCodeStr) ? new UnrecoverableException(CLASS_NAME, null, (LocalizableMessage)rootExceptionMessage) : new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, CLASS_NAME, errorCodeInt, errorCodeStr, (LocalizableMessage)rootExceptionMessage);
        }
        this.attachCauseExceptionChainToException(messagesList, (LocalizableException)((Object)rootException));
        this.addCaptionsToAuthenticationException(exceptionElement, (LocalizableException)((Object)rootException));
        return rootException;
    }

    private String getExceptionMessageText(Element messageItem) {
        return DocumentHelper.valueOf((String)"./*[local-name()='messageString']", (Node)messageItem);
    }

    @Override
    public SoapFaultException parseExceptionElement(Element exceptionElement) throws SoapFaultException {
        String errorCode = DocumentHelper.valueOf((String)"./*[local-name()='errorCodeString']", (Node)exceptionElement);
        if (errorCode == null) {
            errorCode = DocumentHelper.valueOf((String)"./*[local-name()='errorCode']", (Node)exceptionElement);
        }
        Integer errorCodeInt = -1;
        String errorCodeStr = "";
        boolean errorCodeIsInteger = true;
        try {
            errorCodeInt = Integer.valueOf(errorCode);
        }
        catch (NumberFormatException e) {
            errorCodeIsInteger = false;
        }
        if (!errorCodeIsInteger) {
            errorCodeStr = String.valueOf(errorCode);
        }
        List messagesList = DocumentHelper.selectNodes((String)"./*[local-name()='messages']/*[local-name()='item']", (Node)exceptionElement);
        return this.deserializeIntoException(errorCodeInt, errorCodeStr, messagesList, exceptionElement);
    }
}

