/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.exception;

import com.ibm.cognos.camaaa.internal.auth.EnvironmentSecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.KerberosSecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlobManager;
import com.ibm.cognos.camaaa.internal.auth.exception.NegotiateException;
import com.ibm.cognos.camaaa.internal.auth.exception.SystemRecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizedMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import org.dom4j.Element;

public class SystemRecoverableExceptionParser {
    private static final String EXCEPTION_ELEMENT_STRING = "exception";
    private static final String CLASS_NAME = SystemRecoverableExceptionParser.class.getName();

    private SystemRecoverableException createException(LocalizedMessage rootExceptionMessage, String errorCodeStr, KerberosSecurityBlob kerberosSecurityBlob) {
        Object exception = "camAuthNegotiate".equals(errorCodeStr) ? new NegotiateException(CLASS_NAME, (LocalizableMessage)rootExceptionMessage, kerberosSecurityBlob.getSecurityContext()) : new SystemRecoverableException(CLASS_NAME, (LocalizableMessage)rootExceptionMessage, kerberosSecurityBlob.getSecurityContext());
        return exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SystemRecoverableException createSystemRecoverableException(Element securityBlobElement, LocalizedMessage rootExceptionMessage, String errorCodeStr) throws SoapFaultException {
        SystemRecoverableException exception = null;
        String encodedSecurityBlob = null;
        if (securityBlobElement != null) {
            encodedSecurityBlob = securityBlobElement.getText();
        } else {
            this.throwMissingElementException("securityBlob");
        }
        if (encodedSecurityBlob != null && encodedSecurityBlob.length() > 0) {
            SecurityBlob securityBlob = SecurityBlobManager.createSecurityBlob((String)encodedSecurityBlob);
            if (securityBlob.getBlobType() == 1) {
                EnvironmentSecurityBlob envSecurityBlob = (EnvironmentSecurityBlob)securityBlob;
                return new SystemRecoverableException(CLASS_NAME, (LocalizableMessage)rootExceptionMessage, envSecurityBlob.getRequestedVars());
            }
            if (securityBlob.getBlobType() != 2) throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, CLASS_NAME, null, null, (LocalizableMessage)new Message("AAA_LPS_INVALID_SECURITY_BLOB"));
            KerberosSecurityBlob kerberosSecurityBlob = (KerberosSecurityBlob)securityBlob;
            return this.createException(rootExceptionMessage, errorCodeStr, kerberosSecurityBlob);
        }
        this.throwMissingElementException("securityBlob text()");
        return exception;
    }

    private void throwMissingElementException(String message) throws SoapFaultException {
        throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, CLASS_NAME, null, null, (LocalizableMessage)new Message("AAA_LPS_MISSING_REQUIRED_ELEMENT", new Object[]{new String(EXCEPTION_ELEMENT_STRING), new String(message)}));
    }
}

