/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.exception;

import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.HiddenDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.MultiSelectDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.ReadOnlyDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.SelectDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.SelectOption;
import com.ibm.cognos.camaaa.internal.auth.exception.SingleSelectDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.TextDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.TextNoEchoDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.VerifyTextNoEchoDisplayObject;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizedMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class UserRecoverableExceptionParser {
    private static final XPath ITEM_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='item']");
    private static final XPath DEFAULT_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='default']");
    private static final XPath ID_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='id']");
    private static final XPath PROMPT_OPTIONS_ITEM_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='promptOptions']/*[local-name()='item']");
    private static final XPath CAPTION_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='caption']");
    private static final XPath NAME_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='name']");
    private static final XPath TYPE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='type']");
    private static final XPath CURRENT_VALUE_XPATH_FILTER_EXPRESSION = DocumentHelper.createXPath((String)"./*[local-name()='value']");
    private static final String EXCEPTION_ELEMENT_STRING = "exception";
    private static final String CLASS_NAME = UserRecoverableExceptionParser.class.getName();

    private void addDisplayObjectsToUserRecoverableException(LocalizableException userRecoverableException, List<?> displayObjectsItems) throws SoapFaultException {
        for (int i = 0; i < displayObjectsItems.size(); ++i) {
            String name;
            String type = DocumentHelper.valueOf((XPath)TYPE_XPATH, (Node)((Node)displayObjectsItems.get(i)));
            if (type == null) {
                this.throwMissingElementException("displayObject type");
            }
            if ((name = DocumentHelper.valueOf((XPath)NAME_XPATH, (Node)((Node)displayObjectsItems.get(i)))) == null) {
                this.throwMissingElementException("displayObject name");
            }
            String caption = DocumentHelper.valueOf((XPath)CAPTION_XPATH, (Node)((Node)displayObjectsItems.get(i)));
            String value = DocumentHelper.valueOf((XPath)CURRENT_VALUE_XPATH_FILTER_EXPRESSION, (Node)((Node)displayObjectsItems.get(i)));
            DisplayObject displayObject = this.initializeDisplayObject(type, name, caption, value, (Node)displayObjectsItems.get(i));
            ((UserRecoverableException)userRecoverableException).addDisplayObject(displayObject);
        }
    }

    private void addPromptOptionsToSelectDisplayObject(DisplayObject displayObject, Node currentDisplayObjectsItemNode) throws SoapFaultException {
        List promptOptionsList = DocumentHelper.selectNodes((XPath)PROMPT_OPTIONS_ITEM_XPATH, (Node)currentDisplayObjectsItemNode);
        for (int i = 0; i < promptOptionsList.size(); ++i) {
            String isDefault;
            String value;
            String id = DocumentHelper.valueOf((XPath)ID_XPATH, (Node)((Node)promptOptionsList.get(i)));
            if (id == null) {
                this.throwMissingElementException("promptOption id");
            }
            if ((value = DocumentHelper.valueOf((XPath)CURRENT_VALUE_XPATH_FILTER_EXPRESSION, (Node)((Node)promptOptionsList.get(i)))) == null) {
                this.throwMissingElementException("promptOption value");
            }
            if ((isDefault = DocumentHelper.valueOf((XPath)DEFAULT_XPATH, (Node)((Node)promptOptionsList.get(i)))) == null) {
                this.throwMissingElementException("promptOption default");
            }
            ((SelectDisplayObject)displayObject).addOption(new SelectOption(id, value, new Boolean(isDefault).booleanValue()));
        }
    }

    public UserRecoverableException createUserRecoverableException(Element displayObjectsElement, LocalizedMessage rootExceptionMessage) throws SoapFaultException {
        UserRecoverableException exception = new UserRecoverableException(CLASS_NAME, null, (LocalizableMessage)rootExceptionMessage);
        if (displayObjectsElement != null) {
            List displayObjectsItems = DocumentHelper.selectNodes((XPath)ITEM_XPATH, (Node)displayObjectsElement);
            this.addDisplayObjectsToUserRecoverableException((LocalizableException)exception, displayObjectsItems);
        } else {
            this.throwMissingElementException("displayObjects");
        }
        return exception;
    }

    private DisplayObject initializeDisplayObject(String type, String name, String caption, String value, Node currentDisplayObjectsItemNode) throws SoapFaultException {
        TextDisplayObject displayObject;
        if (type.equals("text")) {
            displayObject = new TextDisplayObject((LocalizableMessage)new LocalizedMessage(caption), name);
        } else if (type.equals("textnoecho")) {
            displayObject = new TextNoEchoDisplayObject((LocalizableMessage)new LocalizedMessage(caption), name);
        } else if (type.equals("verifytextnoecho")) {
            displayObject = new VerifyTextNoEchoDisplayObject((LocalizableMessage)new LocalizedMessage(caption), name);
        } else if (type.equals("singleselect")) {
            displayObject = new SingleSelectDisplayObject((LocalizableMessage)new LocalizedMessage(caption), name);
            this.addPromptOptionsToSelectDisplayObject((DisplayObject)displayObject, currentDisplayObjectsItemNode);
        } else if (type.equals("multiselect")) {
            displayObject = new MultiSelectDisplayObject((LocalizableMessage)new LocalizedMessage(caption), name);
            this.addPromptOptionsToSelectDisplayObject((DisplayObject)displayObject, currentDisplayObjectsItemNode);
        } else if (type.equals("hidden")) {
            displayObject = new HiddenDisplayObject(name, value);
        } else if (type.equals("display")) {
            displayObject = new ReadOnlyDisplayObject((LocalizableMessage)new LocalizedMessage(caption), name, value);
        } else {
            throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, CLASS_NAME, null, null, (LocalizableMessage)new Message("AAA_LPS_INVALID_DISPLAY_OBJECT_TYPE"));
        }
        if (value != null && displayObject.getValue() == null) {
            displayObject.setValue(value);
        }
        return displayObject;
    }

    private void throwMissingElementException(String message) throws SoapFaultException {
        throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, CLASS_NAME, null, null, (LocalizableMessage)new Message("AAA_LPS_MISSING_REQUIRED_ELEMENT", new Object[]{new String(EXCEPTION_ELEMENT_STRING), new String(message)}));
    }
}

