/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.handler;

import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.LPS.LPSInstance;
import com.ibm.cognos.camaaa.internal.LPS.LPSInstanceImpl;
import com.ibm.cognos.camaaa.internal.LPS.commands.AuthenticateCommand;
import com.ibm.cognos.camaaa.internal.LPS.commands.ConfigureCommand;
import com.ibm.cognos.camaaa.internal.LPS.commands.LPSCommand;
import com.ibm.cognos.camaaa.internal.LPS.commands.QueryCommand;
import com.ibm.cognos.camaaa.internal.LPS.commands.SetNamespaceVersionCommand;
import com.ibm.cognos.camaaa.internal.LPS.common.LegacyUtil;
import com.ibm.cognos.camaaa.internal.LPS.common.LegacyVisa;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.auth.AuthRedirectRequest;
import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.HiddenDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.SystemRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequest;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.PerfLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SetCookieVar;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.common.util.CAMEncoder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class LegacyProviderInstance
extends DefaultHandler {
    private static final String CAM = "CAM";
    private static final String CREDENTIAL = "credential";
    private static final String CREDENTIALS = "credentials";
    private static final String TRACKING = "tracking";
    private static final int DEFAULT_NUMBER_OF_CONNECTIONS = -1;
    private static final int DEFAULT_NATIVE_THREAD_STACK_SIZE = 0x100000;
    private static final String DEFAULT_SERVER_HOST = "localhost";
    private static final int DEFAULT_SERVER_PORT = 0;
    private static final String CONTENT_LOCALE = "contentLocale";
    private static final String PRODUCT_LOCALE = "productLocale";
    private static final String TITLE = "title";
    private static final String ANCESTORS = "ancestors";
    private static final String ITEM = "item";
    private static final String VALUE = "value";
    private static final String ADDITIONAL_INFO = "additionalInfo";
    private static final String OBJECT_CLASS = "objectClass";
    private static final String TYPED_LOGGER = "typedLogger";
    private static final String CAM_LOGON_AS = "logonAs";
    private static final String SEARCH_PATH = "searchPath";
    private static final String CLASS_NAME = LegacyProviderInstance.class.getName();
    private static final String TYPED_LOGGER_DEFAULT_VALUE = "Audit.RTUsage";
    private static final String HANDLE_REQUEST = "handleInboundRequest";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String NAMESPACE = "namespace";
    private LPSInstance lpsInstance;
    private PerfLoggerImpl perfLogger;

    public void destroy() {
        if (this.lpsInstance != null) {
            this.lpsInstance.terminate();
        }
        this.lpsInstance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(HandlerInfo theConfig) throws LocalizableException {
        boolean initialized = false;
        try {
            Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
            NamespaceManager namespaceManager = (NamespaceManager)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.NamespaceManager");
            String namespaceID = config.getMandatoryValue("./*[local-name()='parameter'][@name='id']/*[local-name()='value']/text()");
            int connectionCount = this.getConnectionsCount(config);
            int threadStackSize = this.getThreadStackSize(config);
            int serverPort = this.getServerPort(config);
            String serverHost = this.getServerHost(config);
            boolean sslEnabled = this.getSSLEnabled(config);
            this.lpsInstance = (LPSInstance)theConfig.get((Object)LPSInstanceImpl.class.getName());
            this.lpsInstance.initialize(namespaceID, connectionCount, threadStackSize, serverHost, serverPort, sslEnabled);
            ConfigureCommand configureCommand = new ConfigureCommand();
            configureCommand.setupConfiguration(config);
            this.lpsInstance.execute(configureCommand);
            String[] namespaceCapabilities = configureCommand.getNamespaceCapabilities();
            Namespace namespace = namespaceManager.getNamespace(CAMEncoder.encodeQuote((String)namespaceID));
            namespace.setCapabilities(namespaceCapabilities);
            namespace.setConformanceProperties(configureCommand.getConformanceProperties());
            SetNamespaceVersionCommand setNamespaceVersionCommand = new SetNamespaceVersionCommand();
            setNamespaceVersionCommand.setNamespaceId(namespaceID);
            setNamespaceVersionCommand.setNamespaceVersion(namespace.getNamespaceFormat());
            setNamespaceVersionCommand.setAdditionalInfo(this.constructAdditionalInfoElement(namespace.getAncestors(), null));
            this.lpsInstance.execute(setNamespaceVersionCommand);
            this.lpsInstance.setConfigForRestart(new LPSCommand[]{configureCommand, setNamespaceVersionCommand});
            LogTypedLogger perflogger = LogTypedLogger.getInstance((String)"Perf.CAM.AAA.LPS", LogPerfIndication.class);
            this.perfLogger = new PerfLoggerImpl(perflogger);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.destroy();
            }
        }
    }

    private void addCredentialToSoapRequest(SoapEnvelope soapRequest, Credential credential) throws LocalizableException {
        if (credential == null || soapRequest == null) {
            return;
        }
        boolean haveCredential = false;
        Element bibusHeaderElement = this.getBiBusHdr(soapRequest);
        Element camElement = bibusHeaderElement.element(CAM);
        if (camElement != null) {
            boolean bl = haveCredential = camElement.element(CREDENTIAL) != null || camElement.element(CREDENTIALS) != null;
        }
        if (!haveCredential) {
            if (camElement == null) {
                camElement = bibusHeaderElement.addElement(CAM);
            }
            Element credentialElement = camElement.addElement(CREDENTIAL);
            Element username = credentialElement.addElement(USERNAME);
            username.addText(credential.getCredentialValue(USERNAME));
            Element password = credentialElement.addElement(PASSWORD);
            password.addText(credential.getCredentialValue(PASSWORD));
            Element namespace = credentialElement.addElement(NAMESPACE);
            namespace.addText(credential.getCredentialValue(NAMESPACE));
        }
    }

    private void addSetCookieVarsToBiBusHeader(SetCookieVar[] setCookieVarsArray, BiBusHeader biBusHeader) {
        if (setCookieVarsArray != null) {
            for (int i = 0; i < setCookieVarsArray.length; ++i) {
                String name = setCookieVarsArray[i].getName();
                String value = setCookieVarsArray[i].getValue();
                Integer maxAge = setCookieVarsArray[i].getMaxAge();
                String domain = setCookieVarsArray[i].getDomain();
                String path = setCookieVarsArray[i].getPath();
                Boolean secureFlag = setCookieVarsArray[i].getSecureFlag();
                biBusHeader.setCookie(name, value, maxAge.intValue(), path, domain, secureFlag);
            }
        }
    }

    private Element constructAdditionalInfoElement(BaseClass[] ancestorsArray, RequestContext requestContext) {
        String contentLocale;
        String productLocale;
        Element docElement = org.dom4j.DocumentHelper.createElement((String)ADDITIONAL_INFO);
        docElement.addElement(TYPED_LOGGER).addText(TYPED_LOGGER_DEFAULT_VALUE);
        if (ancestorsArray != null) {
            Element ancestorsValueElement = docElement.addElement(ANCESTORS).addElement(VALUE);
            for (int i = 0; i < ancestorsArray.length; ++i) {
                Element itemElement = ancestorsValueElement.addElement(ITEM);
                itemElement.addElement(OBJECT_CLASS).addText(ancestorsArray[i].getObjectClass());
                itemElement.addElement(SEARCH_PATH).addText(ancestorsArray[i].getSearchPath().getValue());
                Element titleElement = itemElement.addElement(TITLE);
                String title = ancestorsArray[i].getDefaultName(requestContext);
                if (title == null) continue;
                titleElement.addText(title);
            }
        }
        if (requestContext != null) {
            productLocale = requestContext.getProductLocale().toString();
            contentLocale = requestContext.getContentLocale().toString();
        } else {
            productLocale = Locale.getDefault().toString();
            contentLocale = Locale.getDefault().toString();
        }
        docElement.addElement(PRODUCT_LOCALE).addText(productLocale);
        docElement.addElement(CONTENT_LOCALE).addText(contentLocale);
        return docElement;
    }

    private Element constructAdditionalInfoElement(MessageContext messageContext) {
        RequestContext requestContext = (RequestContext)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        Namespace namespace = (Namespace)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespaceObject");
        BaseClass[] ancestorsArray = namespace != null ? namespace.getAncestors() : null;
        return this.constructAdditionalInfoElement(ancestorsArray, requestContext);
    }

    private AuthenticateCommand constructAuthenticateRequest(MessageContext messageContext, SoapEnvelope soapRequest, String action) throws LocalizableException {
        AuthenticateCommand retval = null;
        AuthRedirectRequest authRedirectRequest = (AuthRedirectRequest)messageContext.remove((Object)"com.ibm.cognos.camaaa.internal.auth.AuthRedirectRequest");
        if (authRedirectRequest == null) {
            Element additionalInfoElement = this.constructAdditionalInfoElement(messageContext);
            LegacyVisa visa = (LegacyVisa)((Object)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa"));
            String namespaceID = (String)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
            Credential credential = null;
            Boolean trustedCredential = (Boolean)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted");
            Credential[] credentials = (Credential[])messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
            credential = credentials != null ? credentials[0] : (Credential)messageContext.get((Object)"requestCredentials");
            if (trustedCredential != null && trustedCredential.booleanValue()) {
                retval = new AuthenticateCommand(soapRequest, visa, credential, additionalInfoElement, namespaceID, action);
            } else {
                this.addCredentialToSoapRequest(soapRequest, credential);
                retval = new AuthenticateCommand(soapRequest, visa, null, additionalInfoElement, namespaceID, action);
            }
        } else {
            retval = new AuthenticateCommand(authRedirectRequest);
        }
        return retval;
    }

    private Element getBiBusHdr(SoapEnvelope soapRequest) {
        Element soapHdr;
        Element bibusHdr = null;
        Element envelope = ((SoapEnvRequestImpl)soapRequest).getElement();
        if (envelope != null && (soapHdr = envelope.element(XMLConstants.SOAPENV_HEADER)) != null) {
            bibusHdr = soapHdr.element(XMLConstants.BIBUS_BIBUSHEADER);
        }
        return bibusHdr;
    }

    private String getCamActionFromRequestType(int requestType, boolean logonExpired) {
        String action;
        switch (requestType) {
            case 4: {
                if (logonExpired) {
                    action = "logonExpired";
                    break;
                }
                action = "logoff";
                break;
            }
            case 2: {
                action = CAM_LOGON_AS;
                break;
            }
            case 6: {
                action = "generateCredential";
                break;
            }
            case 5: {
                action = "generateTC";
                break;
            }
            case 22: {
                action = CAM_LOGON_AS;
                break;
            }
            default: {
                throw new RuntimeException("Not Implemented yet...");
            }
        }
        return action;
    }

    private int getConnectionsCount(Configuration config) {
        int connectionsCount = this.getAdvancedConfigItemValue(config, "workerThreadCount", -1);
        if (connectionsCount < 1) {
            connectionsCount = -1;
        }
        return connectionsCount;
    }

    private boolean getSSLEnabled(Configuration config) throws LocalizableException {
        boolean useSSL;
        Configuration rootConfig = config.getRootConfiguration();
        String dispUrlStr = rootConfig.getOptionalValue("./*[local-name()='internalDispatcher']/*[local-name()='value']", "");
        try {
            URL dispUrl = new URL(dispUrlStr);
            useSSL = dispUrl.getProtocol().equalsIgnoreCase("https");
        }
        catch (MalformedURLException e) {
            useSSL = false;
        }
        String useSSLStrValue = this.getAdvancedConfigItemValue(config, "forceLPSvrSSL", null);
        if (useSSLStrValue != null) {
            useSSL = Boolean.valueOf(useSSLStrValue);
        }
        return useSSL;
    }

    private String getAdvancedConfigItemValue(Configuration config, String name, String defaultValue) {
        String value = config.getOptionalValue("./*[local-name()='parameter'][@name='advancedProperties']/*[local-name()='value']/*[local-name()='parameter'][lower-case(@name)='" + name.toLowerCase() + "']/*[local-name()='value']" + "/text()", "");
        if (value != null && value.length() > 0) {
            return value;
        }
        return defaultValue;
    }

    private int getAdvancedConfigItemValue(Configuration config, String name, int defaultValue) {
        String valueStr = this.getAdvancedConfigItemValue(config, name, null);
        if (valueStr != null) {
            try {
                return Integer.valueOf(valueStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private int getThreadStackSize(Configuration config) {
        return this.getAdvancedConfigItemValue(config, "workerThreadStackSize", 0x100000);
    }

    private String getServerHost(Configuration config) throws LocalizableException {
        String host = DEFAULT_SERVER_HOST;
        Configuration rootConfig = config.getRootConfiguration();
        String dispUrlStr = rootConfig.getOptionalValue("./*[local-name()='internalDispatcher']/*[local-name()='value']", "");
        try {
            URL dispUrl = new URL(dispUrlStr);
            host = dispUrl.getHost();
        }
        catch (MalformedURLException e) {
            host = DEFAULT_SERVER_HOST;
        }
        return host;
    }

    private int getServerPort(Configuration config) {
        return 0;
    }

    private void processSearchRequest(MessageContext messageContext, SoapEnvelope soapRequest) throws SoapFaultException {
        if (this.lpsInstance == null) {
            return;
        }
        try {
            Element additionalInfoElement = this.constructAdditionalInfoElement(messageContext);
            Element bibusHeaderElement = LegacyUtil.getBiBusHeaderElement(soapRequest);
            Query query = (Query)messageContext.get((Object)Query.class.getName());
            ((QueryImpl)query).addProperty(SEARCH_PATH);
            LegacyVisa visa = (LegacyVisa)((Object)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa"));
            QueryResult queryResult = (QueryResult)messageContext.get((Object)QueryResult.class.getName());
            Namespace namespace = (Namespace)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespaceObject");
            QueryCommand command = new QueryCommand(bibusHeaderElement, query, additionalInfoElement, visa, queryResult, namespace);
            this.lpsInstance.execute(command);
            command.populateResults(queryResult, namespace);
        }
        catch (SoapFaultException e) {
            throw e;
        }
        catch (LocalizableException e) {
            throw new SoapFaultException("Client", SoapFaultException.CLIENT_FAULT_STRING, CLASS_NAME, null, null, e.getLocalizableMessage(), e.getCause());
        }
    }

    private void putCredentialInMessageContext(Credential credential, MessageContext messageContext, Boolean trusted) {
        if (credential != null) {
            messageContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)new Credential[]{credential});
            messageContext.put((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted", (Object)trusted);
        }
    }

    private void putRedirectRequestInMessageContext(AuthRedirectRequest redirectRequest, MessageContext messageContext) throws SoapFaultException {
        if (redirectRequest != null) {
            try {
                SoapEnvelopeRequest orginalRequest = (SoapEnvelopeRequest)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
                Element requestElement = DocumentHelper.parseText((String)orginalRequest.toXML()).getRootElement();
                Element soapHdrElement = requestElement.element(XMLConstants.SOAPENV_HEADER);
                Element oldBibusHdr = soapHdrElement.element(XMLConstants.BIBUS_BIBUSHEADER);
                if (oldBibusHdr != null) {
                    oldBibusHdr.detach();
                }
                messageContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.redirectionNamespaceId", (Object)redirectRequest.getTargetNamespaceId());
                Element biBusHdr = DocumentHelper.parseText((String)redirectRequest.getAuthDoc()).getRootElement().element(XMLConstants.BIBUS_BIBUSHEADER);
                if (biBusHdr != null) {
                    biBusHdr.detach();
                    soapHdrElement.add(biBusHdr);
                }
                SoapEnvelopeRequestImpl newRequest = new SoapEnvelopeRequestImpl(requestElement);
                messageContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest", (Object)newRequest);
                SoapBody body = newRequest.getBody();
                SoapBodyEntry bodyEntry = body.getBodyEntry();
                Credential[] credentials = null;
                if (bodyEntry != null && bodyEntry.getType() == 2) {
                    credentials = ((LogonRequest)bodyEntry).getCredentials();
                }
                Object newCredential = null;
                if (credentials != null) {
                    newCredential = credentials[0];
                }
                if (newCredential != null) {
                    messageContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)new Credential[]{newCredential});
                    messageContext.put((Object)"requestCredentials", newCredential);
                }
            }
            catch (DocumentException e) {
                throw new InternalErrorException(((Object)((Object)this)).getClass().toString(), (Exception)((Object)e));
            }
        }
    }

    private void putVisaInMessageContext(LegacyVisa visa, MessageContext messageContext) {
        if (visa != null) {
            LegacyVisa orgVisa = (LegacyVisa)((Object)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa"));
            if (orgVisa != null) {
                orgVisa.transferFrom(visa);
            } else {
                messageContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa", (Object)visa);
            }
        }
    }

    private void updateTrackingInfo(SoapEnvelope soapRequest) {
        Element bibusHdr = this.getBiBusHdr(soapRequest);
        if (bibusHdr == null) {
            return;
        }
        Element trackingElement = bibusHdr.element(TRACKING);
        if (trackingElement != null) {
            Element additionalInfoElement = bibusHdr.element(ADDITIONAL_INFO);
            Element additionalInfoTrackingElement = null;
            if (additionalInfoElement != null) {
                additionalInfoTrackingElement = additionalInfoElement.element(TRACKING);
            }
            Element tracking = trackingElement.createCopy();
            if (additionalInfoTrackingElement != null) {
                additionalInfoElement.remove(additionalInfoTrackingElement);
                additionalInfoElement.add(tracking);
            } else if (additionalInfoElement != null) {
                additionalInfoElement.add(tracking);
            } else {
                Element docElement = org.dom4j.DocumentHelper.createElement((String)ADDITIONAL_INFO);
                docElement.add(tracking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        Object perfIndication = null;
        if (this.perfLogger != null && this.perfLogger.isEnabled(Logger.LEVEL1)) {
            RequestContext reqContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
            LogDataImpl perfLogData = (LogDataImpl)this.perfLogger.getLogData();
            perfLogData.init(HANDLE_REQUEST);
            perfIndication = this.perfLogger.logEnter(reqContext.getLogContext(), ComponentImpl.getInstance(), Logger.LEVEL1, LegacyProviderInstance.class.getName(), HANDLE_REQUEST, "sequenceID", (LogData)perfLogData);
        }
        SoapEnvelope soapRequest = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapBodyEntry reqBodyEntry = soapRequest.getBody().getBodyEntry();
        this.updateTrackingInfo(soapRequest);
        try {
            int requestType = reqBodyEntry.getType();
            switch (requestType) {
                case 4: {
                    LegacyVisa visa = (LegacyVisa)((Object)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa"));
                    if (visa != null && !visa.canLogoff()) {
                        return true;
                    }
                }
                case 2: 
                case 5: 
                case 6: 
                case 22: {
                    MessageContextImpl.PassportExpireEvent passportExpiredEvent = (MessageContextImpl.PassportExpireEvent)theContext.get((Object)MessageContextImpl.PASSPORT_EXPIRED_EVENT);
                    boolean expired = false;
                    if (passportExpiredEvent != null && passportExpiredEvent == MessageContextImpl.PassportExpireEvent.LOGONEXPIRED) {
                        expired = true;
                    }
                    this.processAuthenticationRequest(theContext, soapRequest, this.getCamActionFromRequestType(requestType, expired));
                    return true;
                }
                case 1: {
                    this.processSearchRequest(theContext, soapRequest);
                    return true;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            if (this.perfLogger != null && this.perfLogger.isEnabled(Logger.LEVEL1)) {
                LogDataImpl perfLogData = (LogDataImpl)this.perfLogger.getLogData();
                perfLogData.init(HANDLE_REQUEST);
                this.perfLogger.logExit(perfIndication, (LogData)perfLogData);
            }
        }
    }

    void processAuthenticationRequest(MessageContext messageContext, SoapEnvelope soapRequest, String action) throws SoapFaultException {
        if (this.lpsInstance == null) {
            return;
        }
        String namespaceID = (String)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        try {
            AuthenticateCommand command = this.constructAuthenticateRequest(messageContext, soapRequest, action);
            this.lpsInstance.execute(command);
            boolean generateTCRequest = soapRequest.getBody().getBodyEntry().getType() == 5;
            SoapEnvelopeResponse soapResponse = (SoapEnvelopeResponse)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
            SetCookieVar[] authResponseSetCookiesVarsArray = command.getResponseSetCookieVar();
            this.addSetCookieVarsToBiBusHeader(authResponseSetCookiesVarsArray, soapResponse.getHeader().getBiBusHeader());
            this.putVisaInMessageContext(command.getResponseVisa(), messageContext);
            this.putCredentialInMessageContext(command.getResponseCredential(), messageContext, generateTCRequest);
            this.putRedirectRequestInMessageContext(command.getResponseRedirectRequest(), messageContext);
        }
        catch (SoapFaultException e) {
            if (e instanceof UserRecoverableException) {
                DisplayObject[] dObjects;
                for (DisplayObject dObject : dObjects = e.getDisplayObjects()) {
                    if (!dObject.getName().equals("CAMNamespace")) continue;
                    dObject.setValue(namespaceID);
                }
            } else if (e instanceof SystemRecoverableException) {
                HiddenDisplayObject displayObject = new HiddenDisplayObject("CAMNamespace", namespaceID);
                ((SystemRecoverableException)e).addDisplayObject(displayObject);
            }
            throw e;
        }
        catch (LocalizableException e) {
            throw new InternalErrorException("Client", (Exception)((Object)e));
        }
    }

    void setLpsInstance4Test(LPSInstance theLpsInstance) {
        this.lpsInstance = theLpsInstance;
    }
}

