/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.sax.handlers;

import com.ibm.cognos.camaaa.internal.LPS.common.LegacyVisa;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.AccountHandler;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.BaseHandler;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.BaseHandlerBuilder;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.NamespaceHandler;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.UiClassHandler;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.UiClassWithMembersHandler;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.UiClass;
import com.ibm.cognos.camaaa.internal.admin.soap.UiClassWithMembers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class QueryResultHandler
extends BaseHandler {
    private static final String CAMID_START = "CAMID(\"";
    private static final String CAMID_END = "\")";
    private static final HashMap<String, BaseHandlerBuilder> HANDLERS = new HashMap();
    private final BaseHandler parent;
    private final QueryResult queryResult;
    private final Namespace namespace;
    private final LegacyVisa visa;
    private final boolean isMemberOf;

    public QueryResultHandler(XMLReader theReader, BaseHandler theParent, QueryResult theQueryResult, Namespace theNamespace, LegacyVisa theVisa, boolean theIsMemberOf) {
        super(theReader);
        this.parent = theParent;
        this.queryResult = theQueryResult;
        this.namespace = theNamespace;
        this.visa = theVisa;
        this.isMemberOf = theIsMemberOf;
    }

    private void addMemberShip(Account account) {
        BaseClass member;
        String searchPath;
        int length;
        List<String> groups = this.visa.getGroups();
        List<String> roles = this.visa.getRoles();
        int roleLength = 0;
        int groupLength = 0;
        if (roles != null) {
            roleLength = roles.size();
        }
        if (groups != null) {
            groupLength = groups.size();
        }
        if ((length = groupLength + roleLength) == 0) {
            return;
        }
        ArrayList<BaseClass> members = new ArrayList<BaseClass>();
        if (roles != null) {
            for (int i = 0; i < roles.size(); ++i) {
                searchPath = CAMID_START + roles.get(i) + CAMID_END;
                member = this.queryResult.create((SearchPath)new SearchPathImpl(searchPath), "role");
                members.add(member);
            }
        }
        if (groups != null) {
            for (int j = 0; j < groups.size(); ++j) {
                searchPath = CAMID_START + groups.get(j) + CAMID_END;
                member = this.queryResult.create((SearchPath)new SearchPathImpl(searchPath), "group");
                members.add(member);
            }
        }
        BaseClass[] groupRoles = members.toArray(new BaseClass[0]);
        account.setMemberOf(groupRoles);
    }

    @Override
    public BaseHandler endElement(String localName, String text) {
        if ("queryResult".equals(localName)) {
            return this.parent;
        }
        return this;
    }

    private String parseAttributeValue(String value) {
        String[] split = value.split(":");
        String type = split.length == 2 ? split[1] : split[0];
        return type;
    }

    protected void setUiClass(UiClass uiClass) {
        if (this.isMemberOf && uiClass instanceof Account) {
            this.addMemberShip((Account)uiClass);
        }
        this.queryResult.add((BaseClass)uiClass);
    }

    @Override
    public BaseHandler startElement(String localName, Attributes attributes) {
        if ("item".equals(localName)) {
            String type = null;
            String searchPath = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("type".equals(attributes.getLocalName(i))) {
                    String value = attributes.getValue(i);
                    type = this.parseAttributeValue(value);
                    continue;
                }
                if (!"searchPath".equals(attributes.getLocalName(i))) continue;
                searchPath = attributes.getValue(i);
            }
            BaseHandlerBuilder builder = HANDLERS.get(type);
            if (builder != null) {
                UiClass uiClass = (UiClass)this.queryResult.create((SearchPath)new SearchPathImpl(searchPath), type);
                this.setUiClass(uiClass);
                BaseHandler handler = builder.createHandler(this.getReader(), this, uiClass, this.queryResult, this.namespace);
                return handler;
            }
        }
        return this;
    }

    static {
        HANDLERS.put("account", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new AccountHandler(theReader, theParent, (Account)theUiClass, theQueryResult, theNamespace);
            }
        });
        HANDLERS.put("namespace", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new NamespaceHandler(theReader, theParent, (Namespace)theUiClass, theQueryResult, theNamespace);
            }
        });
        HANDLERS.put("namespaceFolder", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new UiClassHandler(theReader, theParent, theUiClass, theQueryResult, theNamespace){};
            }
        });
        HANDLERS.put("group", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new UiClassWithMembersHandler(theReader, theParent, theQueryResult, (UiClassWithMembers)theUiClass, theNamespace);
            }
        });
        HANDLERS.put("role", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new UiClassWithMembersHandler(theReader, theParent, theQueryResult, (UiClassWithMembers)theUiClass, theNamespace);
            }
        });
        HANDLERS.put("distributionList", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new UiClassWithMembersHandler(theReader, theParent, theQueryResult, (UiClassWithMembers)theUiClass, theNamespace);
            }
        });
    }
}

