/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.LPS.sax.handlers;

import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.AncestorsHandler;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.BaseHandler;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.BaseHandlerBuilder;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.LocalesHandler;
import com.ibm.cognos.camaaa.internal.LPS.sax.handlers.ValueHandler;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.UiClass;
import java.util.HashMap;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public abstract class UiClassHandler
extends BaseHandler {
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final HashMap<String, BaseHandlerBuilder> HANDLERS = new HashMap();
    private final Namespace namespace;
    private final BaseHandler parent;
    private final UiClass uiClass;
    private final QueryResult queryResult;

    public UiClassHandler(XMLReader theXMLReader, BaseHandler theParent, UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
        super(theXMLReader);
        this.parent = theParent;
        this.uiClass = theUiClass;
        this.queryResult = theQueryResult;
        this.namespace = theNamespace;
    }

    public BaseHandler createHandler(String theLocalName) {
        BaseHandlerBuilder builder = HANDLERS.get(theLocalName);
        if (builder == null) {
            return null;
        }
        return builder.createHandler(this.getReader(), this, this.uiClass, this.queryResult, this.namespace);
    }

    @Override
    public BaseHandler endElement(String theLocalName, String text) {
        if ("item".equals(theLocalName)) {
            return this.parent;
        }
        return this;
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }

    protected QueryResult getQueryResult() {
        return this.queryResult;
    }

    @Override
    public BaseHandler startElement(String theLocalName, Attributes attributes) {
        BaseHandler handler = this.createHandler(theLocalName);
        if (handler == null) {
            return this;
        }
        return handler;
    }

    static {
        HANDLERS.put("defaultName", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, final UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new ValueHandler(theReader, theParent){

                    @Override
                    void setValue(String text) {
                        theUiClass.addName(null, text);
                    }
                };
            }
        });
        HANDLERS.put("defaultDescription", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, final UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new ValueHandler(theReader, theParent){

                    @Override
                    void setValue(String text) {
                        theUiClass.addDescription(null, text);
                    }
                };
            }
        });
        HANDLERS.put("hasChildren", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, final UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new ValueHandler(theReader, theParent){

                    @Override
                    void setValue(String text) {
                        boolean hasChildren = Boolean.parseBoolean(text);
                        theUiClass.setHasChildren(Boolean.valueOf(hasChildren));
                    }
                };
            }
        });
        HANDLERS.put("ancestors", new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new AncestorsHandler(theReader, theParent, theQueryResult, theUiClass, theNamespace);
            }
        });
        HANDLERS.put(NAME, new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, final UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new LocalesHandler(theReader, theParent, UiClassHandler.NAME){

                    @Override
                    void setLocalizedValue(Locale locale, String value) {
                        theUiClass.addName(locale, value);
                    }
                };
            }
        });
        HANDLERS.put(DESCRIPTION, new BaseHandlerBuilder(){

            @Override
            public BaseHandler createHandler(XMLReader theReader, BaseHandler theParent, final UiClass theUiClass, QueryResult theQueryResult, Namespace theNamespace) {
                return new LocalesHandler(theReader, theParent, UiClassHandler.DESCRIPTION){

                    @Override
                    void setLocalizedValue(Locale locale, String value) {
                        theUiClass.addDescription(locale, value);
                    }
                };
            }
        });
    }
}

