/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMCachedIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIntegratedPolicy;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMLBPolicyFactory;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMPolicyFactory;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlModule;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.IdentityProvider;
import com.ibm.cognos.internal.camaaa.accesscontrol.IntegratedPolicy;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import com.ibm.cognos.internal.camaaa.accesscontrol.PolicyFactory;
import java.net.MalformedURLException;
import java.net.URL;
import org.dom4j.Element;

public final class AccessControlModuleImpl
implements AccessControlModule {
    private static AccessControlModuleImpl acModuleInstance;
    private static final String INTERNAL_DISPATCHER = "internalDispatcher";
    private static final String LB_POLICY_FACTORY_NAME = "lbPolicyFactoryName";
    private static final String POLICY_FACTORY_NAME = "policyFactoryName";
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 100;
    private static final int DEFAULT_CACHE_TIMEOUT_IN_SECONDS = 60;
    private int instanceCount;
    private URL queryServiceURL;
    private int maxHostConnections;
    private int cacheTimeOutInSeconds;
    private PolicyFactory lbPolicyFactory;
    private String lbPolicyFactoryName;
    private PolicyFactory policyFactory;
    private String policyFactoryName;
    private CAMIdentityProvider identityProvider;

    private AccessControlModuleImpl() {
    }

    private static int getCacheTimeOut(ICCLConfiguration cclConfig) throws AccessControlException, CCLConfigurationException {
        return 60;
    }

    public static synchronized AccessControlModuleImpl getInstance() {
        if (acModuleInstance == null) {
            acModuleInstance = new AccessControlModuleImpl();
        }
        return acModuleInstance;
    }

    private static String getLBPolicyFactoryName(ICCLConfiguration cclConfig) throws AccessControlException, CCLConfigurationException {
        String policyFactoryName = cclConfig.getValue(LB_POLICY_FACTORY_NAME, false);
        if (policyFactoryName == null) {
            throw new AccessControlException("AAA_ACM_E_CANNOT_GET_POLICY_FACTORY_NAME");
        }
        return policyFactoryName;
    }

    private static int getMaxHostConnections(ICCLConfiguration cclConfig) throws AccessControlException, CCLConfigurationException {
        return 100;
    }

    private static String getPolicyFactoryName(ICCLConfiguration cclConfig) throws AccessControlException, CCLConfigurationException {
        String policyFactoryName = cclConfig.getValue(POLICY_FACTORY_NAME, false);
        if (policyFactoryName == null) {
            throw new AccessControlException("AAA_ACM_E_CANNOT_GET_POLICY_FACTORY_NAME");
        }
        return policyFactoryName;
    }

    private static URL getQueryServiceURL(ICCLConfiguration cclConfig) throws AccessControlException, CCLConfigurationException {
        URL queryServiceURL;
        try {
            String serviceUrlStr = cclConfig.getValue(INTERNAL_DISPATCHER, false);
            if (serviceUrlStr == null || serviceUrlStr.length() == 0) {
                throw new AccessControlException("AAA_ACM_E_CANNOT_GET_SERVICE_URL");
            }
            queryServiceURL = new URL(serviceUrlStr);
        }
        catch (MalformedURLException e) {
            throw new AccessControlException("AAA_ACM_E_CANNOT_GET_SERVICE_URL", e);
        }
        return queryServiceURL;
    }

    private static PolicyFactory initPolicyFactory(String policyFactoryName) throws AccessControlException {
        try {
            Class<?> p = Class.forName(policyFactoryName);
            return (PolicyFactory)p.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AccessControlException("AAA_ACM_E_LOADING_POLICY_FACTORY", e);
        }
        catch (IllegalAccessException e) {
            throw new AccessControlException("AAA_ACM_E_LOADING_POLICY_FACTORY", e);
        }
        catch (InstantiationException e) {
            throw new AccessControlException("AAA_ACM_E_LOADING_POLICY_FACTORY", e);
        }
    }

    @Override
    public Identity getIdentity(Element soapHeader) throws AccessControlException {
        return this.identityProvider.getIdentity(soapHeader);
    }

    IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegratedPolicy getIntegratedPolicy() {
        AccessControlModuleImpl accessControlModuleImpl = this;
        synchronized (accessControlModuleImpl) {
            return new CAMIntegratedPolicy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Policy getLBPolicy() {
        AccessControlModuleImpl accessControlModuleImpl = this;
        synchronized (accessControlModuleImpl) {
            return this.lbPolicyFactory.createPolicy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Policy getPolicy() {
        AccessControlModuleImpl accessControlModuleImpl = this;
        synchronized (accessControlModuleImpl) {
            return this.policyFactory.createPolicy();
        }
    }

    private void increaseRefCount() {
        ++this.instanceCount;
    }

    @Override
    public synchronized void initialize() throws AccessControlException {
        ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
        try {
            if (cclConfig != null) {
                cclConfig.init();
            }
        }
        catch (CCLConfigurationException cause) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)cause));
        }
        this.initialize(cclConfig);
    }

    @Override
    public void initialize(ICCLConfiguration cclConfig) throws AccessControlException {
        this.initProviderConfig(cclConfig);
        CAMCachedIdentityProvider defaultIdentityProvider = new CAMCachedIdentityProvider(this.queryServiceURL, this.maxHostConnections, this.cacheTimeOutInSeconds);
        this.initialize(cclConfig, defaultIdentityProvider);
    }

    void initialize(ICCLConfiguration cclConfig, CAMIdentityProvider idProvider) throws AccessControlException {
        try {
            this.initPolicyFactoryConfig(cclConfig);
            this.initPolicyFactory(cclConfig);
            this.initLBPolicyFactory(cclConfig);
            this.identityProvider = idProvider;
            this.increaseRefCount();
        }
        catch (AccessControlException e) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)e));
        }
    }

    private void initLBPolicyFactory(ICCLConfiguration cclConfig) throws AccessControlException {
        try {
            if (this.lbPolicyFactory != null) {
                this.lbPolicyFactory = null;
            }
            this.lbPolicyFactory = this.lbPolicyFactoryName.length() != 0 ? AccessControlModuleImpl.initPolicyFactory(this.lbPolicyFactoryName) : new CAMLBPolicyFactory();
        }
        catch (AccessControlException e) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)e));
        }
    }

    private void initPolicyFactory(ICCLConfiguration cclConfig) throws AccessControlException {
        try {
            if (this.policyFactory != null) {
                this.policyFactory = null;
            }
            this.policyFactory = this.policyFactoryName.length() != 0 ? AccessControlModuleImpl.initPolicyFactory(this.policyFactoryName) : new CAMPolicyFactory();
        }
        catch (AccessControlException e) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)e));
        }
    }

    private void initPolicyFactoryConfig(ICCLConfiguration cclConfig) throws AccessControlException {
        try {
            this.policyFactoryName = AccessControlModuleImpl.getPolicyFactoryName(cclConfig);
            this.lbPolicyFactoryName = AccessControlModuleImpl.getLBPolicyFactoryName(cclConfig);
        }
        catch (CCLConfigurationException e) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)e));
        }
    }

    private void initProviderConfig(ICCLConfiguration cclConfig) throws AccessControlException {
        try {
            this.queryServiceURL = AccessControlModuleImpl.getQueryServiceURL(cclConfig);
            this.maxHostConnections = AccessControlModuleImpl.getMaxHostConnections(cclConfig);
            this.cacheTimeOutInSeconds = AccessControlModuleImpl.getCacheTimeOut(cclConfig);
        }
        catch (CCLConfigurationException e) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)e));
        }
    }

    @Override
    public void reconfigure() throws AccessControlException {
    }

    @Override
    public synchronized void terminate() {
        if (this.instanceCount > 0) {
            --this.instanceCount;
        } else {
            this.identityProvider.terminate();
            this.identityProvider = null;
        }
    }

    @Override
    public void testConfiguration(ICCLConfiguration config) throws AccessControlException {
        try {
            AccessControlModuleImpl.getQueryServiceURL(config);
            AccessControlModuleImpl.getMaxHostConnections(config);
            String factoryName = AccessControlModuleImpl.getPolicyFactoryName(config);
            String lbFactoryName = AccessControlModuleImpl.getLBPolicyFactoryName(config);
            if (factoryName.length() != 0) {
                AccessControlModuleImpl.initPolicyFactory(factoryName);
            }
            if (lbFactoryName.length() != 0) {
                AccessControlModuleImpl.initPolicyFactory(lbFactoryName);
            }
        }
        catch (AccessControlException e) {
            throw new AccessControlException("AAA_ACM_E_CONFIG_TEST_FAILED", (Exception)((Object)e));
        }
        catch (CCLConfigurationException e) {
            throw new AccessControlException("AAA_ACM_E_CONFIG_TEST_FAILED", (Exception)((Object)e));
        }
    }
}

