/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentityCache;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentityProvider;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.util.CAMAAServiceCommunicator;
import com.ibm.cognos.camaaa.internal.common.util.TimedObject;
import com.ibm.cognos.camaaa.internal.common.util.TimerPruningTask;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.dom4j.Element;
import org.dom4j.Node;

public class CAMCachedIdentityProvider
extends CAMIdentityProvider {
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final String CAM_PASSPORT_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']";
    private static final String CAM_PASSPORT_ID_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='id']/text()";
    private static final String CAM_PASSPORT_GENERATION_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='generation']/text()";
    private final long cacheTimeoutInSeconds;
    private Map camIdentityCache;
    private TimerPruningTask timerPruningTask;
    private Timer timer;

    CAMCachedIdentityProvider(CAMAAServiceCommunicator theConntectionHandler, long theCacheTimeoutInSeconds) {
        super(theConntectionHandler);
        this.cacheTimeoutInSeconds = theCacheTimeoutInSeconds;
        this.initPrunningTask();
    }

    CAMCachedIdentityProvider(long theCacheTimeoutInSeconds) {
        this.cacheTimeoutInSeconds = theCacheTimeoutInSeconds;
        this.initPrunningTask();
    }

    CAMCachedIdentityProvider(URL theQueryServiceURL, int maxHostConnections, long theCacheTimeoutInSeconds) throws AccessControlException {
        super(theQueryServiceURL, maxHostConnections);
        this.cacheTimeoutInSeconds = theCacheTimeoutInSeconds;
        this.initPrunningTask();
    }

    protected void addCAMIdentityToTheCache(CAMIdentityCache camIdentity) {
        this.camIdentityCache.put(camIdentity.getUniqueId(), camIdentity);
        this.timerPruningTask.add((TimedObject)camIdentity);
    }

    @Override
    protected Identity createIdentity(Element queryResponse) throws AccessControlException {
        return new CAMIdentityCache(queryResponse, this.cacheTimeoutInSeconds * 1000L, this);
    }

    protected Identity createIdentity(String passportId, List identityValueElements, TenancyInfo tenancyInfo) throws AccessControlException {
        return new CAMIdentityCache(passportId, identityValueElements, tenancyInfo, this.cacheTimeoutInSeconds * 1000L, this);
    }

    public void destroy() {
        this.timer.cancel();
        this.timer = null;
        if (this.camIdentityCache != null) {
            this.camIdentityCache.clear();
        }
    }

    protected int getCacheSize() {
        return this.camIdentityCache.size();
    }

    @Override
    public Identity getIdentity(Element soapHeader) throws AccessControlException {
        int generation;
        String camPassportID = this.getPassportID(soapHeader);
        Identity identity = this.getIdentityFromCache(camPassportID, generation = this.getIdentityGeneration(soapHeader));
        if (identity == null) {
            identity = super.getIdentity(soapHeader);
            this.addCAMIdentityToTheCache((CAMIdentityCache)identity);
        }
        return identity;
    }

    protected Identity getIdentityFromCache(String camPassportID, int generation) {
        CAMIdentityCache identity = null;
        CAMIdentityCache cachedIdentity = (CAMIdentityCache)this.camIdentityCache.get(camPassportID);
        if (cachedIdentity != null) {
            if (cachedIdentity.isExpired() || generation > cachedIdentity.getGeneration()) {
                this.camIdentityCache.remove(camPassportID);
                this.timerPruningTask.remove((TimedObject)cachedIdentity);
            } else {
                identity = cachedIdentity;
            }
        }
        return identity;
    }

    private int getIdentityGeneration(Element soapHeader) {
        String generationStr = DocumentHelper.valueOf((String)CAM_PASSPORT_GENERATION_XPATH, (Node)soapHeader);
        if (generationStr != null) {
            try {
                int generation = Integer.parseInt(generationStr);
                return generation;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private String getPassportID(Element soapHeader) {
        return DocumentHelper.valueOf((String)CAM_PASSPORT_ID_XPATH, (Node)soapHeader);
    }

    private void initPrunningTask() {
        this.camIdentityCache = Collections.synchronizedMap(new HashMap());
        this.timerPruningTask = new TimerPruningTask();
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this.timerPruningTask, 0L, this.cacheTimeoutInSeconds * 1000L);
    }

    void removeIdentityFromCache(String passportID) {
        this.camIdentityCache.remove(passportID);
    }

    protected void removeIdentityFromCacheAndTimer(String passportId) {
        CAMIdentityCache cachedIdentity = (CAMIdentityCache)this.camIdentityCache.remove(passportId);
        if (cachedIdentity != null) {
            this.timerPruningTask.remove((TimedObject)cachedIdentity);
        }
    }
}

