/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.auth.TenancyInfoImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;

class CAMIdentity
implements Identity {
    private static final String COGNOS_NAMESPACE = "";
    private static final String CAMID_START = "CAMID(";
    private static final String CAMID_END = ")";
    private static final int CAMID_PREFIX_LENGHT = 6;
    private final HashSet identities;
    private final TenancyInfo tenancy;

    CAMIdentity(Element queryResponse) throws AccessControlException {
        Element body = queryResponse.element(QName.get((String)"Body", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        if (body == null) {
            throw new AccessControlException("AAA_ACM_E_NO_SOAPBODY_IN_RESPONSE", new Object[]{new String(queryResponse.asXML())});
        }
        List idItems = body.selectNodes("./*/*/*[local-name()='self']/*[local-name()='item']");
        if (idItems.size() == 0) {
            throw new AccessControlException("AAA_ACM_E_NO_IDENTITIES_IN_RESPONSE", new Object[]{new String(queryResponse.asXML())});
        }
        this.tenancy = new TenancyInfoImpl();
        try {
            this.populateTenancy(body);
        }
        catch (SoapFaultException e) {
            throw new AccessControlException("AAA_ACM_E_NO_IDENTITIES_IN_RESPONSE", (Exception)((Object)e));
        }
        this.identities = new HashSet();
        this.populateIdentities(idItems);
    }

    CAMIdentity(List identityValueElements, TenancyInfo tenancyInfo) {
        this.tenancy = tenancyInfo;
        this.identities = new HashSet();
        this.populateIdentities(identityValueElements);
    }

    static String extractObjectId(String identity) {
        String doubleQuoteStr = "\"";
        String singleQuoteStr = "'";
        if (identity == null) {
            return null;
        }
        String id = identity;
        int index1 = -1;
        int indexDouble1 = identity.indexOf("\"");
        int indexSingle1 = identity.indexOf("'");
        boolean doubleQuotes = true;
        if (indexDouble1 != -1 && indexSingle1 != -1) {
            if (indexDouble1 < indexSingle1) {
                index1 = indexDouble1;
                doubleQuotes = true;
            } else {
                index1 = indexSingle1;
                doubleQuotes = false;
            }
        } else if (indexDouble1 != -1) {
            index1 = indexDouble1;
            doubleQuotes = true;
        } else {
            index1 = indexSingle1;
            doubleQuotes = false;
        }
        int index2 = -1;
        index2 = doubleQuotes ? identity.lastIndexOf("\"") : identity.lastIndexOf("'");
        if (index1 != -1 && index2 != -1 && index1 < index2) {
            id = identity.substring(index1 + 1, index2);
        }
        id = CAMIdentity.removeTrailingColon(id);
        return id;
    }

    static String extractPolicyObjectID(String identity) {
        String identity2 = CAMIdentity.removeCAMIDPrefix(identity);
        return CAMIdentity.extractObjectId(identity2);
    }

    private static String removeCAMIDPrefix(String identity) {
        if (identity == null) {
            return null;
        }
        String trimedIdentity = identity.trim();
        String identity2 = null;
        int indexCAMIDStart = trimedIdentity.indexOf(CAMID_START);
        int indexCAMIDEnd = trimedIdentity.lastIndexOf(CAMID_END);
        if (indexCAMIDStart == 0 && indexCAMIDEnd == trimedIdentity.length() - 1) {
            identity2 = trimedIdentity.substring(6, indexCAMIDEnd);
        }
        return identity2;
    }

    private static String removeTrailingColon(String identity) {
        if (identity == null || identity.length() == 0) {
            return identity;
        }
        String id = identity;
        int index = identity.lastIndexOf(58);
        if (index != -1 && index == identity.length() - 1) {
            id = identity.substring(0, index);
        } else if (index == 0 && identity.length() == 1) {
            id = COGNOS_NAMESPACE;
        }
        return id;
    }

    @Override
    public boolean contains(String identity) {
        String id = CAMIdentity.extractObjectId(identity);
        return this.identities.contains(id);
    }

    @Override
    public String[] getIdentities() {
        String[] retValue = new String[this.identities.size()];
        int i = 0;
        for (String str : this.identities) {
            retValue[i] = new String("CAMID(\"" + str + "\")");
            ++i;
        }
        return retValue;
    }

    @Override
    public TenancyInfo getTenancy() {
        return this.tenancy;
    }

    private void populateIdentities(List idItems) {
        for (int i = 0; i < idItems.size(); ++i) {
            Element idItem = (Element)idItems.get(i);
            String idStr = CAMIdentity.extractObjectId(idItem.getTextTrim());
            this.identities.add(idStr);
        }
    }

    private void populateTenancy(Element body) throws SoapFaultException {
        this.extractTenantInfo(body, "./*/*/*[local-name()='tenancy']/*[local-name()='tenantID']", TenancyInfo.TenancyType.TENANTID);
        this.extractMultiTenantInfo(body, "./*/*/*[local-name()='tenancy']/*[local-name()='readTenantIDs']/*[local-name()='item']", TenancyInfo.TenancyType.READ_TENANTID);
        this.extractTenantInfo(body, "./*/*/*[local-name()='tenancy']/*[local-name()='writeTenantID']", TenancyInfo.TenancyType.WRITE_TENANTID);
    }

    private void extractTenantInfo(Element body, String domSectionCriteria, TenancyInfo.TenancyType tenacyType) {
        Element tenantID = (Element)body.selectSingleNode(domSectionCriteria);
        if (tenantID != null) {
            this.tenancy.setTenancy(tenacyType, tenantID.getTextTrim());
        }
    }

    private void extractMultiTenantInfo(Element body, String domSelectionCriteria, TenancyInfo.TenancyType tenancyType) throws SoapFaultException {
        List tenantIDs = body.selectNodes(domSelectionCriteria);
        for (Node aNode : tenantIDs) {
            String aTenantID = aNode.getText();
            if (aTenantID == null || aTenantID.isEmpty()) continue;
            this.tenancy.addTenancies(tenancyType, new String[]{aTenantID});
        }
    }
}

