/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.CAMCachedIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentity;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.common.util.TimedObject;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class CAMIdentityCache
extends CAMIdentity
implements TimedObject {
    private static final String CAM_PASSPORT_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']";
    private static final String CAM_PASSPORT_ID_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='id']/text()";
    private static final String CAM_PASSPORT_GENERATION_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='generation']/text()";
    private final long startTime;
    private final long timeOutInMillis;
    private final String uniqueID;
    private int generation;
    private final CAMCachedIdentityProvider myIdentityProvider;

    public CAMIdentityCache(Element queryResponse, long theTimeoutInMs, CAMCachedIdentityProvider theIdentityProvider) throws AccessControlException {
        super(queryResponse);
        this.timeOutInMillis = theTimeoutInMs;
        this.startTime = System.currentTimeMillis();
        this.myIdentityProvider = theIdentityProvider;
        Element soapHeader = queryResponse.element(XMLConstants.SOAPENV_HEADER);
        this.uniqueID = DocumentHelper.valueOf((String)CAM_PASSPORT_ID_XPATH, (Node)soapHeader);
        String generationStr = DocumentHelper.valueOf((String)CAM_PASSPORT_GENERATION_XPATH, (Node)soapHeader);
        this.generation = 0;
        if (generationStr != null) {
            try {
                this.generation = Integer.parseInt(generationStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public CAMIdentityCache(String passportId, List identityValueElements, TenancyInfo tenancyInfo, long theTimeoutInMs, CAMCachedIdentityProvider theIdentityProvider) throws AccessControlException {
        super(identityValueElements, tenancyInfo);
        this.timeOutInMillis = theTimeoutInMs;
        this.startTime = System.currentTimeMillis();
        this.myIdentityProvider = theIdentityProvider;
        this.uniqueID = passportId;
        this.generation = 0;
    }

    public void cleanup() {
        this.myIdentityProvider.removeIdentityFromCacheAndTimer(this.uniqueID);
    }

    private long getElapsedTimeInMs() {
        return System.currentTimeMillis() - this.startTime;
    }

    public int getGeneration() {
        return this.generation;
    }

    public String getUniqueId() {
        return this.uniqueID;
    }

    public boolean isExpired() {
        return this.getElapsedTimeInMs() >= this.timeOutInMillis;
    }
}

