/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentity;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.util.CAMAAServiceCommunicator;
import com.ibm.cognos.camaaa.internal.common.util.CAMAAServiceHttpCommunicator;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_acm.Message;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.IdentityProvider;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.Element;

class CAMIdentityProvider
implements IdentityProvider {
    protected static final String CAM_AUTH_ACTION = "http://developer.cognos.com/schemas/bibus/3#CAM.auth";
    private static final String BODY_STR = "<SOAP-ENV:Body LockWait=\"0\"><bus:getIdentity xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"/></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final String ENVELOP_STR = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" >";
    private static final String BUS_NAMESPACE = "xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" ";
    private static final String ENC_NAMESPACE = "xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" ";
    private static final String END_BRACKET = ">";
    private static final String ENV_NAMESPACE = "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" ";
    private static final String XSD_NAMESPACE = "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ";
    private static final String XSI_NAMESPACE = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ";
    private final CAMAAServiceCommunicator connectionHandler;

    CAMIdentityProvider() {
        this.connectionHandler = null;
    }

    CAMIdentityProvider(CAMAAServiceCommunicator theConntectionHandler) {
        this.connectionHandler = theConntectionHandler;
    }

    CAMIdentityProvider(URL theQueryServiceURL, int maxHostConnections) throws AccessControlException {
        try {
            this.connectionHandler = new CAMAAServiceHttpCommunicator(theQueryServiceURL, maxHostConnections);
        }
        catch (LocalizableException e) {
            throw new AccessControlException("AAA_ACM_E_FAILED_TO_CREATE_HTTP_CLIENT", (Exception)((Object)e));
        }
    }

    void terminate() {
        if (this.connectionHandler != null) {
            this.connectionHandler.terminate();
        }
    }

    protected String constructSoapRequest(Element soapHeader) {
        StringBuffer soapRequest = new StringBuffer();
        soapRequest.append(ENVELOP_STR);
        soapRequest.append(soapHeader.asXML());
        soapRequest.append(BODY_STR);
        return soapRequest.toString();
    }

    protected Identity createIdentity(Element queryResponse) throws AccessControlException {
        return new CAMIdentity(queryResponse);
    }

    @Override
    public Identity getIdentity(Element soapHeader) throws AccessControlException {
        try {
            if (this.connectionHandler != null) {
                String soapRequest = this.constructSoapRequest(soapHeader);
                Document responseDoc = this.connectionHandler.processSoapRequest(soapRequest, CAM_AUTH_ACTION);
                return this.createIdentity(responseDoc.getRootElement());
            }
            throw new LocalizableException((LocalizableMessage)new Message("AAA_ACM_E_INTERNAL_ERROR"));
        }
        catch (LocalizableException e) {
            throw new AccessControlException("AAA_ACM_E_AUTHENTICATION_FAILED_FOR_IDENTITY", (Exception)((Object)e));
        }
    }
}

