/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.AccessControlModuleImpl;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlModule;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.IntegratedPolicy;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CAMIntegratedPolicy
implements IntegratedPolicy {
    private static final long serialVersionUID = 847362549601L;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private final AccessControlModule acm = AccessControlModuleImpl.getInstance();
    private Policy dacPolicy;
    private Policy lbPolicy;

    @Override
    public Object clone() throws CloneNotSupportedException {
        CAMIntegratedPolicy clonedPolicy = (CAMIntegratedPolicy)super.clone();
        clonedPolicy.dacPolicy = (Policy)this.dacPolicy.clone();
        clonedPolicy.lbPolicy = (Policy)this.lbPolicy.clone();
        return clonedPolicy;
    }

    @Override
    public void destroy() {
        if (this.dacPolicy != null) {
            this.dacPolicy.destroy();
            this.dacPolicy = null;
        }
        if (this.lbPolicy != null) {
            this.lbPolicy.destroy();
            this.lbPolicy = null;
        }
    }

    @Override
    public Policy getDACPolicy() {
        return this.dacPolicy;
    }

    @Override
    public Policy getLBPolicy() {
        return this.lbPolicy;
    }

    @Override
    public boolean isAccessGranted(Identity identity, String permission) {
        boolean lbPolicyAccess = true;
        if (this.lbPolicy != null) {
            lbPolicyAccess = this.lbPolicy.isAccessGranted(identity, permission);
        }
        boolean dacPolicyAccess = true;
        if (lbPolicyAccess && this.dacPolicy != null) {
            dacPolicyAccess = this.dacPolicy.isAccessGranted(identity, permission);
        }
        return lbPolicyAccess && dacPolicyAccess;
    }

    @Override
    public void readFrom(ByteArrayInputStream input) throws IOException {
        this.destroy();
        ObjectInputStream in = new ObjectInputStream(input);
        long serial = in.readLong();
        if (serial != 847362549601L) {
            throw new IOException("Unkown version: " + Long.toString(serial));
        }
        int theMajorVersion = in.readInt();
        in.readInt();
        if (theMajorVersion > 1) {
            throw new IOException("Unsupported version: " + Integer.toString(theMajorVersion));
        }
        boolean containsLbPolicy = in.readBoolean();
        boolean containsDacPolicy = in.readBoolean();
        if (containsLbPolicy) {
            this.lbPolicy = this.acm.getLBPolicy();
            this.lbPolicy.readFrom(input);
        }
        if (containsDacPolicy) {
            this.dacPolicy = this.acm.getPolicy();
            this.dacPolicy.readFrom(input);
        }
    }

    @Override
    public void setDACPolicy(Policy aDacPolicy) {
        if (this.dacPolicy != null) {
            this.dacPolicy.destroy();
        }
        this.dacPolicy = aDacPolicy;
    }

    @Override
    public void setLBPolicy(Policy anLbPolicy) {
        if (this.lbPolicy != null) {
            this.lbPolicy.destroy();
        }
        this.lbPolicy = anLbPolicy;
    }

    @Override
    public void writeTo(ByteArrayOutputStream output) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(output);
        out.writeLong(847362549601L);
        out.writeInt(1);
        out.writeInt(0);
        out.writeBoolean(this.lbPolicy != null);
        out.writeBoolean(this.dacPolicy != null);
        out.flush();
        if (this.lbPolicy != null) {
            this.lbPolicy.writeTo(output);
        }
        if (this.dacPolicy != null) {
            this.dacPolicy.writeTo(output);
        }
    }
}

