/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class CAMLBPolicy
implements Policy {
    private static final String SOAP_ENC_NS_PREFIX = "SOAP-ENC";
    private static final Namespace SOAP_ENC_NS = new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final Namespace XSD_NS = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final Namespace XSI_NS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final QName BIBUS_LBPOLICY = QName.get((String)"lbPolicy", (String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final QName AND_LABELS = QName.get((String)"andLabels");
    private static final QName OR_LABELS = QName.get((String)"orLabels");
    private static final QName TENANT_ID = QName.get((String)"tenantID");
    private static final QName SOAP_ENC_ARRAYTYPE = QName.get((String)"arrayType", (Namespace)SOAP_ENC_NS);
    private static final QName XSD_STRING = QName.get((String)"string", (Namespace)XSD_NS);
    private static final QName XSI_TYPE = QName.get((String)"type", (Namespace)XSI_NS);
    private static final String SOAP_ENC_ARRAY = QName.get((String)"Array", (Namespace)SOAP_ENC_NS).getQualifiedName();
    private static final String STRING_ARRAY = XSD_STRING.getQualifiedName();
    private static final long serialVersionUID = 164087134871L;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private List<String> requiredLabels = new LinkedList<String>();
    private List<String> optionalLabels = new LinkedList<String>();

    CAMLBPolicy() {
    }

    void addOptionalTenant(String anOptionalTenant) {
        this.optionalLabels.add(anOptionalTenant);
    }

    void addRequiredTenent(String aRequiredTenent) {
        this.requiredLabels.add(aRequiredTenent);
    }

    private boolean checkOptionalLabels(Set<String> identityLabels, String permission) {
        boolean access = false;
        access = this.optionalLabels.size() == 0 ? true : (identityLabels == null ? false : this.doesIdentityContainAtLeastOneLabel(identityLabels, this.optionalLabels));
        return access;
    }

    private boolean checkRequiredLabels(Set<String> identityLabels, String permission) {
        boolean access = false;
        access = this.requiredLabels.size() == 0 ? true : (identityLabels == null ? false : this.doesIdentityContainAllLabels(identityLabels, this.requiredLabels));
        return access;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CAMLBPolicy clonedPolicy = (CAMLBPolicy)super.clone();
        clonedPolicy.requiredLabels = (LinkedList)((LinkedList)this.requiredLabels).clone();
        clonedPolicy.optionalLabels = (LinkedList)((LinkedList)this.optionalLabels).clone();
        return clonedPolicy;
    }

    @Override
    public void destroy() {
        this.requiredLabels = new LinkedList<String>();
        this.optionalLabels = new LinkedList<String>();
    }

    private boolean doesIdentityContainAllLabels(Set<String> identityLabels, List<String> policyLabels) {
        boolean access = true;
        for (String aLabel : policyLabels) {
            if (identityLabels.contains(aLabel)) continue;
            access = false;
            break;
        }
        return access;
    }

    private boolean doesIdentityContainAtLeastOneLabel(Set<String> identityLabels, List<String> policyLabels) {
        boolean access = false;
        for (String aLabel : policyLabels) {
            if (!identityLabels.contains(aLabel)) continue;
            access = true;
            break;
        }
        return access;
    }

    @Override
    public Element getDescription() {
        Document doc = DocumentFactory.getInstance().createDocument();
        Element policyElement = doc.addElement(BIBUS_LBPOLICY);
        policyElement.addAttribute(XSI_TYPE, "lbPolicyArrayProp");
        policyElement.add(XSI_NS);
        policyElement.add(SOAP_ENC_NS);
        Element andLabels = policyElement.addElement(AND_LABELS);
        andLabels.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        andLabels.addAttribute(SOAP_ENC_ARRAYTYPE, STRING_ARRAY + "[" + this.requiredLabels.size() + "]");
        Iterator<String> lit = this.requiredLabels.iterator();
        while (lit.hasNext()) {
            Element tenantID = andLabels.addElement(TENANT_ID);
            tenantID.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
            tenantID.addText(lit.next());
        }
        Element orLabels = policyElement.addElement(OR_LABELS);
        orLabels.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        orLabels.addAttribute(SOAP_ENC_ARRAYTYPE, STRING_ARRAY + "[" + this.optionalLabels.size() + "]");
        Iterator<String> lit2 = this.optionalLabels.iterator();
        while (lit2.hasNext()) {
            Element tenantID = orLabels.addElement(TENANT_ID);
            tenantID.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
            tenantID.addText(lit2.next());
        }
        return policyElement;
    }

    private Set<String> getIdentityLabels(Identity identity) throws SoapFaultException {
        TenancyInfo tenancyInfo = identity.getTenancy();
        if (tenancyInfo == null) {
            return null;
        }
        HashSet<String> identityLabels = null;
        String tenantID = tenancyInfo.getTenancy(TenancyInfo.TenancyType.READ_TENANTID);
        if (tenantID == null || tenantID.isEmpty()) {
            tenantID = tenancyInfo.getTenancy(TenancyInfo.TenancyType.TENANTID);
        }
        if (tenantID != null && !tenantID.isEmpty()) {
            identityLabels = new HashSet<String>();
            identityLabels.add(tenantID);
        }
        return identityLabels;
    }

    @Override
    public void init(Element element) throws AccessControlException {
        this.destroy();
        List required = DocumentHelper.selectNodes((String)"./*[local-name()='andLabels']/*[local-name()='tenantID']", (Node)element);
        for (Element anElement : required) {
            String aTenantID = DocumentHelper.getElementText((Element)anElement);
            this.requiredLabels.add(aTenantID);
        }
        List optional = DocumentHelper.selectNodes((String)"./*[local-name()='orLabels']/*[local-name()='tenantID']", (Node)element);
        for (Element anElement : optional) {
            String aTenantID = DocumentHelper.getElementText((Element)anElement);
            this.optionalLabels.add(aTenantID);
        }
    }

    @Override
    public boolean isAccessGranted(Identity identity, String permission) {
        boolean access = false;
        if (this.isIdentityForSysAdmin(identity)) {
            access = true;
        } else {
            try {
                Set<String> identityLabels = this.getIdentityLabels(identity);
                access = this.checkRequiredLabels(identityLabels, permission) && this.checkOptionalLabels(identityLabels, permission);
            }
            catch (SoapFaultException soapFaultException) {
                // empty catch block
            }
        }
        return access;
    }

    private boolean isIdentityForSysAdmin(Identity identity) {
        return identity.contains("::System Administrators");
    }

    @Override
    public void readFrom(ByteArrayInputStream input) throws IOException {
        this.destroy();
        ObjectInputStream in = new ObjectInputStream(input);
        long serial = in.readLong();
        if (serial != 164087134871L) {
            throw new IOException("Unkown version: " + Long.toString(serial));
        }
        int theMajorVersion = in.readInt();
        in.readInt();
        if (theMajorVersion > 1) {
            throw new IOException("Unsupported version: " + Integer.toString(theMajorVersion));
        }
        int numRequiredLabels = in.readInt();
        for (int i = 0; i < numRequiredLabels; ++i) {
            this.requiredLabels.add(in.readUTF());
        }
        int numOptionalLabels = in.readInt();
        for (int i = 0; i < numOptionalLabels; ++i) {
            this.optionalLabels.add(in.readUTF());
        }
    }

    @Override
    public void writeTo(ByteArrayOutputStream output) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(output);
        out.writeLong(164087134871L);
        out.writeInt(1);
        out.writeInt(0);
        out.writeInt(this.requiredLabels.size());
        for (String requiredLabel : this.requiredLabels) {
            out.writeUTF(requiredLabel);
        }
        out.writeInt(this.optionalLabels.size());
        for (String optionalLabel : this.optionalLabels) {
            out.writeUTF(optionalLabel);
        }
        out.flush();
    }
}

