/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.Permission;
import com.ibm.cognos.camaaa.internal.accesscontrol.PolicyDescription;
import com.ibm.cognos.camaaa.internal.common.util.Blob;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Vector;
import org.dom4j.Element;

class CAMPolicy
implements Policy {
    public static final short MAJOR_VERSION = 1;
    public static final int MAJOR_VERSION_OFFSET = 0;
    public static final short MINOR_VERSION = 1;
    public static final int MINOR_VERSION_OFFSET = 2;
    public static final int NB_PERMISSION_OFFSET = 4;
    public static final int PERMISSION_INDEX_TABLE_OFFSET = 8;
    public static final String ADMINISTRATOR_IDENTITY = "::System Administrators";
    private static final int SIZE_OF_INT = 4;
    private static final String UTF8_ENCODING = "UTF-8";
    private byte[] policyBlob = null;

    private boolean checkAccess(Identity identity, String permission, int nbPermissions) {
        boolean retval = false;
        try {
            int indexTableOffset = 8;
            int firstPermissionOffset = nbPermissions * 4 + indexTableOffset;
            boolean matchFound = false;
            block2: for (int i = 0; i < nbPermissions; ++i) {
                String id;
                int j;
                if (matchFound) {
                    return retval;
                }
                int offset = Blob.getInt((byte[])this.policyBlob, (int)indexTableOffset);
                indexTableOffset += 4;
                String permissionName = Blob.getString((byte[])this.policyBlob, (int)(offset += firstPermissionOffset));
                if (permissionName.compareTo(permission) != 0) continue;
                int nbEntries = Blob.getInt((byte[])this.policyBlob, (int)(offset += permissionName.getBytes(UTF8_ENCODING).length + 1));
                offset += 4;
                for (j = 0; j < nbEntries; ++j) {
                    id = Blob.getString((byte[])this.policyBlob, (int)offset);
                    if (identity.contains(id)) {
                        retval = false;
                        matchFound = true;
                        break;
                    }
                    offset += id.getBytes(UTF8_ENCODING).length + 1;
                }
                if (matchFound) continue;
                nbEntries = Blob.getInt((byte[])this.policyBlob, (int)offset);
                offset += 4;
                for (j = 0; j < nbEntries; ++j) {
                    id = Blob.getString((byte[])this.policyBlob, (int)offset);
                    if (identity.contains(id)) {
                        retval = true;
                        matchFound = true;
                        continue block2;
                    }
                    offset += id.getBytes(UTF8_ENCODING).length + 1;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        CAMPolicy ret = (CAMPolicy)super.clone();
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            if (this.policyBlob != null) {
                ret.policyBlob = (byte[])this.policyBlob.clone();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            this.policyBlob = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean equalsTo(byte[] blob) {
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            boolean retval = true;
            if (this.policyBlob.length != blob.length) {
                retval = false;
            }
            for (int i = 0; i < blob.length; ++i) {
                if (this.policyBlob[i] == blob[i]) continue;
                retval = false;
            }
            return retval;
        }
    }

    boolean equalsTo(CAMPolicy p) {
        Vector v2;
        boolean retval = true;
        Vector v1 = this.getPermissions();
        if (v1 == null | (v2 = p.getPermissions()) == null) {
            throw new RuntimeException("PermissionVector is null for CAMPolicy in CAMPolicy.equals");
        }
        if (v1.size() != v2.size()) {
            retval = false;
        } else {
            for (int i = 0; i < v1.size(); ++i) {
                Permission a = (Permission)v1.get(i);
                boolean found = false;
                for (int j = 0; j < v2.size(); ++j) {
                    Permission b = (Permission)v2.get(j);
                    if (!b.getName().equals(a.getName()) || !Arrays.equals(b.getGrantedIds(), a.getGrantedIds()) || !Arrays.equals(b.getDeniedIds(), a.getDeniedIds())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formPolicyBlob(SortedMap permissions) throws AccessControlException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Object permissionOffSetsOut;
            Blob.writeShort((OutputStream)out, (short)1);
            Blob.writeShort((OutputStream)out, (short)1);
            Blob.writeInt((OutputStream)out, (int)permissions.size());
            if (permissions != null && permissions.size() != 0) {
                permissionOffSetsOut = new ByteArrayOutputStream();
                ByteArrayOutputStream permissionsOut = new ByteArrayOutputStream();
                Iterator it = permissions.values().iterator();
                int cursor = 0;
                while (it.hasNext()) {
                    Permission p = (Permission)it.next();
                    Blob.writeInt((OutputStream)permissionOffSetsOut, (int)cursor);
                    p.writeTo(permissionsOut);
                    permissionsOut.flush();
                    cursor = permissionsOut.size();
                }
                ((OutputStream)permissionOffSetsOut).flush();
                permissionsOut.flush();
                byte[] tmp = ((ByteArrayOutputStream)permissionOffSetsOut).toByteArray();
                if (tmp != null) {
                    out.write(tmp);
                }
                if ((tmp = permissionsOut.toByteArray()) != null) {
                    out.write(tmp);
                }
                ((ByteArrayOutputStream)permissionOffSetsOut).close();
                permissionsOut.close();
            }
            permissionOffSetsOut = this;
            synchronized (permissionOffSetsOut) {
                this.policyBlob = out.toByteArray();
            }
            out.close();
        }
        catch (IOException e) {
            throw new AccessControlException("AAA_ACM_E_INVALID_FORMAT_FOR_BLOB", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyDescription formPolicyElement() {
        PolicyDescription policyElement = new PolicyDescription();
        String camIDStart = "CAMID(\"";
        String camIDEnd = "\")";
        try {
            CAMPolicy cAMPolicy = this;
            synchronized (cAMPolicy) {
                if (this.policyBlob != null) {
                    int numOfPermissions = Blob.getInt((byte[])this.policyBlob, (int)4);
                    int indexTableOffset = 8;
                    int firstPermissionOffset = numOfPermissions * 4 + indexTableOffset;
                    for (int i = 0; i < numOfPermissions; ++i) {
                        String camId;
                        int j;
                        int offset = Blob.getInt((byte[])this.policyBlob, (int)indexTableOffset);
                        indexTableOffset += 4;
                        String permissionName = Blob.getString((byte[])this.policyBlob, (int)(offset += firstPermissionOffset));
                        int nbEntries = Blob.getInt((byte[])this.policyBlob, (int)(offset += permissionName.getBytes(UTF8_ENCODING).length + 1));
                        offset += 4;
                        if (nbEntries > 0) {
                            for (j = 0; j < nbEntries; ++j) {
                                String deniedId = Blob.getString((byte[])this.policyBlob, (int)offset);
                                camId = "CAMID(\"" + deniedId + "\")";
                                policyElement.addDeniedPermission(camId, permissionName);
                                offset += deniedId.getBytes(UTF8_ENCODING).length + 1;
                            }
                        }
                        nbEntries = Blob.getInt((byte[])this.policyBlob, (int)offset);
                        offset += 4;
                        if (nbEntries <= 0) continue;
                        for (j = 0; j < nbEntries; ++j) {
                            String grantedId = Blob.getString((byte[])this.policyBlob, (int)offset);
                            camId = "CAMID(\"" + grantedId + "\")";
                            policyElement.addGrantedPermission(camId, permissionName);
                            offset += grantedId.getBytes(UTF8_ENCODING).length + 1;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            return new PolicyDescription();
        }
        return policyElement;
    }

    @Override
    public Element getDescription() {
        PolicyDescription policyElement = this.formPolicyElement();
        return policyElement.getRootElement();
    }

    private Vector getPermissions() {
        try {
            PolicyDescription policyElement = this.formPolicyElement();
            SortedMap permissions = policyElement.getPermissions();
            return new Vector(permissions.values());
        }
        catch (AccessControlException e) {
            return null;
        }
    }

    @Override
    public void init(Element element) throws AccessControlException {
        SortedMap permissions = PolicyDescription.getPermissions(element);
        this.formPolicyBlob(permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAccessGranted(Identity identity, String permission) {
        if (identity.contains(ADMINISTRATOR_IDENTITY)) {
            return true;
        }
        boolean retval = true;
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            int nbPermissions;
            retval = this.validateBlob() ? ((nbPermissions = Blob.getInt((byte[])this.policyBlob, (int)4)) == 0 ? false : this.checkAccess(identity, permission, nbPermissions)) : false;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBlobNull() {
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            return this.policyBlob == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFrom(ByteArrayInputStream in) throws IOException {
        if (in.available() <= 0) {
            return;
        }
        int majorVersion = -1;
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            this.policyBlob = new byte[in.available()];
            in.read(this.policyBlob);
            majorVersion = Blob.getShort((byte[])this.policyBlob, (int)0);
        }
        if (majorVersion != 1) {
            throw new IOException("Invalid policy blob version in CAMPolicy.readExternal");
        }
    }

    private boolean validateBlob() {
        boolean retval = true;
        if (this.policyBlob == null) {
            retval = false;
        } else if (Blob.getShort((byte[])this.policyBlob, (int)0) != 1) {
            retval = false;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(ByteArrayOutputStream out) throws IOException {
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            if (this.policyBlob == null) {
                return;
            }
            out.write(this.policyBlob);
        }
        out.flush();
    }
}

