/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.common.util.Blob;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;

class Permission {
    private final String permissionName;
    private final HashSet deniedIds;
    private final HashSet grantedIds;

    Permission(String name) {
        this.permissionName = new String(name);
        this.deniedIds = new HashSet();
        this.grantedIds = new HashSet();
    }

    void addDeniedId(String id) {
        if (id != null) {
            this.deniedIds.add(id);
        }
    }

    void addGrantedId(String id) {
        if (id != null) {
            this.grantedIds.add(id);
        }
    }

    void dump(StringWriter out) {
        String newline = "\n";
        out.write(this.permissionName);
        out.write("\n# of denied ID = " + this.deniedIds.size() + "\n");
        Iterator it = this.deniedIds.iterator();
        while (it.hasNext()) {
            out.write((String)it.next());
            out.write("\n");
        }
        out.write("# of granted ID = " + this.grantedIds.size() + "\n");
        it = this.grantedIds.iterator();
        while (it.hasNext()) {
            out.write((String)it.next());
            out.write("\n");
        }
    }

    String[] getDeniedIds() {
        return this.deniedIds.toArray(new String[this.deniedIds.size()]);
    }

    String[] getGrantedIds() {
        return this.grantedIds.toArray(new String[this.grantedIds.size()]);
    }

    String getName() {
        return this.permissionName;
    }

    void writeTo(OutputStream out) throws IOException {
        Iterator it;
        Blob.writeUTF((OutputStream)out, (String)this.getName());
        if (this.deniedIds != null) {
            Blob.writeInt((OutputStream)out, (int)this.deniedIds.size());
            it = this.deniedIds.iterator();
            while (it.hasNext()) {
                Blob.writeUTF((OutputStream)out, (String)((String)it.next()));
            }
        }
        if (this.grantedIds != null) {
            Blob.writeInt((OutputStream)out, (int)this.grantedIds.size());
            it = this.grantedIds.iterator();
            while (it.hasNext()) {
                Blob.writeUTF((OutputStream)out, (String)((String)it.next()));
            }
        }
    }
}

