/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentity;
import com.ibm.cognos.camaaa.internal.accesscontrol.Permission;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

class PolicyDescription {
    private static final Namespace BIBUS_NS = new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
    private static final String SOAP_ENC_NS_PREFIX = "SOAP-ENC";
    private static final Namespace XSD_NS = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final Namespace SOAP_ENC_NS = new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final Namespace XSI_NS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final QName POLICIES = QName.get((String)"policies", (Namespace)BIBUS_NS);
    private static final QName POLICY = QName.get((String)"policy", (Namespace)BIBUS_NS);
    private static final String VALUE = "value";
    private static final String ITEM = "item";
    private static final String PERMISSIONS = "permissions";
    private static final String SECURITYOBJECT = "securityObject";
    private static final String SEARCHPATH = "searchPath";
    private static final String NAME = "name";
    private static final String ACCESS = "access";
    private static final String GRANT = "grant";
    private static final String DENY = "deny";
    private static final QName PERMISSION = QName.get((String)"permission", (Namespace)BIBUS_NS);
    private static final QName ACCESS_ENUM = QName.get((String)"accessEnum", (Namespace)BIBUS_NS);
    private static final String BRACKET_START = "[";
    private static final String BRACKET_END = "]";
    private static final String SOAP_ENC_ARRAY = QName.get((String)"Array", (Namespace)SOAP_ENC_NS).getQualifiedName();
    private static final QName SOAP_ENC_ARRAYTYPE = QName.get((String)"arrayType", (Namespace)SOAP_ENC_NS);
    private static final QName XSD_STRING = QName.get((String)"string", (Namespace)XSD_NS);
    private static final QName XSI_TYPE = QName.get((String)"type", (Namespace)XSI_NS);
    private static final Namespace XML_NS = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
    private static final QName XML_SPACE = QName.get((String)"space", (Namespace)XML_NS);
    private static final String PRESERVE_STRING = "preserve";
    private final HashMap policyItems;
    private final Element policyRoot;
    private final Element valueElement;

    PolicyDescription() {
        Document doc = DocumentFactory.getInstance().createDocument();
        this.policyRoot = doc.addElement(POLICIES);
        this.policyRoot.addAttribute(XSI_TYPE, QName.get((String)"policyArrayProp", (Namespace)BIBUS_NS).getQualifiedName());
        this.valueElement = this.policyRoot.addElement(VALUE);
        this.valueElement.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        this.valueElement.addAttribute(SOAP_ENC_ARRAYTYPE, POLICY.getQualifiedName() + BRACKET_START + "0" + BRACKET_END);
        this.valueElement.add(SOAP_ENC_NS);
        this.valueElement.add(XSD_NS);
        this.policyItems = new HashMap();
    }

    private static String getIdentity(Element policyItem) {
        String searchPath;
        String identity = null;
        String path = "./*[local-name()='securityObject']/*[local-name()='searchPath']/*[local-name()='value']";
        Element searchPathNode = (Element)policyItem.selectSingleNode("./*[local-name()='securityObject']/*[local-name()='searchPath']/*[local-name()='value']");
        if (searchPathNode != null && (searchPath = searchPathNode.getTextTrim()) != null) {
            identity = CAMIdentity.extractPolicyObjectID(searchPath);
        }
        return identity;
    }

    static SortedMap getPermissions(Element policyElement) throws AccessControlException {
        if (!(policyElement.getQName().equals((Object)POLICIES) || policyElement.getQName().getNamespaceURI().equals("") && policyElement.getQName().getName().equals(POLICIES.getName()))) {
            throw new AccessControlException("AAA_ACM_E_INVALID_QNAME_FOR_POLICY_ELEMENT");
        }
        Element policiesValue = policyElement.element(VALUE);
        List nodeList = policiesValue.elements();
        TreeMap permissionMap = new TreeMap();
        for (int i = 0; i < nodeList.size(); ++i) {
            List permNodes;
            Element policyItem = (Element)nodeList.get(i);
            String identity = PolicyDescription.getIdentity(policyItem);
            if (identity == null) {
                throw new AccessControlException("AAA_ACM_E_INVALID_QNAME_FOR_POLICY_ELEMENT");
            }
            Element permissionsElement = policyItem.element(PERMISSIONS);
            if (permissionsElement == null || (permNodes = permissionsElement.elements()).size() == 0) continue;
            for (int j = 0; j < permNodes.size(); ++j) {
                PolicyDescription.parsePermissions(permissionMap, identity, (Element)permNodes.get(j));
            }
        }
        return permissionMap;
    }

    private static void parsePermissions(SortedMap permissionMap, String identity, Element permissionsElement) {
        Element nameElement = permissionsElement.element(NAME);
        if (nameElement == null) {
            return;
        }
        String permissionName = nameElement.getTextTrim();
        Element accessElement = permissionsElement.element(ACCESS);
        if (accessElement == null) {
            return;
        }
        String access = accessElement.getTextTrim();
        Permission permission = (Permission)permissionMap.get(permissionName);
        if (permission == null) {
            permission = new Permission(permissionName);
            permissionMap.put(permissionName, permission);
        }
        if (access.compareTo(DENY) == 0) {
            permission.addDeniedId(identity);
        } else if (access.compareTo(GRANT) == 0) {
            permission.addGrantedId(identity);
        }
    }

    void addDeniedPermission(String camId, String name) {
        Element policyItem = this.getPolicyItem(camId);
        Element permissions = policyItem.element(PERMISSIONS);
        if (permissions == null) {
            permissions = policyItem.addElement(PERMISSIONS);
            permissions.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        }
        Element pItem = DocumentFactory.getInstance().createElement(ITEM);
        pItem.addAttribute(XSI_TYPE, PERMISSION.getQualifiedName());
        Element nameItem = pItem.addElement(NAME);
        nameItem.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
        nameItem.addAttribute(XML_SPACE, PRESERVE_STRING);
        nameItem.addText(name);
        Element accessItem = pItem.addElement(ACCESS);
        accessItem.addAttribute(XSI_TYPE, ACCESS_ENUM.getQualifiedName());
        accessItem.addText(DENY);
        permissions.add(pItem);
        int size = permissions.nodeCount();
        permissions.addAttribute(SOAP_ENC_ARRAYTYPE, PERMISSION.getQualifiedName() + BRACKET_START + size + BRACKET_END);
    }

    void addGrantedPermission(String camId, String name) {
        Element policyItem = this.getPolicyItem(camId);
        Element permissions = policyItem.element(PERMISSIONS);
        if (permissions == null) {
            permissions = policyItem.addElement(PERMISSIONS);
            permissions.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        }
        Element pItem = DocumentFactory.getInstance().createElement(ITEM);
        pItem.addAttribute(XSI_TYPE, PERMISSION.getQualifiedName());
        Element nameItem = pItem.addElement(NAME);
        nameItem.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
        nameItem.addAttribute(XML_SPACE, PRESERVE_STRING);
        nameItem.addText(name);
        Element accessItem = pItem.addElement(ACCESS);
        accessItem.addAttribute(XSI_TYPE, ACCESS_ENUM.getQualifiedName());
        accessItem.addText(GRANT);
        permissions.add(pItem);
        int size = permissions.nodeCount();
        permissions.addAttribute(SOAP_ENC_ARRAYTYPE, PERMISSION.getQualifiedName() + BRACKET_START + size + BRACKET_END);
    }

    private Element addPolicyItem(String camId) {
        String id = CAMIdentity.extractObjectId(camId);
        if (id == null) {
            return null;
        }
        Element policyItem = DocumentFactory.getInstance().createElement(ITEM);
        policyItem.addAttribute(XSI_TYPE, POLICY.getQualifiedName());
        Element securityObj = policyItem.addElement(SECURITYOBJECT);
        securityObj.addAttribute(XSI_TYPE, QName.get((String)"nil", (Namespace)BIBUS_NS).getQualifiedName());
        Element searchPath = securityObj.addElement(SEARCHPATH);
        searchPath.addAttribute(XSI_TYPE, QName.get((String)"stringProp", (Namespace)BIBUS_NS).getQualifiedName());
        Element value = searchPath.addElement(VALUE);
        value.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
        value.addAttribute(XML_SPACE, PRESERVE_STRING);
        value.addText(camId);
        List elements = this.valueElement.elements();
        elements.add(policyItem);
        this.policyItems.put(id, policyItem);
        elements = this.valueElement.elements();
        int size = elements.size();
        this.valueElement.addAttribute(SOAP_ENC_ARRAYTYPE, POLICY.getQualifiedName() + BRACKET_START + size + BRACKET_END);
        return policyItem;
    }

    SortedMap getPermissions() throws AccessControlException {
        return PolicyDescription.getPermissions(this.policyRoot);
    }

    Element getPolicyItem(String camId) {
        String id = CAMIdentity.extractObjectId(camId);
        Element retval = null;
        if (id != null) {
            Element policyItem = (Element)this.policyItems.get(id);
            retval = policyItem != null ? policyItem : this.addPolicyItem(camId);
        }
        return retval;
    }

    Element getRootElement() {
        return this.policyRoot;
    }
}

