/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.bridge;

import com.cognos.CAM.AAAException;
import com.cognos.CAM.AAA_AznRequest_t;
import com.cognos.CAM.AAA_Interface;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.camaaa.internal.accesscontrol.AccessControlModuleImpl;
import com.ibm.cognos.camaaa.internal.accesscontrol.BridgeIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.BridgeIdentityProviderImpl;
import com.ibm.cognos.camaaa.internal.bridge.BridgeHelper;
import com.ibm.cognos.camaaa.internal.bridge.QueryPolicyProperties;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogUtil;
import com.ibm.cognos.camaaa.internal.common.service.CAMAsyncServiceHandler;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlModule;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.xml.sax.SAXException;

public class CmBridge
implements AAA_Interface {
    static final String QUERYCM_REQUEST = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body LockWait=\"0\"><bus:query xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> <bus:requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:queryRequest[]\"><item><bus:search xsi:type=\"xsd:string\"></bus:search></item></bus:requests></bus:query></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final String THE_POLICY_DESCRIPTION_PARAM = "thePolicyDescription";
    private static final String THE_PROPERTIES_PARAM = "theProperties";
    private static final String THE_POLICY_BLOB_PARAM = "thePolicyBlob";
    private static final String THE_ADDITIONAL_INFO_PARAM = "theAdditionalInfo";
    private static final String THE_PASSPORT_ID_PARAM = "thePassportID";
    private static final String XSI_NS_DECL = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ";
    private static final String LEGACY_SOAP_ACTION = "http://developer.cognos.com/schemas/bibus/3#CAM.legacy";
    private static final String BIBUS_HEADER_XPATH = "/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader";
    private static final String ADDINFO_XPATH_EXPRESSION = "/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']";
    private static final XPath ADDINFO_XPATH = DocumentHelper.createXPath((String)"/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']");
    private static final String TAB = "\t\t";
    private static final String CLOSING_BRACKET = "]";
    private static final String OPENING_BRACKET = "=[";
    private static final String TERMINATE = "Terminate";
    private static final String PASSPORT_ID = "PassportID";
    private static final String PROPERTIES = "Properties";
    private static final String POLICY = "Policy";
    private static final String OWNER = "Owner";
    private static final String PERMISSION = "Permission";
    private static final String IDENTITY = "Identity";
    private static final String ACCESS_DENIED = "Access Denied";
    private static final String ACCESS_GRANTED = "Access Granted";
    private static final String POLICY_DESCRIPTION = "PolicyDescription";
    private static final String VERIFY_ACCESS = "VerifyAccess";
    private static final String UPDATE_POLICY = "UpdatePolicy";
    private static final String SEARCH = "Search";
    private static final String INITIALIZE = "Initialize";
    private static final String GET_IDENTITY_USING_PASSPORT = "GetIdentityUsingPassport";
    private static final String DUPLICATE_POLICY = "DuplicatePolicy";
    private static final String DESCRIBE_POLICY = "DescribePolicy";
    private static final String DELETE_POLICY = "DeletePolicy";
    private static final String CREATE_POLICY = "CreatePolicy";
    private static final String CHECK_ACCESS = "CheckAccess";
    private static final String BULK_CHECK_ACCESS = "BulkCheckAccess";
    private static final String AUTHENTICATE = "Authenticate";
    private static final String UPDATE_IDENTITY = "updateIdentity";
    private static final int DEFAULT_PASSPORT_GENERATION_NB = 0;
    private static final int DEFAULT_CACHE_TIMEOUT_IN_SECONDS_IDENTITY_PROVIDER = 60;
    private int referenceCount;
    private final AccessControlModule acm;
    private BridgeIdentityProvider identityProvider;
    private final BridgeHelper helper;

    public CmBridge() {
        this(CmBridge.getDefaultAccessControlModule(), CCLConfigurationFactory.getInstance(), null);
    }

    CmBridge(AccessControlModule theACM, ICCLConfiguration config, BridgeIdentityProvider theIdentityProvider) {
        this.helper = new BridgeHelper(config, CmBridge.class.getSimpleName());
        this.referenceCount = 0;
        this.acm = theACM;
        this.identityProvider = theIdentityProvider;
    }

    private static AccessControlModule getDefaultAccessControlModule() {
        return AccessControlModuleImpl.getInstance();
    }

    private synchronized int addRefCount() {
        return ++this.referenceCount;
    }

    public String Authenticate(String theAuthenticateDocument) throws AAAException {
        Object perfIndication = null;
        Element additionalInfoElement = null;
        try {
            Document requestDoc = this.helper.buildRequest(theAuthenticateDocument, LEGACY_SOAP_ACTION, null);
            perfIndication = this.helper.perfLogEntry(AUTHENTICATE, requestDoc, null);
            if (this.helper.isAuditLoggingEnabled()) {
                Element loggableSoapRequest = LogUtil.getLoggableSoapEnvelope((Element)requestDoc.getRootElement());
                LogData logData = this.helper.createLogData(AUTHENTICATE);
                logData.addParameter("Authenticate Request", loggableSoapRequest.asXML());
                additionalInfoElement = DocumentHelper.selectSingleElement((XPath)ADDINFO_XPATH, (Node)loggableSoapRequest);
                this.helper.logAuditIndication(AUTHENTICATE, "CallStart", logData.toString(), additionalInfoElement);
            }
            Element soapResponse = this.processSoapRequest(requestDoc, LEGACY_SOAP_ACTION);
            String response = DocumentHelper.toCompactUtf8String((Element)soapResponse, (boolean)false);
            this.updateIdentity(soapResponse, additionalInfoElement);
            this.helper.logExit(AUTHENTICATE, response, perfIndication, additionalInfoElement);
            return response;
        }
        catch (AAAException e) {
            this.helper.logException(AUTHENTICATE, (Exception)((Object)e), perfIndication, additionalInfoElement);
            throw e;
        }
        catch (SAXException e) {
            this.helper.logException(AUTHENTICATE, (Exception)e, perfIndication, additionalInfoElement);
            throw new AAAException((Throwable)e);
        }
    }

    public int BulkCheckAccess(String thePassportID, AAA_AznRequest_t[] theRequestArray, String theAdditionalInfo) throws AAAException {
        Object perfIndication = null;
        try {
            if (this.helper.isAuditLoggingEnabled()) {
                LogData logData = this.helper.createLogData(BULK_CHECK_ACCESS);
                logData.addParameter(THE_PASSPORT_ID_PARAM, thePassportID);
                this.helper.addObjectParameter("theRequestArray", theRequestArray, logData);
                logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
                this.helper.logAuditIndication(BULK_CHECK_ACCESS, "CallStart", logData.toString(), theAdditionalInfo);
            }
            perfIndication = this.helper.perfLogEntry(BULK_CHECK_ACCESS, null, theAdditionalInfo);
            boolean ret = false;
            if (theRequestArray == null) {
                this.helper.logExit(BULK_CHECK_ACCESS, String.valueOf(0), null, perfIndication, theAdditionalInfo);
                return 0;
            }
            Identity identity = this.GetIdentityUsingPassport(thePassportID, theAdditionalInfo);
            for (int i = 0; i < theRequestArray.length; ++i) {
                theRequestArray[i].nAccess = theRequestArray[i].PolicyBlob == null || theRequestArray[i].sPermission == null ? 1 : this.VerifyAccess(identity, theRequestArray[i].PolicyBlob, theRequestArray[i].sPermission, theRequestArray[i].sObjectOwnerCAMID, theAdditionalInfo);
            }
            this.helper.logExit(BULK_CHECK_ACCESS, String.valueOf(0), null, perfIndication, theAdditionalInfo);
            return 0;
        }
        catch (AAAException e) {
            this.helper.logException(BULK_CHECK_ACCESS, (Exception)((Object)e), perfIndication, theAdditionalInfo);
            throw e;
        }
    }

    public int CheckAccess(String thePassportID, byte[] thePolicyBlob, String theOwner, String thePermission, String theAdditionalInfo) throws AAAException {
        Object perfIndication = null;
        try {
            if (this.helper.isAuditLoggingEnabled()) {
                LogData logData = this.helper.createLogData(CHECK_ACCESS);
                logData.addParameter(THE_PASSPORT_ID_PARAM, thePassportID);
                this.helper.addObjectParameter(THE_POLICY_BLOB_PARAM, thePolicyBlob, logData);
                logData.addParameter("theOwner", theOwner);
                logData.addParameter("thePermission", thePermission);
                logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
                this.helper.logAuditIndication(CHECK_ACCESS, "CallStart", logData.toString(), theAdditionalInfo);
            }
            perfIndication = this.helper.perfLogEntry(CHECK_ACCESS, null, theAdditionalInfo);
            int retValue = 1;
            if (thePolicyBlob == null || thePermission == null) {
                this.helper.logExit(CHECK_ACCESS, String.valueOf(retValue), null, perfIndication, theAdditionalInfo);
                return retValue;
            }
            Identity identity = this.GetIdentityUsingPassport(thePassportID, theAdditionalInfo);
            retValue = this.VerifyAccess(identity, thePolicyBlob, thePermission, theOwner, theAdditionalInfo);
            this.helper.logExit(CHECK_ACCESS, String.valueOf(retValue), null, perfIndication, theAdditionalInfo);
            return retValue;
        }
        catch (AAAException e) {
            this.helper.logException(CHECK_ACCESS, (Exception)((Object)e), perfIndication, theAdditionalInfo);
            throw e;
        }
    }

    public byte[] CreatePolicy(String thePolicyDescription, String theAdditionalInfo) throws AAAException {
        Object perfIndication = this.helper.perfLogEntry(CREATE_POLICY, null, theAdditionalInfo);
        if (this.helper.isAuditLoggingEnabled()) {
            LogData logData = this.helper.createLogData(CREATE_POLICY);
            logData.addParameter(THE_POLICY_DESCRIPTION_PARAM, thePolicyDescription);
            logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
            this.helper.logAuditIndication(CREATE_POLICY, "CallStart", logData.toString(), theAdditionalInfo);
        }
        byte[] blob = null;
        Policy policy = this.acm.getPolicy();
        try {
            policy.init(DocumentHelper.parseText((String)thePolicyDescription).getRootElement());
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            policy.writeTo(o);
            blob = o.toByteArray();
            o.close();
        }
        catch (Exception e) {
            this.helper.logException(CREATE_POLICY, e, perfIndication, theAdditionalInfo);
            throw new AAAException(e.getLocalizedMessage());
        }
        this.helper.logExit(CREATE_POLICY, blob, null, perfIndication, theAdditionalInfo);
        return blob;
    }

    public int DeletePolicy(byte[] thePolicyBlob, String theAdditionalInfo) {
        Object perfIndication = this.helper.perfLogEntry(DELETE_POLICY, null, theAdditionalInfo);
        if (this.helper.isAuditLoggingEnabled()) {
            LogData logData = this.helper.createLogData(DELETE_POLICY);
            this.helper.addObjectParameter(THE_POLICY_BLOB_PARAM, thePolicyBlob, logData);
            logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
            this.helper.logAuditIndication(DELETE_POLICY, "CallStart", logData.toString(), theAdditionalInfo);
        }
        this.helper.logExit(DELETE_POLICY, String.valueOf(0), null, perfIndication, theAdditionalInfo);
        return 0;
    }

    private synchronized int deleteRefCount() {
        return --this.referenceCount;
    }

    public String DescribePolicy(String thePassportID, byte[] thePolicyBlob, String theProperties, String theAdditionalInfo) throws AAAException {
        String retValue;
        Object perfIndication;
        block8: {
            perfIndication = this.helper.perfLogEntry(DESCRIBE_POLICY, null, theAdditionalInfo);
            if (this.helper.isAuditLoggingEnabled()) {
                LogData logData = this.helper.createLogData(DESCRIBE_POLICY);
                logData.addParameter(THE_PASSPORT_ID_PARAM, thePassportID);
                this.helper.addObjectParameter(THE_POLICY_BLOB_PARAM, thePolicyBlob, logData);
                logData.addParameter(THE_PROPERTIES_PARAM, theProperties);
                logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
                this.helper.logAuditIndication(DESCRIBE_POLICY, "CallStart", logData.toString(), theAdditionalInfo);
            }
            retValue = null;
            try {
                if (thePolicyBlob == null) break block8;
                Policy myPolicy = this.acm.getPolicy();
                ByteArrayInputStream in = new ByteArrayInputStream(thePolicyBlob);
                try {
                    myPolicy.readFrom(in);
                    Element policyDescription = myPolicy.getDescription();
                    this.logDescribePolicyParams(thePassportID, theProperties, policyDescription, theAdditionalInfo);
                    if (thePassportID != null) {
                        QueryPolicyProperties queryProperties = new QueryPolicyProperties();
                        queryProperties.addPropsToPolicyDescription(policyDescription, theProperties, this, thePassportID);
                    }
                    retValue = DocumentHelper.toCompactUtf8String((Element)policyDescription, (boolean)true);
                }
                catch (IOException e) {
                    throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
                }
                catch (SAXException e) {
                    throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
                }
                catch (DocumentException e) {
                    throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (AAAException e) {
                this.helper.logException(DESCRIBE_POLICY, (Exception)((Object)e), perfIndication, theAdditionalInfo);
                throw e;
            }
        }
        this.helper.logExit(DESCRIBE_POLICY, retValue, null, perfIndication, theAdditionalInfo);
        return retValue;
    }

    public byte[] DuplicatePolicy(byte[] thePolicyBlob, String theAdditionalInfo) {
        Object perfIndication = this.helper.perfLogEntry(DUPLICATE_POLICY, null, theAdditionalInfo);
        if (this.helper.isAuditLoggingEnabled()) {
            LogData logData = this.helper.createLogData(DUPLICATE_POLICY);
            this.helper.addObjectParameter(THE_POLICY_BLOB_PARAM, thePolicyBlob, logData);
            logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
            this.helper.logAuditIndication(DUPLICATE_POLICY, "CallStart", logData.toString(), theAdditionalInfo);
        }
        byte[] blob = null;
        blob = (byte[])thePolicyBlob.clone();
        this.helper.logExit(DUPLICATE_POLICY, blob, null, perfIndication, theAdditionalInfo);
        return blob;
    }

    public boolean Failed(int theStatus) {
        return this.helper.failed(theStatus);
    }

    private String getIdentitiesString(Identity identity) {
        StringBuffer list = new StringBuffer("");
        String[] identities = identity.getIdentities();
        if (identities.length > 0) {
            list.append(identities[0]);
            for (int i = 1; i < identities.length; ++i) {
                list.append(", ");
                list.append(identities[i]);
            }
        }
        return list.toString();
    }

    private Identity GetIdentityUsingPassport(String thePassportID, String theAdditionalInfo) throws AAAException {
        if (this.helper.isTraceLoggingEnabled()) {
            LogData logData = this.helper.createLogData(GET_IDENTITY_USING_PASSPORT);
            logData.addParameter(THE_PASSPORT_ID_PARAM, thePassportID);
            this.helper.logTraceIndication(GET_IDENTITY_USING_PASSPORT, "CallStart", logData.toString(), theAdditionalInfo);
        }
        try {
            Identity identity = this.identityProvider.getIdentity(thePassportID, 0);
            this.logGetIdentityResponse(identity, theAdditionalInfo);
            return identity;
        }
        catch (AccessControlException e) {
            this.helper.logException(GET_IDENTITY_USING_PASSPORT, (Exception)((Object)e), null, theAdditionalInfo);
            throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String GetNamespaceList(String theAdditionalInfo, String theProperties) {
        return this.helper.getNamespaceList(theAdditionalInfo, theProperties);
    }

    public int Initialize(String theInitDocument, String theRuntimeInfo, String theAdditionalInfo) throws AAAException {
        Object perfIndication = this.helper.perfLogEntry(INITIALIZE, null, theAdditionalInfo);
        if (this.helper.isAuditLoggingEnabled()) {
            LogData logData = this.helper.createLogData(INITIALIZE);
            this.helper.logAuditIndication(INITIALIZE, "CallStart", logData.toString(), theAdditionalInfo);
        }
        try {
            if (this.addRefCount() == 1) {
                this.acm.initialize();
                this.identityProvider = new BridgeIdentityProviderImpl(60L);
            }
        }
        catch (AccessControlException e) {
            if (this.helper.isAuditLoggingEnabled()) {
                this.helper.logAuditIndication(INITIALIZE, "Failure", e.getLocalizedMessage(), theAdditionalInfo);
            }
            this.helper.logException(INITIALIZE, (Exception)((Object)e), perfIndication, theAdditionalInfo);
            throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
        }
        this.helper.logExit(INITIALIZE, "Success", null, perfIndication, theAdditionalInfo);
        return 0;
    }

    private void logDescribePolicyParams(String thePassportID, String theProperties, Element policyDescription, String theAdditionalInfo) {
        if (this.helper.isAuditLoggingEnabled()) {
            StringBuffer logData = new StringBuffer();
            logData.append(PASSPORT_ID);
            logData.append(OPENING_BRACKET);
            logData.append(thePassportID);
            logData.append(CLOSING_BRACKET);
            logData.append(TAB);
            logData.append(POLICY);
            logData.append(OPENING_BRACKET);
            logData.append(policyDescription.asXML());
            logData.append(CLOSING_BRACKET);
            logData.append(TAB);
            logData.append(PROPERTIES);
            logData.append(OPENING_BRACKET);
            logData.append(theProperties);
            logData.append(CLOSING_BRACKET);
            this.helper.logAuditIndication(DESCRIBE_POLICY, "Info", logData.toString(), theAdditionalInfo);
        }
    }

    private void logGetIdentityResponse(Identity identity, String theAdditionalInfo) {
        if (this.helper.isTraceLoggingEnabled()) {
            StringBuffer logData = new StringBuffer();
            logData.append(IDENTITY);
            logData.append(OPENING_BRACKET);
            logData.append(this.getIdentitiesString(identity));
            logData.append(CLOSING_BRACKET);
            this.helper.logTraceIndication(GET_IDENTITY_USING_PASSPORT, "Info", logData.toString(), theAdditionalInfo);
        }
    }

    private void logVerifyAccessDenied(String theAdditionalInfo) {
        if (this.helper.isTraceLoggingEnabled()) {
            this.helper.logTraceIndication(VERIFY_ACCESS, ACCESS_DENIED, null, theAdditionalInfo);
        }
    }

    private void logVerifyAccessGranted(String theAdditionalInfo) {
        if (this.helper.isTraceLoggingEnabled()) {
            this.helper.logTraceIndication(VERIFY_ACCESS, ACCESS_GRANTED, null, theAdditionalInfo);
        }
    }

    private void logVerifyAccessParams(Identity identity, Policy policy, String thePermission, String theOwner, String theAdditionalInfo) {
        if (this.helper.isTraceLoggingEnabled()) {
            StringBuffer logData = new StringBuffer();
            logData.append(IDENTITY);
            logData.append(OPENING_BRACKET);
            logData.append(this.getIdentitiesString(identity));
            logData.append(CLOSING_BRACKET);
            logData.append(TAB);
            logData.append(POLICY_DESCRIPTION);
            logData.append(OPENING_BRACKET);
            logData.append(policy.getDescription().asXML());
            logData.append(CLOSING_BRACKET);
            logData.append(TAB);
            logData.append(PERMISSION);
            logData.append(OPENING_BRACKET);
            logData.append(thePermission);
            logData.append(CLOSING_BRACKET);
            logData.append(TAB);
            logData.append(OWNER);
            logData.append(OPENING_BRACKET);
            logData.append(theOwner);
            logData.append(CLOSING_BRACKET);
            this.helper.logTraceIndication(VERIFY_ACCESS, "Info", logData.toString(), theAdditionalInfo);
        }
    }

    private Element processSoapRequest(Document requestEnvelope, String action) throws AAAException {
        Element responseEnvelope;
        try {
            responseEnvelope = CAMAsyncServiceHandler.getInstance().invokeImpl(requestEnvelope, action);
        }
        catch (LocalizableException e) {
            throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
        }
        Element soapHdr = responseEnvelope.element(XMLConstants.SOAPENV_HEADER);
        Element cam = this.getCAMSection(soapHdr);
        Element headerFault = null;
        if (cam != null) {
            headerFault = cam.element("exception");
        }
        if (headerFault != null) {
            this.helper.setQueryResponseInTheBody(responseEnvelope);
        } else if (this.checkForBodyFault(responseEnvelope)) {
            throw new AAAException(responseEnvelope.asXML());
        }
        return responseEnvelope;
    }

    private boolean checkForBodyFault(Element responseEnvelope) {
        Element soapBody;
        if (responseEnvelope != null && (soapBody = responseEnvelope.element(XMLConstants.SOAPENV_BODY)) != null) {
            return soapBody.element("Fault") != null;
        }
        return false;
    }

    private Element getCAMSection(Element soapHdr) {
        Element bibusHdr;
        Element cam = null;
        if (soapHdr != null && (bibusHdr = soapHdr.element(XMLConstants.BIBUS_BIBUSHEADER)) != null) {
            cam = bibusHdr.element("CAM");
        }
        return cam;
    }

    public int Reconfigure(String theRuntimeInfo, String theAdditionalInfo) {
        return 0;
    }

    public String Search(String thePassportID, String theSearchSpecification) throws AAAException {
        Object perfIndication = null;
        Element additionalInfoElement = null;
        try {
            Document requestDoc = this.helper.buildRequest(theSearchSpecification, LEGACY_SOAP_ACTION, thePassportID);
            perfIndication = this.helper.perfLogEntry(SEARCH, requestDoc, null);
            if (this.helper.isAuditLoggingEnabled()) {
                LogData logData = this.helper.createLogData(SEARCH);
                logData.addParameter("Search Request", requestDoc.asXML());
                additionalInfoElement = DocumentHelper.selectSingleElement((XPath)ADDINFO_XPATH, (Node)requestDoc);
                this.helper.logAuditIndication(SEARCH, "CallStart", logData.toString(), additionalInfoElement);
            }
            Element soapResponse = this.processSoapRequest(requestDoc, LEGACY_SOAP_ACTION);
            Element queryResponse = this.helper.trimSearchResponse(soapResponse);
            String ret = DocumentHelper.toCompactUtf8String((Element)queryResponse, (boolean)false);
            this.helper.logExit(SEARCH, ret, perfIndication, additionalInfoElement);
            return ret;
        }
        catch (SAXException e) {
            this.helper.logException(SEARCH, (Exception)e, perfIndication, additionalInfoElement);
            throw new AAAException((Throwable)e);
        }
        catch (AAAException e) {
            this.helper.logException(SEARCH, (Exception)((Object)e), perfIndication, additionalInfoElement);
            throw e;
        }
    }

    public boolean Succeeded(int theStatus) {
        return theStatus >= 0;
    }

    public int Terminate(String theTerminateDocument, String theAdditionalInfo) {
        Object perfIndication = this.helper.perfLogEntry(TERMINATE, null, theAdditionalInfo);
        if (this.helper.isAuditLoggingEnabled()) {
            LogData logData = this.helper.createLogData(TERMINATE);
            logData.addParameter("theTerminateDocument", theTerminateDocument);
            logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
            this.helper.logAuditIndication(TERMINATE, "CallStart", logData.toString(), theAdditionalInfo);
        }
        int refCount = this.deleteRefCount();
        int status = 0;
        if (refCount < 0) {
            status = -3;
        }
        this.helper.logExit(TERMINATE, String.valueOf(status), null, perfIndication, theAdditionalInfo);
        return status;
    }

    private void updateIdentity(Element authenticateResponse, Element theAdditionalInfo) throws AAAException {
        try {
            if (this.helper.isAuditLoggingEnabled()) {
                LogData logData = this.helper.createLogData(UPDATE_IDENTITY);
                this.helper.logAuditIndication(UPDATE_IDENTITY, "CallStart", logData.toString(), theAdditionalInfo);
            }
            this.identityProvider.updateIdentity(authenticateResponse);
            this.helper.logExit(UPDATE_IDENTITY, "Success", null, theAdditionalInfo);
        }
        catch (AccessControlException e) {
            this.helper.logException(UPDATE_IDENTITY, (Exception)((Object)e), null, theAdditionalInfo);
            throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public byte[] UpdatePolicy(byte[] thePolicyBlob, String thePolicyDescription, String theAdditionalInfo) throws AAAException {
        Object perfIndication = null;
        try {
            if (this.helper.isAuditLoggingEnabled()) {
                LogData logData = this.helper.createLogData(UPDATE_POLICY);
                this.helper.addObjectParameter(THE_POLICY_BLOB_PARAM, thePolicyBlob, logData);
                logData.addParameter(THE_POLICY_DESCRIPTION_PARAM, thePolicyDescription);
                logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
                this.helper.logAuditIndication(UPDATE_POLICY, "CallStart", logData.toString(), theAdditionalInfo);
            }
            perfIndication = this.helper.perfLogEntry(UPDATE_POLICY, null, theAdditionalInfo);
            byte[] blob = null;
            this.DeletePolicy(thePolicyBlob, theAdditionalInfo);
            blob = this.CreatePolicy(thePolicyDescription, theAdditionalInfo);
            this.helper.logExit(UPDATE_POLICY, blob, null, perfIndication, theAdditionalInfo);
            return blob;
        }
        catch (AAAException e) {
            this.helper.logException(UPDATE_POLICY, (Exception)((Object)e), perfIndication, theAdditionalInfo);
            throw e;
        }
    }

    private int VerifyAccess(Identity identity, byte[] thePolicyBlob, String thePermission, String theOwner, String theAdditionalInfo) throws AAAException {
        int retValue = 2;
        if (theOwner != null && theOwner.length() > 0 && identity.contains(theOwner)) {
            retValue = 0;
        } else {
            try {
                Policy myPolicy = this.acm.getPolicy();
                ByteArrayInputStream in = new ByteArrayInputStream(thePolicyBlob);
                myPolicy.readFrom(in);
                this.logVerifyAccessParams(identity, myPolicy, thePermission, theOwner, theAdditionalInfo);
                if (myPolicy.isAccessGranted(identity, thePermission)) {
                    retValue = 0;
                    this.logVerifyAccessGranted(theAdditionalInfo);
                } else {
                    retValue = 1;
                    this.logVerifyAccessDenied(theAdditionalInfo);
                }
            }
            catch (IOException e) {
                this.helper.logException(VERIFY_ACCESS, (Exception)e, null, theAdditionalInfo);
                throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return retValue;
    }
}

