/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.bridge;

import com.cognos.CAM.AAAException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class GenerateTCResponseConverter {
    private GenerateTCResponseConverter() {
    }

    private static void addTrustedCredentialToHeader(String trustedCredential, Element camElement) {
        Element credentialElement = camElement.addElement("CAMTrustedCredential");
        String xsdPrefix = "xsd";
        credentialElement.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        credentialElement.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        credentialElement.addAttribute("xsi:type", "xsd:anyType");
        credentialElement.setText(trustedCredential);
    }

    public static void convertToTrustedCredentials(Element soapEnvelope) throws AAAException {
        Element cam = (Element)DocumentHelper.selectSingleNode((String)"*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']", (Node)soapEnvelope);
        Element credentialPath = cam.element("CAMCredentialPath");
        String path = DocumentHelper.valueOf((String)"*[local-name()='CAMCredentialPath']", (Node)cam);
        String trustedCredential = GenerateTCResponseConverter.queryCmForCredentials(path);
        GenerateTCResponseConverter.addTrustedCredentialToHeader(trustedCredential, cam);
        cam.remove(credentialPath);
    }

    private static String queryCmForCredentials(String credentialPath) throws AAAException {
        Document requestDoc;
        String cmRequest = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body LockWait=\"0\"><bus:query xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> <bus:requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:queryRequest[]\"><item><bus:search xsi:type=\"xsd:string\"></bus:search></item></bus:requests></bus:query></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        try {
            requestDoc = DocumentHelper.parseText((String)"<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body LockWait=\"0\"><bus:query xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"> <bus:requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:queryRequest[]\"><item><bus:search xsi:type=\"xsd:string\"></bus:search></item></bus:requests></bus:query></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        }
        catch (DocumentException e) {
            throw new AAAException(e.getLocalizedMessage());
        }
        Element soapRequest = requestDoc.getRootElement();
        Element queryRequestItem = (Element)DocumentHelper.selectSingleNode((String)"./*[local-name()='Body']/*[local-name()='query']/*[local-name()='requests']/*", (Node)soapRequest);
        Element search = (Element)DocumentHelper.selectSingleNode((String)"*[local-name()='Body']/*[local-name()='query']/*[local-name()='requests']/*/*[local-name()='search']", (Node)soapRequest);
        search.setText(credentialPath);
        Element properties = queryRequestItem.addElement("properties");
        Element itemProp = properties.addElement("item");
        itemProp.addText("credentials");
        SAXReader reader = new SAXReader();
        try {
            String xmlResponse = CMAccessor.getInstance().invoke(soapRequest.asXML());
            Document doc = reader.read((Reader)new StringReader(xmlResponse));
            return DocumentHelper.valueOf((String)"/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']/*/*/*/*/*[local-name()='credentials']/*[local-name()='value']", (Node)doc.getRootElement());
        }
        catch (Exception e) {
            throw new AAAException(e.getLocalizedMessage());
        }
    }
}

