/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.bridge;

import com.cognos.CAM.AAAException;
import com.ibm.cognos.camaaa.internal.bridge.CmBridge;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

public final class QueryPolicyProperties {
    private static final String OBJECT_CLASS = "objectClass";
    private static final String TYPE = "type";
    private static final Namespace XSI_NS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final Namespace BIBUS_NS = new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
    private static final String ITEM = "item";
    private static final String QUERY_REQUEST = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Header></SOAP-ENV:Header><SOAP-ENV:Body><bus:query></bus:query></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final String PROPERTIES = "<properties xmlns=\"http://developer.cognos.com/schemas/bibus/2/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/2/\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"  xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"  xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"></properties>";
    private static final XPath XPATH_SEARCH_PATH = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='searchPath']/*[local-name()='value']");
    private static final XPath XPATH_SECURITY_OBJECT = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='securityObject']");

    public void addPropsToPolicyDescription(Element description, String theProperties, CmBridge bridge, String passportID) throws DocumentException, AAAException {
        Element properties = this.addSearchPathObjectClassToQueryProperties(theProperties);
        List list = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectNodes((String)"../*/value/item", (Node)description);
        boolean updateObjectForPolicy = false;
        updateObjectForPolicy = theProperties == null ? false : theProperties.indexOf(OBJECT_CLASS) != -1;
        for (int i = 0; i < list.size(); ++i) {
            Element policy = (Element)list.get(i);
            String searchResult = this.searchForProperties(policy, properties, bridge, passportID);
            this.updatePolicy(policy, searchResult, updateObjectForPolicy);
        }
    }

    private Element addSearchPathObjectClassToQueryProperties(String properties) throws DocumentException {
        Element item;
        Element propElement;
        if (properties != null) {
            Document prop = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)properties);
            propElement = prop.getRootElement();
        } else {
            propElement = this.createPropertiesRootElement();
        }
        String searchPath = "searchPath";
        if (properties == null || properties.indexOf("searchPath") == -1) {
            item = propElement.addElement(ITEM);
            item.setText("searchPath");
        }
        if (properties == null || properties.indexOf(OBJECT_CLASS) == -1) {
            item = propElement.addElement(ITEM);
            item.setText(OBJECT_CLASS);
        }
        return propElement;
    }

    private Element createPropertiesRootElement() throws DocumentException {
        Document doc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)PROPERTIES);
        return doc.getRootElement();
    }

    private String extractObjectType(Element itemElement) {
        int pos;
        String typeValue = itemElement.attributeValue(TYPE);
        String objectType = typeValue != null ? ((pos = typeValue.indexOf(":")) != -1 ? typeValue.substring(pos + 1) : typeValue) : "nil";
        return objectType;
    }

    private String formQueryRequest(String camID, Element properties) throws DocumentException {
        String request = QUERY_REQUEST;
        Document requestDoc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)QUERY_REQUEST);
        Element soapRequest = requestDoc.getRootElement();
        Element queryElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)"*[local-name()='Body']/*[local-name()='query']", (Node)soapRequest);
        Element searchElement = DocumentHelper.createElement((String)"bus:search");
        searchElement.setText(camID);
        queryElement.add(searchElement);
        Element propElement = properties.createCopy();
        propElement.detach();
        queryElement.add(propElement);
        return soapRequest.asXML();
    }

    private void processPropElement(Element securityObject, List propElements, boolean updateObjectClassForPolicy) {
        for (int j = 0; j < propElements.size(); ++j) {
            Element propElement = (Element)propElements.get(j);
            propElement.detach();
            if (updateObjectClassForPolicy) {
                securityObject.add(propElement);
                continue;
            }
            if (propElement.getName().equalsIgnoreCase(OBJECT_CLASS)) continue;
            securityObject.add(propElement);
        }
    }

    public String searchForProperties(Element policy, Element properties, CmBridge bridge, String passportID) throws DocumentException, AAAException {
        Element securityObject = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((XPath)XPATH_SECURITY_OBJECT, (Node)policy);
        String camID = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.valueOf((XPath)XPATH_SEARCH_PATH, (Node)securityObject);
        String xmlRequest = this.formQueryRequest(camID, properties);
        String result = bridge.Search(passportID, xmlRequest);
        return result;
    }

    public void updatePolicy(Element policy, String searchResultString, boolean updateObjectForPolicy) throws DocumentException {
        List itemElements;
        Document searchDoc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)searchResultString);
        Element searchResult = searchDoc.getRootElement();
        Element queryResultItem = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)"./*[local-name()='queryResult']", (Node)searchResult);
        if (queryResultItem != null && !(itemElements = queryResultItem.elements()).isEmpty()) {
            Element securityObject = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((XPath)XPATH_SECURITY_OBJECT, (Node)policy);
            securityObject.clearContent();
            for (int i = 0; i < itemElements.size(); ++i) {
                Element itemElement = (Element)itemElements.get(i);
                String objectType = this.extractObjectType(itemElement);
                List propElements = itemElement.elements();
                this.processPropElement(securityObject, propElements, updateObjectForPolicy);
                List attributes = securityObject.attributes();
                for (int attIndex = 0; attIndex < attributes.size(); ++attIndex) {
                    Attribute attr = (Attribute)attributes.get(attIndex);
                    securityObject.remove(attr);
                }
                securityObject.addAttribute("xsi:type", QName.get((String)objectType, (Namespace)BIBUS_NS).getQualifiedName());
                securityObject.add(XSI_NS);
                securityObject.add(BIBUS_NS);
            }
        }
    }
}

