/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.soap;

import com.cognos.CAM_AAA.authentication.IAccount;
import com.cognos.CAM_AAA.authentication.IBaseClass;
import com.cognos.CAM_AAA.authentication.IGroup;
import com.cognos.CAM_AAA.authentication.INamespace;
import com.cognos.CAM_AAA.authentication.INamespaceFolder;
import com.cognos.CAM_AAA.authentication.IQueryResult;
import com.cognos.CAM_AAA.authentication.IRole;
import com.cognos.CAM_AAA.authentication.IVisa;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Group;
import com.ibm.cognos.camaaa.internal.admin.soap.IAccountConverter;
import com.ibm.cognos.camaaa.internal.admin.soap.IGroupConverter;
import com.ibm.cognos.camaaa.internal.admin.soap.INamespaceConverter;
import com.ibm.cognos.camaaa.internal.admin.soap.INamespaceFolderConverter;
import com.ibm.cognos.camaaa.internal.admin.soap.IRoleConverter;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.NamespaceFolder;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryOptions;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.Role;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import java.util.Locale;

public class IQueryResultConverter {
    private static final String MEMBERS_PROPERTY = "members";
    private final Namespace namespace;
    private final RequestContext requestContext;
    private QueryResult queryResult;
    private final QueryOptions queryOptions;
    private final IAccountConverter accountConverter = new IAccountConverter(this);
    private final IRoleConverter roleConverter = new IRoleConverter(this);
    private final IGroupConverter groupConverter = new IGroupConverter(this);
    private final INamespaceConverter namespaceConverter = new INamespaceConverter(this);
    private final INamespaceFolderConverter namespaceFolderConverter = new INamespaceFolderConverter(this);
    private final IVisa visa;
    private final String[] properties;

    public IQueryResultConverter(Namespace theNamespace, RequestContext theRequestContext, QueryOptions theQueryOptions, IVisa theVisa, String[] theProps) {
        this.namespace = theNamespace;
        this.queryOptions = theQueryOptions;
        this.requestContext = theRequestContext;
        this.visa = theVisa;
        this.properties = theProps;
    }

    private static String getObjectClassString(IBaseClass theIBaseClass) {
        String ret = null;
        if (theIBaseClass instanceof INamespace) {
            ret = "namespace";
        } else if (theIBaseClass instanceof INamespaceFolder) {
            ret = "namespaceFolder";
        } else if (theIBaseClass instanceof IAccount) {
            ret = "account";
        } else if (theIBaseClass instanceof IGroup) {
            ret = "group";
        } else if (theIBaseClass instanceof IRole) {
            ret = "role";
        }
        return ret;
    }

    private BaseClass convertToBaseClass(String[] prop, IBaseClass iBaseClass) throws SoapFaultException {
        SearchPathImpl searchPath = new SearchPathImpl(this.namespace.getSearchPath().getNamespaceID(), iBaseClass.getObjectID());
        BaseClass baseClass = null;
        if (iBaseClass instanceof INamespace) {
            baseClass = this.queryResult.create((SearchPath)searchPath, "namespace");
        } else if (iBaseClass instanceof INamespaceFolder) {
            baseClass = this.queryResult.create((SearchPath)searchPath, "namespaceFolder");
        } else if (iBaseClass instanceof IAccount) {
            baseClass = this.queryResult.create((SearchPath)searchPath, "account");
        } else if (iBaseClass instanceof IGroup) {
            baseClass = this.queryResult.create((SearchPath)searchPath, "group");
        } else if (iBaseClass instanceof IRole) {
            baseClass = this.queryResult.create((SearchPath)searchPath, "role");
        }
        if (baseClass != null) {
            this.populateBaseClass(prop, baseClass, iBaseClass);
        }
        return baseClass;
    }

    BaseClass[] convertToBaseClassArray(IBaseClass[] from, String[] prop) throws SoapFaultException {
        BaseClass[] to = new BaseClass[from.length];
        for (int i = 0; i < to.length; ++i) {
            to[i] = this.convertToBaseClass(prop, from[i]);
        }
        return to;
    }

    private LocalizedString getDefaultName(IBaseClass theObject) {
        Locale[] availableLocales;
        Locale locale = this.requestContext.getContentLocale();
        String value = theObject.getName(locale);
        if (value == null) {
            locale = this.requestContext.getServerLocale();
            value = theObject.getName(locale);
        }
        if (value == null && (availableLocales = theObject.getAvailableNameLocales()) != null && availableLocales.length > 0) {
            locale = availableLocales[0];
            value = theObject.getName(locale);
        }
        if (value == null) {
            value = "";
            locale = Locale.getDefault();
        }
        return new LocalizedString(value, locale);
    }

    private SearchPath getSearchPath(IBaseClass theIBaseClass) throws SoapFaultException {
        String objectId = theIBaseClass instanceof INamespace ? null : theIBaseClass.getObjectID();
        return new SearchPathImpl(this.namespace.getSearchPath().getNamespaceID(), objectId);
    }

    void populateAncestors(BaseClass theBaseClass, IBaseClass theIBaseClass) throws SoapFaultException {
        if (theBaseClass.getAncestors() == null) {
            BaseClass[] ancestors = null;
            IBaseClass[] iAncestors = theIBaseClass.getAncestors();
            if (iAncestors != null) {
                ancestors = new BaseClass[iAncestors.length];
                for (int i = 0; i < iAncestors.length; ++i) {
                    String objectID = iAncestors[i].getObjectID();
                    String objectClass = IQueryResultConverter.getObjectClassString(iAncestors[i]);
                    LocalizedString title = this.getDefaultName(iAncestors[i]);
                    ancestors[i] = this.queryResult.create((SearchPath)new SearchPathImpl(this.namespace.getSearchPath().getNamespaceID(), objectID), objectClass);
                    ancestors[i].addName(title.getLocale(), title.getStr());
                }
                theBaseClass.setAncestors(this.namespace, ancestors);
            } else {
                theBaseClass.setAncestors(this.namespace, new BaseClass[0]);
            }
        }
    }

    private void populateBaseClass(String[] prop, BaseClass baseClass, IBaseClass iBaseClass) throws SoapFaultException {
        if (prop == null || prop.length == 0) {
            return;
        }
        if (iBaseClass instanceof INamespace) {
            this.namespaceConverter.populateNamespace((Namespace)baseClass, (INamespace)iBaseClass, prop);
        } else if (iBaseClass instanceof INamespaceFolder) {
            this.namespaceFolderConverter.populateNamespaceFolder((NamespaceFolder)baseClass, (INamespaceFolder)iBaseClass, prop);
        } else if (iBaseClass instanceof IAccount) {
            this.accountConverter.populateAccount((Account)baseClass, (IAccount)iBaseClass, prop, this.visa);
        } else if (iBaseClass instanceof IGroup) {
            this.groupConverter.populateGroup((Group)baseClass, (IGroup)iBaseClass, prop);
        } else if (iBaseClass instanceof IRole) {
            this.roleConverter.populateRole((Role)baseClass, (IRole)iBaseClass, prop);
        }
    }

    void populateMemberOf(Account theAccount, IAccount theIAccount) throws SoapFaultException {
        String visaAccountID;
        String accountID = theIAccount.getObjectID();
        if (accountID.equals(visaAccountID = this.visa.getAccount().getObjectID())) {
            IGroup[] groups = this.visa.getGroups();
            IRole[] roles = this.visa.getRoles();
            int length = 0;
            if (roles != null) {
                length = roles.length;
            }
            if (groups != null) {
                length += groups.length;
            }
            if (length == 0) {
                return;
            }
            IBaseClass[] baseClasses = new IBaseClass[length];
            int rolesLength = 0;
            if (roles != null) {
                System.arraycopy(roles, 0, baseClasses, 0, roles.length);
                rolesLength = roles.length;
            }
            if (groups != null) {
                System.arraycopy(groups, 0, baseClasses, rolesLength, groups.length);
            }
            String[] props = new String[]{};
            BaseClass[] members = this.convertToBaseClassArray(baseClasses, props);
            theAccount.setMemberOf(members);
        }
    }

    public void populateQueryResult(IQueryResult from, QueryResult to) throws SoapFaultException {
        this.queryResult = to;
        IBaseClass[] iBaseClasses = from.getObjects();
        if (iBaseClasses == null) {
            return;
        }
        for (int i = 0; i < iBaseClasses.length; ++i) {
            if (iBaseClasses[i] == null) continue;
            BaseClass baseClass = to.get(this.getSearchPath(iBaseClasses[i]));
            if (baseClass != null) {
                this.populateBaseClass(this.properties, baseClass, iBaseClasses[i]);
                continue;
            }
            baseClass = this.convertToBaseClass(this.properties, iBaseClasses[i]);
            this.queryResult.add(baseClass);
        }
    }

    BaseClass[] poulateMembers(IBaseClass[] from) throws SoapFaultException {
        String[] prop = this.queryOptions.getRefProps(MEMBERS_PROPERTY);
        if (from != null) {
            return this.convertToBaseClassArray(from, prop);
        }
        return null;
    }

    private class LocalizedString {
        private final String str;
        private final Locale locale;

        LocalizedString(String theString, Locale theLocale) {
            this.str = theString;
            this.locale = theLocale;
        }

        Locale getLocale() {
            return this.locale;
        }

        String getStr() {
            return this.str;
        }
    }
}

