/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.customLegacy.auth;

import com.cognos.CAM_AAA.authentication.ITrustedSignonRequest;
import com.ibm.cognos.camaaa.internal.auth.EnvironmentSecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlobManager;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.common.IBiBusHeaderCompatibilityAdapter;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeaderImpl;
import org.dom4j.DocumentHelper;

public class ITrustedSignonRequestAdapter
extends IBiBusHeaderCompatibilityAdapter
implements ITrustedSignonRequest {
    private static final String NAMESPACE_CREDENTIAL_TAG = "namespace";
    private Credential credential;
    private EnvironmentSecurityBlob blob;
    private final MessageContext mc;
    private final BiBusHeader biBusHdr;
    private String nsId = null;

    public ITrustedSignonRequestAdapter(BiBusHeader theBiBusHeader, MessageContext theMessageContext) {
        super(theBiBusHeader, theMessageContext);
        SecurityBlob securityBlob;
        this.mc = theMessageContext;
        Credential[] credentials = (Credential[])theMessageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        if (credentials != null) {
            this.credential = credentials[0];
        }
        this.biBusHdr = theBiBusHeader;
        String blobString = theBiBusHeader.getCAMSecurityBlob();
        if (blobString != null && (securityBlob = SecurityBlobManager.createSecurityBlob((String)blobString)) != null && securityBlob.getBlobType() == 1) {
            this.blob = (EnvironmentSecurityBlob)securityBlob;
        }
    }

    public void addCredential(String theName, String theValue) {
        if (theName != null && theValue != null) {
            if (this.credential == null) {
                this.credential = new CredentialImpl(DocumentHelper.createElement((String)"credential"));
            }
            this.credential.addCredentialPair(theName, new String[]{theValue});
        }
    }

    public void addEnvVar(String theName, String theValue) {
        if (theName != null && theValue != null) {
            ((BiBusHeaderImpl)this.biBusHdr).addEnvVar(theName, theValue);
        }
    }

    public void addTrustedEnvVar(String theName, String theValue) {
        if (theName != null && theValue != null) {
            if (this.blob == null) {
                this.blob = new EnvironmentSecurityBlob();
            }
            this.blob.addVars(theName, theValue);
        }
    }

    public String[] getTrustedEnvVarValue(String theName) {
        String value;
        if (this.blob != null && (value = this.blob.getRequestedVarValue(theName)) != null) {
            return new String[]{value};
        }
        return null;
    }

    public void pushChanges() {
        if (this.nsId != null) {
            this.mc.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.redirectionNamespaceId", (Object)this.nsId);
            if (this.credential != null) {
                this.addCredential(NAMESPACE_CREDENTIAL_TAG, this.nsId);
            }
        }
        if (this.blob != null) {
            this.biBusHdr.setCAMSecurityBlob(this.blob.getEncodedSecurityBlob());
        }
        if (this.credential != null) {
            this.mc.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)new Credential[]{this.credential});
        }
    }

    public void removeCredential(String theName) {
        if (theName != null && this.credential != null) {
            ((CredentialImpl)this.credential).removeCredentialValues(theName);
        }
    }

    public void removeEnvVar(String theName) {
        if (theName != null) {
            ((BiBusHeaderImpl)this.biBusHdr).removeEnvVar(theName);
        }
    }

    public void removeTrustedEnvVar(String theName) {
        if (this.blob != null && theName != null) {
            this.blob.removeVars(theName);
        }
    }

    public void setNamespaceID(String theNamespaceID) {
        if (theNamespaceID != null) {
            this.removeCredential(NAMESPACE_CREDENTIAL_TAG);
            this.nsId = theNamespaceID;
        }
    }
}

