/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.customLegacy.auth;

import com.cognos.CAM_AAA.authentication.INamespace;
import com.cognos.CAM_AAA.authentication.INamespaceConfiguration;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.util.CustomProviderProxyAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.config.INamespaceConfigAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.exception.UnrecoverableExceptionConverter;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public abstract class NamespaceAdapter {
    private final INamespace namespace;
    private final String namespaceId;

    public NamespaceAdapter(INamespace theNamespace, String theNamespaceId) {
        this.namespace = theNamespace;
        this.namespaceId = theNamespaceId;
    }

    public void destroy() {
        this.namespace.destroy();
    }

    protected INamespace getNamespace() {
        return this.namespace;
    }

    public String getNamespaceFormat() {
        return this.namespace.getNamespaceFormat();
    }

    protected String getNamespaceId() {
        return this.namespaceId;
    }

    public void init(Configuration theConfig) throws SoapFaultException {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CustomProviderProxyAdapter.getProviderClassLoader());
            this.namespace.init((INamespaceConfiguration)new INamespaceConfigAdapter(theConfig));
        }
        catch (UnrecoverableException e) {
            throw UnrecoverableExceptionConverter.convertException((UnrecoverableException)e);
        }
        catch (Exception e) {
            throw new com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException(NamespaceAdapter.class.getName(), (LocalizableMessage)new Message("AAA_CAP_INIT_FAILED"), (LocalizableMessage)new Message("AAA_CAP_INIT_FAILED"), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    public void populateNamespace(Namespace theNamespace) {
        theNamespace.setCapabilities(this.namespace.getCapabilities());
        theNamespace.setHasChildren(new Boolean(this.namespace.getHasChildren()));
    }

    public void setNamespaceFormat(String theNamespaceFormat) throws SoapFaultException {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CustomProviderProxyAdapter.getProviderClassLoader());
            this.namespace.setNamespaceFormat(theNamespaceFormat);
        }
        catch (UnrecoverableException e) {
            throw UnrecoverableExceptionConverter.convertException((UnrecoverableException)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }
}

