/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.customLegacy.auth;

import com.cognos.CAM_AAA.authentication.INamespace;
import com.cognos.CAM_AAA.authentication.INamespaceAuthenticationProvider;
import com.cognos.CAM_AAA.authentication.INamespaceAuthenticationProvider2;
import com.cognos.CAM_AAA.authentication.INamespaceTrustedSignonProvider;
import com.ibm.cognos.camaaa.internal.common.exception.ClassLoadErrorException;
import com.ibm.cognos.camaaa.internal.common.util.CustomProviderProxyAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.NamespaceAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.NamespaceAuthProvider2Adapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.NamespaceAuthProviderAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.TrustedSignonProviderAdapter;

public class NamespaceAdapterFactory {
    private INamespace namespace;
    private final String namespaceId;
    private Package p;

    NamespaceAdapterFactory(INamespace theNamespace, String theNamespaceId) {
        this.namespace = theNamespace;
        this.namespaceId = theNamespaceId;
    }

    public NamespaceAdapterFactory(String authModuleClass, String theNamespaceId) throws ClassLoadErrorException {
        this.namespaceId = theNamespaceId;
        try {
            Class<?> c = Class.forName(authModuleClass, true, CustomProviderProxyAdapter.getProviderClassLoader());
            this.namespace = (INamespace)c.newInstance();
            this.p = c.getPackage();
        }
        catch (ClassNotFoundException e) {
            throw new ClassLoadErrorException(authModuleClass, (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new ClassLoadErrorException(authModuleClass, (Exception)e);
        }
        catch (InstantiationException e) {
            throw new ClassLoadErrorException(authModuleClass, (Exception)e);
        }
    }

    public NamespaceAdapter createINamespaceAdapter() {
        NamespaceAdapter ret = null;
        if (this.namespace instanceof INamespaceAuthenticationProvider) {
            ret = new NamespaceAuthProviderAdapter(this.namespace, this.namespaceId);
        } else if (this.namespace instanceof INamespaceAuthenticationProvider2) {
            ret = new NamespaceAuthProvider2Adapter(this.namespace, this.namespaceId);
        } else if (this.namespace instanceof INamespaceTrustedSignonProvider) {
            ret = new TrustedSignonProviderAdapter(this.namespace, this.namespaceId);
        }
        return ret;
    }

    public Package getPackage() {
        return this.p;
    }
}

