/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.customLegacy.auth;

import com.cognos.CAM_AAA.authentication.IBiBusHeader;
import com.cognos.CAM_AAA.authentication.ICredential;
import com.cognos.CAM_AAA.authentication.IRestorableVisa;
import com.cognos.CAM_AAA.authentication.ITrustedCredential;
import com.cognos.CAM_AAA.authentication.IVisa;
import com.cognos.CAM_AAA.authentication.SystemRecoverableException;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.cognos.CAM_AAA.authentication.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.common.IBiBusHeaderCompatibilityAdapter;
import com.ibm.cognos.camaaa.internal.common.Visa;
import com.ibm.cognos.camaaa.internal.common.VisaHelper;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.util.CustomProviderProxyAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.CredentialAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.ITrustedCredentialConverter;
import com.ibm.cognos.camaaa.internal.customLegacy.exception.SystemRecoverableExceptionConverter;
import com.ibm.cognos.camaaa.internal.customLegacy.exception.UnrecoverableExceptionConverter;
import com.ibm.cognos.camaaa.internal.customLegacy.exception.UserRecoverableExceptionConverter;
import com.ibm.cognos.camaaa.internal.legacy.auth.BaseLegacyVisa;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class VisaAdapter
extends BaseLegacyVisa {
    private static final String CAM_NAMESPACE = "CAMNamespace";
    private static final long serialVersionUID = 1L;
    private IVisa visa;

    public VisaAdapter() {
    }

    public VisaAdapter(IVisa theVisa) {
        this.visa = theVisa;
    }

    public BaseLegacyVisa cloneVisa() throws IOException, ClassNotFoundException {
        VisaAdapter clonedVisa = null;
        if (this.isExternalizable()) {
            clonedVisa = (VisaAdapter)VisaHelper.cloneVisaUsingExternalizable((Visa)this);
        } else {
            clonedVisa = new VisaAdapter();
            clonedVisa.visa = this.visa;
            this.addRefs(clonedVisa);
        }
        return clonedVisa;
    }

    public Credential generateCredential(BiBusHeader biBusHdr, MessageContext messageContext) throws SoapFaultException {
        ICredential credential;
        IBiBusHeaderCompatibilityAdapter bbHdrAdapter = new IBiBusHeaderCompatibilityAdapter(biBusHdr, messageContext);
        String namespaceId = (String)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CustomProviderProxyAdapter.getProviderClassLoader());
            credential = this.visa.generateCredential((IBiBusHeader)bbHdrAdapter);
        }
        catch (SystemRecoverableException e) {
            throw SystemRecoverableExceptionConverter.convertException((SystemRecoverableException)e, (String)namespaceId, (String)CAM_NAMESPACE);
        }
        catch (UserRecoverableException e) {
            throw UserRecoverableExceptionConverter.convertException((UserRecoverableException)e, (String)namespaceId, (String)"generateCredential");
        }
        catch (UnrecoverableException e) {
            throw UnrecoverableExceptionConverter.convertException((UnrecoverableException)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
        if (credential == null) {
            return null;
        }
        return new CredentialAdapter(credential);
    }

    public Credential generateTC(MessageContext theMessageContext, BiBusHeader theBiBusHeader) throws SoapFaultException {
        IBiBusHeaderCompatibilityAdapter biBusHdrAdapter = new IBiBusHeaderCompatibilityAdapter(theBiBusHeader, theMessageContext);
        String namespaceId = (String)theMessageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CustomProviderProxyAdapter.getProviderClassLoader());
            ITrustedCredential credential = this.visa.generateTrustedCredential((IBiBusHeader)biBusHdrAdapter);
            Credential credential2 = ITrustedCredentialConverter.convertToCredential(credential);
            return credential2;
        }
        catch (SystemRecoverableException e) {
            throw SystemRecoverableExceptionConverter.convertException((SystemRecoverableException)e, (String)namespaceId, (String)CAM_NAMESPACE);
        }
        catch (UserRecoverableException e) {
            throw UserRecoverableExceptionConverter.convertException((UserRecoverableException)e, (String)namespaceId, (String)"generateTC");
        }
        catch (UnrecoverableException e) {
            throw UnrecoverableExceptionConverter.convertException((UnrecoverableException)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    public IVisa getIVisa() {
        return this.visa;
    }

    public boolean hasStateChanged() {
        boolean stateHasChanged = true;
        try {
            IRestorableVisa theVisa = (IRestorableVisa)this.visa;
            if (theVisa != null) {
                stateHasChanged = theVisa.hasStateChanged();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return stateHasChanged;
    }

    protected boolean isExternalizable() {
        return this.visa instanceof Externalizable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Unknown version: " + Long.toString(version));
        }
        byte[] visaBuffer = (byte[])in.readObject();
        ByteArrayInputStream bais = new ByteArrayInputStream(visaBuffer);
        ClassLoader newClassLoader = CustomProviderProxyAdapter.getProviderClassLoader();
        CustomClassLoaderObjectInputStream nestedObjectInput = new CustomClassLoaderObjectInputStream(bais, newClassLoader);
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newClassLoader);
            this.visa = (IVisa)nestedObjectInput.readObject();
            nestedObjectInput.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
    }

    public void resetChangeIndicator() {
        try {
            IRestorableVisa theVisa = (IRestorableVisa)this.visa;
            if (theVisa != null) {
                theVisa.resetChangeIndicator();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Externalizable extern = (Externalizable)this.visa;
        out.writeLong(1L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream newOut = new ObjectOutputStream(baos);
        newOut.writeObject(extern);
        newOut.close();
        out.writeObject(baos.toByteArray());
    }

    private class CustomClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        CustomClassLoaderObjectInputStream(InputStream stream, ClassLoader cl) throws IOException {
            super(stream);
            this.classLoader = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            Class[] classes = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                classes[i] = Class.forName(interfaces[i], false, this.classLoader);
            }
            try {
                return Proxy.getProxyClass(this.classLoader, classes);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
    }
}

