/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.customLegacy.common.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.Visa;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeader;
import com.ibm.cognos.camaaa.internal.common.util.ReadProperties;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.NamespaceAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.NamespaceAdapterFactory;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.NamespaceAuthProviderBaseAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.TrustedSignonProviderAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.auth.VisaAdapter;

public class CustomJavaProviderHandler
extends DefaultHandler {
    protected static final String NAMESPACE_ID_VALUE = "./*[local-name()='parameter'][@name='id']/*[local-name()='value']/text()";
    private static final String AUTH_MODULE_CLASS_VALUE = "./*[local-name()='parameter'][@name='authModule']/*[local-name()='value']/text()";
    private ReadProperties aProperties;
    private NamespaceAdapter providerAdapter;

    private static BiBusHeader getBiBusHeader(MessageContext theContext) {
        SoapEnvelope soapEnv = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapHeader soapHdr = soapEnv.getHeader();
        return soapHdr.getBiBusHeader();
    }

    private static RequestContext getRequestContext(MessageContext theContext) {
        return (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
    }

    private static VisaAdapter getVisa(MessageContext theContext) {
        return (VisaAdapter)((Object)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa"));
    }

    private static void setVisa(Visa visa, MessageContext theContext) {
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa", (Object)visa);
    }

    public void destroy() {
        this.providerAdapter.destroy();
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.readPropertiesSetting();
        Configuration configuration = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        String authModuleClass = configuration.getMandatoryValue(AUTH_MODULE_CLASS_VALUE);
        String namespaceId = configuration.getMandatoryValue(NAMESPACE_ID_VALUE);
        NamespaceAdapterFactory adapterFactory = new NamespaceAdapterFactory(authModuleClass, namespaceId);
        if (this.aProperties.traceLogicEnabled()) {
            Package p = adapterFactory.getPackage();
            this.logTraceForPackageInformation(p);
        }
        this.providerAdapter = adapterFactory.createINamespaceAdapter();
        this.providerAdapter.init(configuration);
        this.configure(theConfig, namespaceId);
    }

    private void logTraceForPackageInformation(Package p) {
        if (p != null) {
            this.aProperties.logTraceLogic("Package information:");
            this.aProperties.logTraceLogic("Name:  " + p.getName());
            this.aProperties.logTraceLogic("Implementation title:  " + p.getImplementationTitle());
            this.aProperties.logTraceLogic("Implementation verdor: " + p.getImplementationVendor());
            this.aProperties.logTraceLogic("Implementation version: " + p.getImplementationVersion());
            this.aProperties.logTraceLogic("Secificaiton title: " + p.getSpecificationTitle());
            this.aProperties.logTraceLogic("Secificaiton vendor: " + p.getSpecificationVendor());
            this.aProperties.logTraceLogic("Secificaiton version: " + p.getSpecificationVersion());
            if (p.isCompatibleWith("1.1")) {
                this.aProperties.logTraceLogic("Is compatible with current specification");
            } else {
                this.aProperties.logTraceLogic("Is NoT compatible with current specification");
            }
        }
    }

    private void readPropertiesSetting() {
        this.aProperties = new ReadProperties();
    }

    protected void configure(HandlerInfo theConfig, String namespaceId) throws SoapFaultException {
        try {
            NamespaceManager nsManager = (NamespaceManager)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.NamespaceManager");
            Namespace ns = nsManager.getNamespace(namespaceId);
            this.providerAdapter.setNamespaceFormat(ns.getNamespaceFormat());
            this.providerAdapter.populateNamespace(ns);
        }
        catch (SoapFaultException e) {
            this.logTraceException(e);
            throw e;
        }
    }

    private void logTraceException(SoapFaultException e) {
        if (this.aProperties != null) {
            this.aProperties.logTraceException((Throwable)e);
        }
    }

    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        boolean processStatus = false;
        try {
            processStatus = this.providerAdapter instanceof NamespaceAuthProviderBaseAdapter ? this.processAuthProviderRequest(theContext) : this.processTrustedSignonProviderRequest(theContext);
        }
        catch (SoapFaultException e) {
            this.logTraceException(e);
            throw e;
        }
        return processStatus;
    }

    protected void setProviderAdapter(NamespaceAdapter theProviderAdapter) {
        this.providerAdapter = theProviderAdapter;
    }

    private boolean processAuthProviderRequest(MessageContext theContext) throws SoapFaultException {
        SoapEnvelope soapEnv = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        VisaAdapter visa = null;
        BiBusHeader biBusHdr = CustomJavaProviderHandler.getBiBusHeader(theContext);
        RequestContext requestContext = CustomJavaProviderHandler.getRequestContext(theContext);
        SoapBodyEntry reqBodyEntry = soapEnv.getBody().getBodyEntry();
        NamespaceAuthProviderBaseAdapter authProvider = (NamespaceAuthProviderBaseAdapter)this.providerAdapter;
        switch (reqBodyEntry.getType()) {
            case 4: {
                visa = CustomJavaProviderHandler.getVisa(theContext);
                authProvider.logoff(visa, biBusHdr, theContext);
                break;
            }
            case 2: 
            case 22: {
                visa = authProvider.logon(biBusHdr, theContext);
                CustomJavaProviderHandler.setVisa((Visa)visa, theContext);
                break;
            }
            case 1: {
                visa = CustomJavaProviderHandler.getVisa(theContext);
                Query query = (Query)theContext.get((Object)Query.class.getName());
                QueryResult queryResult = (QueryResult)theContext.get((Object)QueryResult.class.getName());
                Namespace namespace = (Namespace)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespaceObject");
                authProvider.search(visa, query, requestContext, queryResult, namespace);
                break;
            }
            case 5: {
                visa = CustomJavaProviderHandler.getVisa(theContext);
                if (!(visa instanceof VisaAdapter)) break;
                Credential credential = visa.generateTC(theContext, biBusHdr);
                this.setCredential(credential, theContext);
                break;
            }
            case 6: {
                visa = CustomJavaProviderHandler.getVisa(theContext);
                if (!(visa instanceof VisaAdapter)) break;
                Credential credential = visa.generateCredential(biBusHdr, theContext);
                this.setCredential(credential, theContext);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean processTrustedSignonProviderRequest(MessageContext theContext) throws SoapFaultException {
        ((TrustedSignonProviderAdapter)this.providerAdapter).processLogonRequest(theContext);
        return true;
    }

    private void setCredential(Credential credential, MessageContext theContext) {
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)new Credential[]{credential});
    }
}

