/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TenancyInfoImpl
implements TenancyInfo {
    private static final long serialVersionUID = 187340189365L;
    private Map<TenancyInfo.TenancyType, Set<String>> tenantIDs = new HashMap<TenancyInfo.TenancyType, Set<String>>();
    private boolean dirty;
    private boolean isImpersonating;

    public TenancyInfoImpl() {
        this.tenantIDs.put(TenancyInfo.TenancyType.TENANTID, new HashSet());
        this.tenantIDs.put(TenancyInfo.TenancyType.READ_TENANTID, new HashSet());
        this.tenantIDs.put(TenancyInfo.TenancyType.WRITE_TENANTID, new HashSet());
        this.dirty = true;
    }

    public TenancyInfoImpl(String theTenantID, String theReadTenantID, String theWriteTenantID) {
        this();
        this.setTenancy(TenancyInfo.TenancyType.TENANTID, theTenantID);
        this.setTenancy(TenancyInfo.TenancyType.READ_TENANTID, theReadTenantID);
        this.setTenancy(TenancyInfo.TenancyType.WRITE_TENANTID, theWriteTenantID);
    }

    public void addTenancies(TenancyInfo.TenancyType tenancyType, String[] theTenantIDs) throws SoapFaultException {
        if (theTenantIDs == null || theTenantIDs.length == 0) {
            return;
        }
        Set<String> result = this.tenantIDs.get(tenancyType);
        if (theTenantIDs.length > 1 && (tenancyType == TenancyInfo.TenancyType.TENANTID || tenancyType == TenancyInfo.TenancyType.WRITE_TENANTID)) {
            throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), TenancyInfoImpl.class.toString(), null, "AAA_SYS_E_INTERNAL_ERROR", (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"));
        }
        if (result.size() == 1 && (tenancyType == TenancyInfo.TenancyType.TENANTID || tenancyType == TenancyInfo.TenancyType.WRITE_TENANTID)) {
            if (!result.contains(theTenantIDs[0])) {
                throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), TenancyInfoImpl.class.toString(), null, "AAA_SYS_E_INTERNAL_ERROR", (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"));
            }
        } else {
            Collections.addAll(result, theTenantIDs);
        }
        this.dirty = true;
    }

    public Object clone() throws CloneNotSupportedException {
        TenancyInfoImpl theClone = (TenancyInfoImpl)super.clone();
        theClone.tenantIDs = (HashMap)((HashMap)this.tenantIDs).clone();
        for (Map.Entry<TenancyInfo.TenancyType, Set<String>> entry : this.tenantIDs.entrySet()) {
            TenancyInfo.TenancyType tenancyType = entry.getKey();
            HashSet clonedValues = (HashSet)((HashSet)entry.getValue()).clone();
            theClone.tenantIDs.put(tenancyType, clonedValues);
        }
        return theClone;
    }

    public String[] getTenancies(TenancyInfo.TenancyType tenancyType) {
        Set<String> result = this.tenantIDs.get(tenancyType);
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    public String getTenancy(TenancyInfo.TenancyType tenancyType) throws SoapFaultException {
        Set<String> result = this.tenantIDs.get(tenancyType);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), TenancyInfoImpl.class.toString(), null, "AAA_SYS_E_INTERNAL_ERROR", (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"));
        }
        return result.iterator().next();
    }

    public boolean hasStateChanged() {
        return this.dirty;
    }

    public boolean isUnset() {
        return this.tenantIDs.isEmpty();
    }

    public boolean isImpersonating() {
        return this.isImpersonating;
    }

    public void setIsImpersonating(boolean theValue) {
        this.isImpersonating = theValue;
        this.dirty = true;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 187340189365L) {
            throw new IOException("Unkown version: " + Long.toString(version));
        }
        int intTenancyType = in.readInt();
        TenancyInfo.TenancyType tenancyType = TenancyInfo.TenancyType.values()[intTenancyType];
        while (tenancyType != TenancyInfo.TenancyType.INVALID_TENANTID) {
            int numOfIds = in.readInt();
            for (int i = 0; i < numOfIds; ++i) {
                String theTenantID = in.readUTF();
                this.setTenancy(tenancyType, theTenantID);
            }
            intTenancyType = in.readInt();
            tenancyType = TenancyInfo.TenancyType.values()[intTenancyType];
        }
        this.setIsImpersonating(in.readBoolean());
    }

    public void resetChangeIndicator() {
        this.dirty = false;
    }

    public void setTenancies(TenancyInfo.TenancyType tenancyType, String[] theTenantIDs) throws SoapFaultException {
        Set<String> result = this.tenantIDs.get(tenancyType);
        if (theTenantIDs == null || theTenantIDs.length == 0) {
            result.clear();
        } else {
            if (theTenantIDs.length > 1 && (tenancyType == TenancyInfo.TenancyType.TENANTID || tenancyType == TenancyInfo.TenancyType.WRITE_TENANTID)) {
                throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), TenancyInfoImpl.class.toString(), null, "AAA_SYS_E_INTERNAL_ERROR", (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"));
            }
            result.clear();
            Collections.addAll(result, theTenantIDs);
        }
        this.dirty = true;
    }

    public void setTenancy(TenancyInfo.TenancyType tenancyType, String theTenantID) {
        Set<String> result = this.tenantIDs.get(tenancyType);
        if (theTenantID == null) {
            result.clear();
        } else {
            result.clear();
            result.add(theTenantID);
        }
        this.dirty = true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(187340189365L);
        for (Map.Entry<TenancyInfo.TenancyType, Set<String>> entry : this.tenantIDs.entrySet()) {
            out.writeInt(entry.getKey().ordinal());
            Set<String> theTenantIDs = entry.getValue();
            out.writeInt(theTenantIDs.size());
            for (String anID : theTenantIDs) {
                out.writeUTF(anID);
            }
        }
        out.writeInt(TenancyInfo.TenancyType.INVALID_TENANTID.ordinal());
        out.writeBoolean(this.isImpersonating());
        out.flush();
    }
}

