/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryOptions;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.ldap.admin.LdapQuery;
import com.ibm.cognos.camaaa.internal.ldap.admin.SimpleQueryResultImpl;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class RelativeQuery
implements LdapQuery {
    private final LdapQuery baseQuery;
    private final LdapQuery relativeQuery;

    public RelativeQuery(LdapQuery theBaseQuery, LdapQuery theRelativeQuery) {
        this.baseQuery = theBaseQuery;
        this.relativeQuery = theRelativeQuery;
    }

    @Override
    public void run(LdapContext theContext, QueryOptions theQueryOptions, QueryResult theResult, Set theAddtionalAttributes) throws SoapFaultException {
        SimpleQueryResultImpl result = new SimpleQueryResultImpl(theResult);
        this.baseQuery.run(theContext, theQueryOptions, (QueryResult)result, theAddtionalAttributes);
        try {
            BaseClass[] allObjects = result.getAll();
            for (int i = 0; i < allObjects.length; ++i) {
                SearchResult searchResult = (SearchResult)allObjects[i].getUserData();
                String name = searchResult.getName();
                String relativeDN = LdapUtil.getRelativeDN(theContext, theContext.getNameInNamespace(), name);
                if (relativeDN == null) {
                    relativeDN = name;
                }
                LdapContext ldapContextForThisRequest = (LdapContext)theContext.lookup(relativeDN);
                this.relativeQuery.run(ldapContextForThisRequest, theQueryOptions, theResult, theAddtionalAttributes);
            }
        }
        catch (NamingException e) {
            throw new InternalErrorException(RelativeQuery.class.getName(), (Exception)e);
        }
    }
}

