/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryOptions;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.UiClass;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.ldap.admin.LdapQuery;
import com.ibm.cognos.camaaa.internal.ldap.admin.ObjectTypeDeterminer;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class SimpleQuery
implements LdapQuery {
    private static final String DN_ATTRIBUTE = "dn";
    private static final String OBJECT_GUID_ATTRIBUTE = "objectGUID";
    private static final String ACTOR = SimpleQuery.class.toString();
    private static final int SEC_TO_MS_MULTIPLIER = 1000;
    private static final String LANG_SEPARATOR = ";lang-";
    private static final String CAMID_OBJECT_TYPE_SEPARATOR = ":";
    private static final String CONFIG_STRING_DELIMITER = ",";
    private final int searchScope;
    private final String searchFilter;
    private final Set properties;
    private final NamespaceConfiguration namespaceConfiguration;
    private final String objectClass;

    public SimpleQuery(NamespaceConfiguration theNamespaceConfiguration, String theObjectClass, int theSearchScope, String theSearchFilter, String[] theProperties) throws LocalizableException {
        this.searchScope = theSearchScope;
        this.searchFilter = theSearchFilter;
        this.properties = new HashSet();
        if (theProperties != null) {
            for (int i = 0; i < theProperties.length; ++i) {
                this.properties.add(theProperties[i]);
            }
        }
        this.namespaceConfiguration = theNamespaceConfiguration;
        this.objectClass = theObjectClass;
    }

    private void addDescriptions(UiClass theUiClass, Attributes theAttributes, Map thePropertyMapping) throws NamingException {
        String ldapAttr = (String)thePropertyMapping.get("description");
        if (ldapAttr != null) {
            boolean hasValue = false;
            NamingEnumeration<String> ids = theAttributes.getIDs();
            while (ids.hasMore()) {
                String attrName = ids.next();
                if (!attrName.startsWith(ldapAttr)) continue;
                Attribute attr = theAttributes.get(attrName);
                theUiClass.addDescription(this.getAttributeLanguage(attrName), (String)attr.get());
                hasValue = true;
            }
            if (!hasValue) {
                theUiClass.addDescription(null, null);
            }
        }
    }

    private void addLdapAttributes(Set theLdapAttributes, Set theProperties) {
        theLdapAttributes.add(this.namespaceConfiguration.getCAMIDAttribute());
        theLdapAttributes.add("objectclass");
        Map propertyMapping = this.namespaceConfiguration.getObjectPropertyMappings(this.objectClass);
        if (propertyMapping != null) {
            this.addMatchingProperties(theProperties, theLdapAttributes, propertyMapping);
        }
    }

    private void addMatchingProperties(Set theProperties, Set theAttibutes, Map thePropertyMapping) {
        if (theProperties == null) {
            return;
        }
        if (theProperties.contains("*")) {
            for (Map.Entry pairs : thePropertyMapping.entrySet()) {
                this.tokenizeConfiguredAttributes(theAttibutes, (String)pairs.getValue());
            }
        } else {
            Iterator it = theProperties.iterator();
            while (it.hasNext()) {
                String ldapAttribute = (String)thePropertyMapping.get(it.next());
                if (ldapAttribute == null) continue;
                this.tokenizeConfiguredAttributes(theAttibutes, ldapAttribute);
            }
        }
    }

    private void tokenizeConfiguredAttributes(Set theAttibutes, String ldapAttribute) {
        String configuredAttributes = ldapAttribute;
        String[] tokens = configuredAttributes.split(CONFIG_STRING_DELIMITER);
        for (int i = 0; i < tokens.length; ++i) {
            theAttibutes.add(tokens[i].trim());
        }
    }

    private boolean attributeMatch(String ldapAttribute, String configuredAttribute) {
        String configuredAttributes = configuredAttribute;
        String[] tokens = configuredAttributes.split(CONFIG_STRING_DELIMITER);
        int ldapAttributeLength = ldapAttribute.trim().length();
        for (int i = 0; i < tokens.length; ++i) {
            String configuredLdapAttrName = tokens[i].trim();
            int startOffset = configuredLdapAttrName.length();
            if ((ldapAttributeLength != startOffset || !ldapAttribute.startsWith(configuredLdapAttrName)) && (!ldapAttribute.startsWith(configuredLdapAttrName) || !ldapAttribute.startsWith(LANG_SEPARATOR, startOffset))) continue;
            return true;
        }
        return false;
    }

    private void addNames(BaseClass theBaseClass, Attributes theAttributes, Map thePropertyMapping) throws NamingException {
        String ldapAttr = (String)thePropertyMapping.get("name");
        if (ldapAttr != null) {
            boolean hasValue = false;
            NamingEnumeration<String> ids = theAttributes.getIDs();
            while (ids.hasMore()) {
                String attrName = ids.next();
                if (!this.attributeMatch(attrName, ldapAttr)) continue;
                Attribute attr = theAttributes.get(attrName);
                theBaseClass.addName(this.getAttributeLanguage(attrName), (String)attr.get());
                hasValue = true;
            }
            if (!hasValue) {
                theBaseClass.addName(null, null);
            }
        }
    }

    private Locale getAttributeLanguage(String theAttributeID) {
        int localeStart;
        Locale locale = null;
        int langStart = theAttributeID.indexOf(LANG_SEPARATOR);
        if (langStart > 0 && (localeStart = langStart + LANG_SEPARATOR.length()) < theAttributeID.length()) {
            locale = new Locale(theAttributeID.substring(localeStart));
        }
        return locale;
    }

    private Attribute getPropertyValue(String theProperty, Attributes theAttributes, Map thePropertyMapping) throws NamingException {
        String ldapAttr;
        Attribute retval = null;
        if (this.isPartOfResult(theProperty, thePropertyMapping) && (ldapAttr = (String)thePropertyMapping.get(theProperty)) != null) {
            retval = theAttributes.get(ldapAttr);
        }
        return retval;
    }

    String[] getReturningAttributes(Set theAdditionalAttributes) {
        HashSet returningAttributes = new HashSet();
        if (theAdditionalAttributes != null) {
            returningAttributes.addAll(theAdditionalAttributes);
        }
        this.addLdapAttributes(returningAttributes, this.properties);
        return returningAttributes.toArray(new String[0]);
    }

    protected String getSearchBase(LdapContext theContext) throws NamingException {
        return "";
    }

    private SearchControls getSearchControls(Set theAdditionalAttributes) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(this.searchScope);
        searchControls.setReturningAttributes(this.getReturningAttributes(theAdditionalAttributes));
        searchControls.setTimeLimit(this.namespaceConfiguration.getSearchTimeLimit() * 1000);
        searchControls.setCountLimit(this.namespaceConfiguration.getSearchSizeLimit().intValue());
        return searchControls;
    }

    String getSearchFilter() {
        return this.searchFilter;
    }

    private SearchPath getSearchPath(String theEntryName, Attributes theAttributes, String theObjectType) throws LocalizableException, NamingException {
        String namespaceID = this.namespaceConfiguration.getID();
        String objectID = null;
        String camidAttribute = this.namespaceConfiguration.getCAMIDAttribute();
        objectID = camidAttribute.equals(DN_ATTRIBUTE) ? ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + CAMID_OBJECT_TYPE_SEPARATOR + theEntryName : (camidAttribute.equalsIgnoreCase(OBJECT_GUID_ATTRIBUTE) ? ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + CAMID_OBJECT_TYPE_SEPARATOR + LdapUtil.getGuidCAMID(theAttributes.get(camidAttribute)) : ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + CAMID_OBJECT_TYPE_SEPARATOR + (String)theAttributes.get(camidAttribute).get());
        return new SearchPathImpl(namespaceID, objectID);
    }

    int getSearchScope() {
        return this.searchScope;
    }

    private boolean isPartOfResult(String theProperty, Map thePropertyMapping) {
        return (this.properties.contains("*") || this.properties.contains(theProperty)) && thePropertyMapping.containsKey(theProperty);
    }

    @Override
    public void run(LdapContext theContext, QueryOptions theQueryOptions, QueryResult theResult, Set theAddtionalAttributes) throws SoapFaultException {
        try {
            String searchBase = this.getSearchBase(theContext);
            NamingEnumeration<SearchResult> enumeration = theContext.search(searchBase, this.searchFilter, this.getSearchControls(theAddtionalAttributes));
            String fullDN = LdapUtil.getFullDN(theContext, theContext.getNameInNamespace(), searchBase);
            while (enumeration.hasMoreElements()) {
                boolean isNewObject;
                SearchResult result = enumeration.next();
                this.setAbsoluteName(theContext, result, fullDN);
                String theObjectType = this.namespaceConfiguration.getObjectTypeDeterminer().getObjectType(result);
                SearchPath searchPath = this.getSearchPath(result.getName(), result.getAttributes(), theObjectType);
                BaseClass object = theResult.get(searchPath);
                boolean bl = isNewObject = object == null;
                if (isNewObject) {
                    object = theResult.create(searchPath, this.objectClass);
                }
                this.setObjectProperties(object, result.getAttributes());
                object.setUserData((Object)result);
                if (!isNewObject) continue;
                theResult.add(object);
            }
        }
        catch (NamingException e) {
            throw new InternalErrorException(ACTOR, (Exception)e);
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(ACTOR, (Exception)((Object)e));
        }
    }

    private void setAbsoluteName(LdapContext context, SearchResult theSearchResult, String searchBase) {
        if (theSearchResult.isRelative()) {
            String fullDn = LdapUtil.getFullDN(context, searchBase, theSearchResult.getName());
            theSearchResult.setName(fullDn);
            theSearchResult.setRelative(false);
        }
    }

    private void setAccountProperties(Account theAccount, Attributes theAttributes, Map thePropertyMapping) throws NamingException {
        Attribute attr = null;
        if (this.isPartOfResult("businessPhone", thePropertyMapping)) {
            String businessPhone = null;
            attr = this.getPropertyValue("businessPhone", theAttributes, thePropertyMapping);
            if (attr != null) {
                businessPhone = (String)attr.get();
            }
            theAccount.setBusinessPhone(businessPhone);
        }
        if (this.isPartOfResult("contentLocale", thePropertyMapping)) {
            Locale contentLocale = null;
            attr = this.getPropertyValue("contentLocale", theAttributes, thePropertyMapping);
            if (attr != null) {
                contentLocale = new Locale((String)attr.get());
            }
            theAccount.setContentLocale(contentLocale);
        }
        if (this.isPartOfResult("email", thePropertyMapping)) {
            String email = null;
            attr = this.getPropertyValue("email", theAttributes, thePropertyMapping);
            if (attr != null) {
                email = (String)attr.get();
            }
            theAccount.setEmail(email);
        }
        if (this.isPartOfResult("faxPhone", thePropertyMapping)) {
            String faxPhone = null;
            attr = this.getPropertyValue("faxPhone", theAttributes, thePropertyMapping);
            if (attr != null) {
                faxPhone = (String)attr.get();
            }
            theAccount.setFaxPhone(faxPhone);
        }
        if (this.isPartOfResult("givenName", thePropertyMapping)) {
            String givenName = null;
            attr = this.getPropertyValue("givenName", theAttributes, thePropertyMapping);
            if (attr != null) {
                givenName = (String)attr.get();
            }
            theAccount.setGivenName(givenName);
        }
        if (this.isPartOfResult("homePhone", thePropertyMapping)) {
            String homePhone = null;
            attr = this.getPropertyValue("homePhone", theAttributes, thePropertyMapping);
            if (attr != null) {
                homePhone = (String)attr.get();
            }
            theAccount.setHomePhone(homePhone);
        }
        if (this.isPartOfResult("mobilePhone", thePropertyMapping)) {
            String mobilePhone = null;
            attr = this.getPropertyValue("mobilePhone", theAttributes, thePropertyMapping);
            if (attr != null) {
                mobilePhone = (String)attr.get();
            }
            theAccount.setMobilePhone(mobilePhone);
        }
        if (this.isPartOfResult("pagerPhone", thePropertyMapping)) {
            String pagerPhone = null;
            attr = this.getPropertyValue("pagerPhone", theAttributes, thePropertyMapping);
            if (attr != null) {
                pagerPhone = (String)attr.get();
            }
            theAccount.setPagerPhone(pagerPhone);
        }
        if (this.isPartOfResult("postalAddress", thePropertyMapping)) {
            String postalAddress = null;
            attr = this.getPropertyValue("postalAddress", theAttributes, thePropertyMapping);
            if (attr != null) {
                postalAddress = (String)attr.get();
            }
            theAccount.setPostalAddress(postalAddress);
        }
        if (this.isPartOfResult("productLocale", thePropertyMapping)) {
            Locale productLocale = null;
            attr = this.getPropertyValue("productLocale", theAttributes, thePropertyMapping);
            if (attr != null) {
                productLocale = new Locale((String)attr.get());
            }
            theAccount.setProductLocale(productLocale);
        }
        if (this.isPartOfResult("surname", thePropertyMapping)) {
            String surname = null;
            attr = this.getPropertyValue("surname", theAttributes, thePropertyMapping);
            if (attr != null) {
                surname = (String)attr.get();
            }
            theAccount.setSurname(surname);
        }
        if (this.isPartOfResult("userName", thePropertyMapping)) {
            String username = null;
            attr = this.getPropertyValue("userName", theAttributes, thePropertyMapping);
            if (attr != null) {
                username = (String)attr.get();
            }
            theAccount.setUserName(username);
        }
    }

    private void setBaseClassProperties(BaseClass theBaseClass, Attributes theAttributes, Map thePropertyMapping) throws NamingException, LocalizableException {
        if (this.isPartOfResult("name", thePropertyMapping) || this.isPartOfResult("defaultName", thePropertyMapping)) {
            this.addNames(theBaseClass, theAttributes, thePropertyMapping);
        }
    }

    private void setObjectProperties(BaseClass theBaseClass, Attributes theAttributes) throws NamingException, LocalizableException {
        Map propertyMapping = this.namespaceConfiguration.getObjectPropertyMappings(this.objectClass);
        if (propertyMapping != null) {
            this.setBaseClassProperties(theBaseClass, theAttributes, propertyMapping);
            this.setUiClassProperties((UiClass)theBaseClass, theAttributes, propertyMapping);
            if (theBaseClass instanceof Account) {
                this.setAccountProperties((Account)theBaseClass, theAttributes, propertyMapping);
            }
        }
    }

    private void setUiClassProperties(UiClass theUiClass, Attributes theAttributes, Map thePropertyMapping) throws NamingException {
        if (this.isPartOfResult("description", thePropertyMapping) || this.isPartOfResult("defaultDescription", thePropertyMapping)) {
            this.addDescriptions(theUiClass, theAttributes, thePropertyMapping);
        }
    }
}

