/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.ldap.admin.SimpleQueryResultImpl;
import com.ibm.cognos.camaaa.internal.ldap.admin.UnidentifiedClassQueryUsingDN;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import java.util.Stack;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class RetrieveAncestors
extends DefaultHandler {
    private static final String[] PROPERTIES = new String[]{"name"};
    private NamespaceConfiguration nsConfig;
    private String[] possibleObjestClassese;

    protected boolean handleOutboundRequest(MessageContext theContext) throws SoapFaultException {
        Query query = (Query)theContext.get((Object)Query.class.getName());
        if (query == null | !this.isAncestorsRequested(query)) {
            return true;
        }
        QueryResult queryResult = (QueryResult)theContext.get((Object)QueryResult.class.getName());
        LdapContext ldapContext = (LdapContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.ldap.common.LdapConstants:LDAP_CONTEXT");
        BaseClass[] objects = queryResult.getAll();
        Namespace namespace = (Namespace)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespaceObject");
        try {
            for (int i = 0; i < objects.length; ++i) {
                Stack ancestors = new Stack();
                this.retrieveObjectAncestors(ldapContext, objects[i], ancestors, queryResult);
                BaseClass[] ancestorObjs = new BaseClass[ancestors.size()];
                objects[i].setAncestors(namespace, ancestors.toArray(ancestorObjs));
            }
        }
        catch (NamingException ne) {
            throw new InternalErrorException(RetrieveAncestors.class.getName(), (Exception)ne);
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(RetrieveAncestors.class.getName(), (Exception)((Object)e));
        }
        return true;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.nsConfig = (NamespaceConfiguration)theConfig.get((Object)NamespaceConfiguration.class.getName());
        String[] objectTypes = new String[]{"namespaceFolder", "role", "group", "account", "namespace", "distributionList"};
        Vector<String> objectClasses = new Vector<String>();
        for (int i = 0; i < objectTypes.length; ++i) {
            if (this.nsConfig.getObjectClassFilter(objectTypes[i]) == null) continue;
            objectClasses.add(objectTypes[i]);
        }
        this.possibleObjestClassese = new String[objectClasses.size()];
        objectClasses.toArray(this.possibleObjestClassese);
    }

    private boolean isAncestorsRequested(Query theQuery) {
        String[] properties = theQuery.getProperties();
        if (properties != null) {
            for (int j = 0; j < properties.length; ++j) {
                if (!properties[j].equals("ancestors")) continue;
                return true;
            }
        }
        return false;
    }

    private void retrieveObjectAncestors(LdapContext theContext, BaseClass object, Stack ancestors, QueryResult queryResult) throws LocalizableException, NamingException {
        if (object instanceof Namespace) {
            return;
        }
        SearchResult searchResult = (SearchResult)object.getUserData();
        String name = searchResult.getName();
        String parentDN2 = LdapUtil.getParentDN(theContext, name);
        if (parentDN2 == null || parentDN2.equals("") || parentDN2.equals(theContext.getNameInNamespace())) {
            return;
        }
        UnidentifiedClassQueryUsingDN query = new UnidentifiedClassQueryUsingDN(parentDN2, this.nsConfig, this.possibleObjestClassese, PROPERTIES);
        SimpleQueryResultImpl theResult = new SimpleQueryResultImpl(queryResult);
        query.run(theContext, null, (QueryResult)theResult, null);
        BaseClass[] parents = theResult.getAll();
        if (parents.length == 1) {
            this.retrieveObjectAncestors(theContext, parents[0], ancestors, queryResult);
            ancestors.add(parents[0]);
        }
    }
}

