/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class RetrieveHasChildren
extends DefaultHandler {
    public static final String HAS_SUBORDINATES = "hasSubordinates";
    public static final String NUM_SUBORDINATES = "numSubordinates";
    private static final String HAS_CHILDREN_PROPERTY = "hasChildren";
    private String hasChildrenAttributeName;
    private NamespaceConfiguration namespaceConfiguration;

    private Boolean getValue(Attribute theAttribute) {
        try {
            String val = (String)theAttribute.get();
            boolean hasChildren = false;
            if (this.hasChildrenAttributeName.equals(HAS_SUBORDINATES)) {
                hasChildren = Boolean.getBoolean(val);
            } else {
                int numOfChildren = Integer.parseInt(val);
                if (numOfChildren > 0) {
                    hasChildren = true;
                }
            }
            return hasChildren;
        }
        catch (NamingException e) {
            return null;
        }
    }

    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        Query query = (Query)theContext.get((Object)Query.class.getName());
        if (query != null && this.isHasChildrenRequested(query)) {
            HashSet<String> attributes = (HashSet<String>)theContext.get((Object)"com.ibm.cognos.camaaa.internal.ldap.common.LdapConstants:LDAP_ATTRIBUTES");
            if (attributes == null) {
                attributes = new HashSet<String>();
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.ldap.common.LdapConstants:LDAP_ATTRIBUTES", attributes);
            }
            attributes.add(this.hasChildrenAttributeName);
        }
        return true;
    }

    protected boolean handleOutboundRequest(MessageContext theContext) throws SoapFaultException {
        Query query = (Query)theContext.get((Object)Query.class.getName());
        if (query == null || !this.isHasChildrenRequested(query)) {
            return true;
        }
        QueryResult queryResult = (QueryResult)theContext.get((Object)QueryResult.class.getName());
        BaseClass[] objects = queryResult.getAll();
        for (int i = 0; i < objects.length; ++i) {
            Boolean val;
            boolean hasChildren = false;
            BaseClass theObject = objects[i];
            SearchResult searchResult = (SearchResult)theObject.getUserData();
            Attributes attributes = searchResult.getAttributes();
            Attribute hasChildrenAttribute = attributes.get(this.hasChildrenAttributeName);
            if (hasChildrenAttribute != null && (val = this.getValue(hasChildrenAttribute)) != null) {
                hasChildren = val;
            }
            theObject.setHasChildren(Boolean.valueOf(hasChildren));
        }
        return true;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.namespaceConfiguration = (NamespaceConfiguration)theConfig.get((Object)NamespaceConfiguration.class.getName());
        SearchResult searchResult = null;
        try {
            LdapContext ldapContext = this.namespaceConfiguration.getContext(null);
            String filter = new String("(objectclass=*)");
            NamingEnumeration<SearchResult> nameEnum = ldapContext.search("", filter, null);
            searchResult = nameEnum.next();
        }
        catch (NamingException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"), (Throwable)e);
        }
        Attributes attributes = searchResult.getAttributes();
        Attribute theAttribute = attributes.get(HAS_SUBORDINATES);
        this.hasChildrenAttributeName = NUM_SUBORDINATES;
        if (theAttribute != null) {
            try {
                theAttribute.get();
                this.hasChildrenAttributeName = HAS_SUBORDINATES;
            }
            catch (NamingException e) {
                this.hasChildrenAttributeName = NUM_SUBORDINATES;
            }
        } else {
            this.hasChildrenAttributeName = NUM_SUBORDINATES;
        }
    }

    private boolean isHasChildrenRequested(Query theQuery) {
        String[] properties = theQuery.getProperties();
        if (properties != null) {
            for (int j = 0; j < properties.length; ++j) {
                if (!properties[j].equals(HAS_CHILDREN_PROPERTY)) continue;
                return true;
            }
        }
        return false;
    }
}

