/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.ldap.admin.ObjectTypeDeterminer;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class RetrieveMemberOf
extends DefaultHandler {
    private static final String ACTOR = RetrieveMemberOf.class.getName();
    private static final String OBJECT_TYPE_IDENTIFIER_SEPARATOR = ":";
    private static final String OBJECTCLASS_LDAP_ATTR = "objectclass";
    private static final String MEMBER_OF_PROPERTY = "memberOf";
    private static final String DN_ATTRIBUTE = "dn";
    private static final String OBJECT_GUID_ATTRIBUTE = "objectGUID";
    private String camIDAttribute;
    private String namespaceID;
    private String groupSearchFilter;
    private String groupMemberAttribute;
    private String distributionListSearchFilter;
    private String distributionListMemberAttribute;
    private long countLimit;
    private int timelimit;
    private String[] attributes;
    private ObjectTypeDeterminer objectTypeDeterminer;

    private String getDistributionListSeachFilter(SearchResult theSearchResult) throws NamingException {
        StringBuffer searchFilter = new StringBuffer();
        searchFilter.append('(');
        searchFilter.append('&');
        searchFilter.append(this.distributionListSearchFilter);
        searchFilter.append('(');
        searchFilter.append(this.distributionListMemberAttribute);
        searchFilter.append('=');
        searchFilter.append(this.getEscapedDN(theSearchResult));
        searchFilter.append(')');
        searchFilter.append(')');
        return searchFilter.toString();
    }

    private String getEscapedDN(SearchResult theSearchResult) throws NamingException {
        String entryDN = theSearchResult.getName();
        StringBuffer buffer = new StringBuffer();
        block8: for (int i = 0; i < entryDN.length(); ++i) {
            switch (entryDN.charAt(i)) {
                case '*': {
                    buffer.append('\\');
                    buffer.append("2A");
                    continue block8;
                }
                case '(': {
                    buffer.append('\\');
                    buffer.append("28");
                    continue block8;
                }
                case ')': {
                    buffer.append('\\');
                    buffer.append("29");
                    continue block8;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append("5C");
                    continue block8;
                }
                case '/': {
                    buffer.append('\\');
                    buffer.append("3F");
                    continue block8;
                }
                case '=': {
                    buffer.append('\\');
                    buffer.append("3D");
                    continue block8;
                }
                default: {
                    buffer.append(entryDN.charAt(i));
                }
            }
        }
        return buffer.toString();
    }

    private String getGroupSeachFilter(SearchResult theSearchResult) throws NamingException {
        StringBuffer searchFilter = new StringBuffer();
        searchFilter.append('(');
        searchFilter.append('&');
        searchFilter.append(this.groupSearchFilter);
        searchFilter.append('(');
        searchFilter.append(this.groupMemberAttribute);
        searchFilter.append('=');
        searchFilter.append(this.getEscapedDN(theSearchResult));
        searchFilter.append(')');
        searchFilter.append(')');
        return searchFilter.toString();
    }

    private String getObjectID(LdapContext theLdapContext, SearchResult theSearchResult, String theObjectType) throws NamingException {
        String objectID = null;
        Attribute objectIDAttribute = theSearchResult.getAttributes().get(this.camIDAttribute);
        objectID = this.camIDAttribute.equals(DN_ATTRIBUTE) ? ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + OBJECT_TYPE_IDENTIFIER_SEPARATOR + theSearchResult.getName() : (this.camIDAttribute.equalsIgnoreCase(OBJECT_GUID_ATTRIBUTE) ? ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + OBJECT_TYPE_IDENTIFIER_SEPARATOR + LdapUtil.getGuidCAMID(objectIDAttribute) : ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + OBJECT_TYPE_IDENTIFIER_SEPARATOR + (String)objectIDAttribute.get());
        return objectID;
    }

    private String getSearchFilter(SearchResult theSearchResult, LdapContext theContext) throws NamingException {
        StringBuffer searchFilter = new StringBuffer();
        if (this.groupSearchFilter != null && this.distributionListSearchFilter != null) {
            searchFilter.append("(|");
            searchFilter.append(this.getGroupSeachFilter(theSearchResult));
            searchFilter.append(this.getDistributionListSeachFilter(theSearchResult));
            searchFilter.append(')');
        } else if (this.groupSearchFilter != null) {
            searchFilter.append(this.getGroupSeachFilter(theSearchResult));
        } else if (this.distributionListSearchFilter != null) {
            searchFilter.append(this.getDistributionListSeachFilter(theSearchResult));
        }
        return searchFilter.toString();
    }

    private SearchPath getSearchPath(LdapContext theLdapContext, SearchResult theSearchResult, String theObjectType) throws NamingException, SoapFaultException {
        String objectID = this.getObjectID(theLdapContext, theSearchResult, theObjectType);
        return new SearchPathImpl(this.namespaceID, objectID);
    }

    protected boolean handleOutboundRequest(MessageContext theContext) throws SoapFaultException {
        Query query = (Query)theContext.get((Object)Query.class.getName());
        QueryResult result = (QueryResult)theContext.get((Object)QueryResult.class.getName());
        LdapContext ldapContext = (LdapContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.ldap.common.LdapConstants:LDAP_CONTEXT");
        if (query != null && this.isRequestForMemberOf(query) && (this.groupMemberAttribute != null || this.distributionListMemberAttribute != null)) {
            BaseClass[] entries = result.getAll();
            try {
                for (int j = 0; j < entries.length; ++j) {
                    this.setMemberOfProperty(ldapContext, entries[j], result);
                }
            }
            catch (NamingException e) {
                throw new InternalErrorException(ACTOR, (Exception)e);
            }
        }
        return true;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        Map mapping;
        NamespaceConfiguration config = (NamespaceConfiguration)theConfig.get((Object)NamespaceConfiguration.class.getName());
        this.namespaceID = config.getID();
        this.camIDAttribute = config.getCAMIDAttribute();
        this.attributes = this.camIDAttribute.equals(DN_ATTRIBUTE) ? new String[]{DN_ATTRIBUTE, OBJECTCLASS_LDAP_ATTR} : new String[]{DN_ATTRIBUTE, this.camIDAttribute, OBJECTCLASS_LDAP_ATTR};
        this.timelimit = config.getSearchTimeLimit();
        this.countLimit = config.getSearchSizeLimit().longValue();
        this.groupSearchFilter = config.getObjectClassFilter("group");
        if (this.groupSearchFilter != null && (mapping = config.getObjectPropertyMappings("group")) != null) {
            this.groupMemberAttribute = (String)mapping.get("members");
        }
        this.distributionListSearchFilter = config.getObjectClassFilter("distributionList");
        if (this.distributionListSearchFilter != null && (mapping = config.getObjectPropertyMappings("distributionList")) != null) {
            this.distributionListMemberAttribute = (String)mapping.get("members");
        }
        this.objectTypeDeterminer = config.getObjectTypeDeterminer();
    }

    private boolean isRequestForMemberOf(Query theQuery) {
        String[] properties = theQuery.getProperties();
        if (properties != null) {
            for (int j = 0; j < properties.length; ++j) {
                if (!properties[j].equals(MEMBER_OF_PROPERTY)) continue;
                return true;
            }
        }
        return false;
    }

    private void populateMembership(LdapContext theLdapContext, SearchControls theSearchControls, SearchResult theSearchResult, Set theVisitedSearchPath, List theMembership, QueryResult queryResult) throws NamingException, SoapFaultException {
        String theObjectType;
        SearchPath searchPath;
        if (theSearchResult.isRelative()) {
            String fullDN = LdapUtil.getFullDN(theLdapContext, theLdapContext.getNameInNamespace(), theSearchResult.getName());
            theSearchResult.setName(fullDN);
            theSearchResult.setRelative(false);
        }
        if (!theVisitedSearchPath.contains((searchPath = this.getSearchPath(theLdapContext, theSearchResult, theObjectType = this.objectTypeDeterminer.getObjectType(theSearchResult))).getValue())) {
            theVisitedSearchPath.add(searchPath.getValue());
            if (theObjectType.equals("group")) {
                theMembership.add(queryResult.create(searchPath, "group"));
            } else if (theObjectType.equals("distributionList")) {
                theMembership.add(queryResult.create(searchPath, "distributionList"));
            }
            String searchFilter = this.getSearchFilter(theSearchResult, theLdapContext);
            NamingEnumeration<SearchResult> enumeration = theLdapContext.search("", searchFilter, theSearchControls);
            while (enumeration.hasMoreElements()) {
                SearchResult searchResult = enumeration.next();
                this.populateMembership(theLdapContext, theSearchControls, searchResult, theVisitedSearchPath, theMembership, queryResult);
            }
        }
    }

    private void setMemberOfProperty(LdapContext theLdapContext, BaseClass theBaseClass, QueryResult queryResult) throws NamingException, SoapFaultException {
        if (theBaseClass instanceof Account) {
            Account account = (Account)theBaseClass;
            SearchResult searchResult = (SearchResult)account.getUserData();
            SearchControls searchControls = new SearchControls(2, this.countLimit, this.timelimit, this.attributes, false, false);
            ArrayList membership = new ArrayList();
            HashSet visitedSearchPath = new HashSet();
            this.populateMembership(theLdapContext, searchControls, searchResult, visitedSearchPath, membership, queryResult);
            account.setMemberOf(membership.toArray(new BaseClass[0]));
        }
    }
}

