/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.DistributionList;
import com.ibm.cognos.camaaa.internal.admin.soap.Group;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.ldap.admin.ObjectTypeDeterminer;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class RetrieveMembers
extends DefaultHandler {
    private static final String ACTOR = RetrieveMembers.class.getName();
    private static final String MEMBERS_PROPERTY = "members";
    private static final String OBJECT_TYPE_IDENTIFIER_SEPARATOR = ":";
    private static final String OBJECTCLASS_LDAP_ATTR = "objectclass";
    private static final String DN_ATTRIBUTE = "dn";
    private static final String OBJECT_GUID_ATTRIBUTE = "objectGUID";
    private int timelimit;
    private long countLimit;
    private String namespaceID;
    private String[] attributes;
    private String camIDAttribute;
    private String groupMemberAttribute;
    private String distributionListMemberAttribute;
    private ObjectTypeDeterminer objectTypeDeterminer;

    private BaseClass[] getMembers(LdapContext theLdapContext, SearchResult theSearchResult, QueryResult queryResult) throws NamingException, SoapFaultException {
        String theObjectType = this.objectTypeDeterminer.getObjectType(theSearchResult);
        Attribute membersAttribute = null;
        if (theObjectType.equals("group") && this.groupMemberAttribute != null) {
            membersAttribute = theSearchResult.getAttributes().get(this.groupMemberAttribute);
        } else if (theObjectType.equals("distributionList") && this.distributionListMemberAttribute != null) {
            membersAttribute = theSearchResult.getAttributes().get(this.distributionListMemberAttribute);
        }
        if (membersAttribute == null) {
            return new BaseClass[0];
        }
        SearchControls searchControls = new SearchControls(0, this.countLimit, this.timelimit, this.attributes, false, false);
        String searchFilter = "(objectclass=*)";
        ArrayList<BaseClass> memberObjects = new ArrayList<BaseClass>();
        NamingEnumeration<?> dnEnum = membersAttribute.getAll();
        while (dnEnum.hasMore()) {
            String objectDN = LdapUtil.getRelativeDN(theLdapContext, theLdapContext.getNameInNamespace(), (String)dnEnum.next());
            NamingEnumeration<SearchResult> enumeration = theLdapContext.search(objectDN, "(objectclass=*)".toString(), searchControls);
            if (!enumeration.hasMore()) continue;
            SearchResult memberSearchResult = enumeration.next();
            String memberObjectType = this.objectTypeDeterminer.getObjectType(memberSearchResult);
            SearchPath memberSearchPath = this.getSearchPath(theLdapContext, memberSearchResult, memberObjectType);
            BaseClass memberObject = queryResult.create(memberSearchPath, memberObjectType);
            memberObjects.add(memberObject);
        }
        return memberObjects.toArray(new BaseClass[0]);
    }

    private String getObjectID(LdapContext theLdapContext, SearchResult theSearchResult, String theObjectType) throws NamingException {
        String objectID = null;
        Attribute objectIDAttribute = theSearchResult.getAttributes().get(this.camIDAttribute);
        objectID = this.camIDAttribute.equals(DN_ATTRIBUTE) ? ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + OBJECT_TYPE_IDENTIFIER_SEPARATOR + theSearchResult.getName() : (this.camIDAttribute.equalsIgnoreCase(OBJECT_GUID_ATTRIBUTE) ? ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + OBJECT_TYPE_IDENTIFIER_SEPARATOR + LdapUtil.getGuidCAMID(objectIDAttribute) : ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectType) + OBJECT_TYPE_IDENTIFIER_SEPARATOR + (String)objectIDAttribute.get());
        return objectID;
    }

    private SearchPath getSearchPath(LdapContext theLdapContext, SearchResult theSearchResult, String theObjectType) throws NamingException, SoapFaultException {
        String objectID = this.getObjectID(theLdapContext, theSearchResult, theObjectType);
        return new SearchPathImpl(this.namespaceID, objectID);
    }

    protected boolean handleOutboundRequest(MessageContext theContext) throws SoapFaultException {
        Query query = (Query)theContext.get((Object)Query.class.getName());
        QueryResult result = (QueryResult)theContext.get((Object)QueryResult.class.getName());
        LdapContext ldapContext = (LdapContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.ldap.common.LdapConstants:LDAP_CONTEXT");
        if (query != null && this.isRequestForMembers(query)) {
            BaseClass[] entries = result.getAll();
            try {
                for (int j = 0; j < entries.length; ++j) {
                    this.setMembersProperty(ldapContext, entries[j], result);
                }
            }
            catch (NamingException e) {
                throw new InternalErrorException(ACTOR, (Exception)e);
            }
        }
        return true;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        Map distributionListMapping;
        NamespaceConfiguration config = (NamespaceConfiguration)theConfig.get((Object)NamespaceConfiguration.class.getName());
        this.namespaceID = config.getID();
        this.camIDAttribute = config.getCAMIDAttribute();
        this.attributes = this.camIDAttribute.equals(DN_ATTRIBUTE) ? new String[]{DN_ATTRIBUTE, OBJECTCLASS_LDAP_ATTR} : new String[]{DN_ATTRIBUTE, this.camIDAttribute, OBJECTCLASS_LDAP_ATTR};
        this.timelimit = config.getSearchTimeLimit();
        this.countLimit = config.getSearchSizeLimit().longValue();
        Map groupMapping = config.getObjectPropertyMappings("group");
        if (groupMapping != null) {
            this.groupMemberAttribute = (String)groupMapping.get(MEMBERS_PROPERTY);
        }
        if ((distributionListMapping = config.getObjectPropertyMappings("distributionList")) != null) {
            this.distributionListMemberAttribute = (String)distributionListMapping.get(MEMBERS_PROPERTY);
        }
        this.objectTypeDeterminer = config.getObjectTypeDeterminer();
    }

    private boolean isRequestForMembers(Query theQuery) {
        String[] properties = theQuery.getProperties();
        if (properties != null) {
            for (int j = 0; j < properties.length; ++j) {
                if (!properties[j].equals(MEMBERS_PROPERTY)) continue;
                return true;
            }
        }
        return false;
    }

    private void setMembersProperty(LdapContext ldapContext, BaseClass baseClass, QueryResult queryResult) throws NamingException, SoapFaultException {
        DistributionList distributionList;
        SearchResult searchResult;
        BaseClass[] membership;
        if (baseClass instanceof Group && this.groupMemberAttribute != null) {
            Group group = (Group)baseClass;
            SearchResult searchResult2 = (SearchResult)group.getUserData();
            BaseClass[] membership2 = this.getMembers(ldapContext, searchResult2, queryResult);
            if (membership2 != null) {
                group.setMembers(membership2);
            }
        } else if (baseClass instanceof DistributionList && this.distributionListMemberAttribute != null && (membership = this.getMembers(ldapContext, searchResult = (SearchResult)(distributionList = (DistributionList)baseClass).getUserData(), queryResult)) != null) {
            distributionList.setMembers(membership);
        }
    }
}

