/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

public class RetrieveParameters
extends DefaultHandler {
    private static final String ACTOR = RetrieveParameters.class.getName();
    private Map parameters;

    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return true;
        }
        Query query = (Query)theContext.get((Object)Query.class.getName());
        if (query != null && this.isRequestForParameters(query)) {
            HashSet attributes = (HashSet)theContext.get((Object)"com.ibm.cognos.camaaa.internal.ldap.common.LdapConstants:LDAP_ATTRIBUTES");
            if (attributes == null) {
                attributes = new HashSet();
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.ldap.common.LdapConstants:LDAP_ATTRIBUTES", attributes);
            }
            Iterator it = this.parameters.keySet().iterator();
            while (it.hasNext()) {
                attributes.add(this.parameters.get(it.next()));
            }
        }
        return true;
    }

    protected boolean handleOutboundRequest(MessageContext theContext) throws SoapFaultException {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return true;
        }
        Query query = (Query)theContext.get((Object)Query.class.getName());
        QueryResult result = (QueryResult)theContext.get((Object)QueryResult.class.getName());
        if (result != null && query != null && this.isRequestForParameters(query)) {
            BaseClass[] entries = result.getAll();
            for (int j = 0; j < entries.length; ++j) {
                this.setAccountParameters(entries[j]);
            }
        }
        return true;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        NamespaceConfiguration config = (NamespaceConfiguration)theConfig.get((Object)NamespaceConfiguration.class.getName());
        this.parameters = config.getAccountParameters();
    }

    private boolean isRequestForParameters(Query theQuery) {
        String[] properties = theQuery.getProperties();
        if (properties != null) {
            for (int j = 0; j < properties.length; ++j) {
                if (!properties[j].equals("parameters") && !properties[j].equals("*")) continue;
                return true;
            }
        }
        return false;
    }

    private void setAccountParameters(BaseClass theBaseClass) throws InternalErrorException {
        if (theBaseClass instanceof Account) {
            Account account = (Account)theBaseClass;
            SearchResult searchResult = (SearchResult)account.getUserData();
            Attributes attributes = searchResult.getAttributes();
            Set keySet = this.parameters.keySet();
            for (String name : keySet) {
                String ldapAttribute = (String)this.parameters.get(name);
                Attribute attr = attributes.get(ldapAttribute);
                if (attr == null) continue;
                try {
                    NamingEnumeration<?> enumeration = attr.getAll();
                    while (enumeration.hasMore()) {
                        account.addParameter(name, (String)enumeration.next());
                    }
                }
                catch (NamingException e) {
                    throw new InternalErrorException(ACTOR, (Exception)e);
                }
            }
        }
    }
}

