/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.auth;

import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.ldap.auth.LDAPVisaImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;

public class LDAPVisaFromCredentials
extends LDAPVisaImpl {
    private static final String ACTOR = LDAPVisaFromCredentials.class.getName();

    public LDAPVisaFromCredentials(LdapContext theLdapContext, String theUserDN) {
        super(theLdapContext, theUserDN);
    }

    public LDAPVisaFromCredentials() {
    }

    @Override
    public Credential generateTrustedCredential() throws SoapFaultException {
        return this.getCredential();
    }

    private Credential getCredential() throws SoapFaultException {
        CredentialImpl credential = new CredentialImpl();
        try {
            Hashtable<?, ?> env = this.getContext().getEnvironment();
            String username = (String)env.get("java.naming.security.principal");
            String password = (String)env.get("java.naming.security.credentials");
            credential.addCredentialPair("username", new String[]{username});
            credential.addCredentialPair("password", new String[]{password});
            return credential;
        }
        catch (NamingException e) {
            throw new InternalErrorException(ACTOR, (Exception)e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    @Override
    public Credential retrieveCredential() throws SoapFaultException {
        return this.getCredential();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }
}

