/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.auth;

import com.ibm.cognos.camaaa.internal.ldap.auth.LDAPVisa;
import com.ibm.cognos.camaaa.internal.ldap.control.BasicControl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

abstract class LDAPVisaImpl
implements LDAPVisa {
    private static final long serialVersionUID = 123456789L;
    private LdapContext context;
    private final String userDN;
    private boolean dirty;

    public LDAPVisaImpl() {
        this.context = null;
        this.userDN = null;
        this.dirty = true;
    }

    public LDAPVisaImpl(LdapContext theLdapContext, String theUserDN) {
        this.context = theLdapContext;
        this.userDN = theUserDN;
        this.dirty = true;
    }

    @Override
    public LdapContext getContext() {
        return this.context;
    }

    @Override
    public String getUserDN() {
        return this.userDN;
    }

    public boolean hasStateChanged() {
        return this.dirty;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 123456789L) {
            throw new IOException("Unknown version: " + Long.toString(version));
        }
        Properties environment = new Properties();
        int envSize = in.readInt();
        for (int i = 0; i < envSize; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            ((Hashtable)environment).put(key, value);
        }
        int nbControls = in.readInt();
        Control[] controls = new Control[nbControls];
        for (int i = 0; i < nbControls; ++i) {
            String id = in.readUTF();
            boolean isCritical = in.readBoolean();
            int encodedValueLength = in.readInt();
            byte[] encodedValue = new byte[encodedValueLength];
            if (encodedValueLength > 0) {
                in.read(encodedValue);
            } else {
                encodedValue = null;
            }
            controls[i] = new BasicControl(id, isCritical, encodedValue);
        }
        try {
            this.context = new InitialLdapContext(environment, controls);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.dirty = true;
    }

    public void resetChangeIndicator() {
        this.dirty = false;
    }

    public void setStateChanged() {
        this.dirty = true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            Hashtable<?, ?> environment = this.context.getEnvironment();
            Control[] controls = this.context.getConnectControls();
            out.writeLong(123456789L);
            out.writeInt(environment.size());
            Set<Map.Entry<?, ?>> entries = environment.entrySet();
            for (Map.Entry<?, ?> entry : entries) {
                out.writeUTF(entry.getKey().toString());
                out.writeUTF(entry.getValue().toString());
            }
            int nbControls = 0;
            if (controls != null) {
                nbControls = controls.length;
            }
            out.writeInt(controls.length);
            for (int i = 0; i < nbControls; ++i) {
                out.writeUTF(controls[i].getID());
                out.writeBoolean(controls[i].isCritical());
                byte[] encodedValue = controls[i].getEncodedValue();
                if (encodedValue == null) {
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(encodedValue.length);
                out.write(controls[i].getEncodedValue());
            }
            out.flush();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

