/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.auth.handler;

import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.naming.ldap.LdapContext;

public class GenerateDnOrSearchFilter
extends DefaultHandler {
    private static final int STRING_ARRAY_SIZE = 3;
    private String baseDNString;

    private String appendBaseDN(LdapContext context, String mappingString) {
        if (mappingString.startsWith("(") && mappingString.endsWith(")")) {
            return mappingString;
        }
        String retval = null;
        String relativeDN = LdapUtil.getRelativeDN(context, this.baseDNString, mappingString);
        retval = relativeDN == null ? LdapUtil.getFullDN(context, this.baseDNString, mappingString) : LdapUtil.getFullDN(context, this.baseDNString, relativeDN);
        return retval;
    }

    private String getReplacedMappingString(String mappingString) throws SoapFaultException {
        String replaceStart = "${replace(";
        String replaceEnd = ")}";
        String replacedMappingString = new String("");
        int startIndex = mappingString.indexOf("${replace(");
        int lastEndIndex = 0;
        boolean errorOccurred = false;
        while (startIndex != -1) {
            replacedMappingString = replacedMappingString + mappingString.substring(lastEndIndex, startIndex);
            int endIndex = mappingString.indexOf(")}", startIndex);
            if (endIndex == -1) {
                errorOccurred = true;
                break;
            }
            if (endIndex > startIndex) {
                String replacingStrings = mappingString.substring(startIndex + "${replace(".length(), endIndex);
                String[] splitedStrings = this.splitReplacingString(replacingStrings);
                if (splitedStrings == null || splitedStrings.length != 3) {
                    errorOccurred = true;
                    break;
                }
                String source = splitedStrings[0];
                String pattern = splitedStrings[1];
                String replacementValue = splitedStrings[2];
                source = this.replaceAll(source, pattern, replacementValue);
                replacedMappingString = replacedMappingString + source;
                lastEndIndex = endIndex + ")}".length();
            }
            startIndex = mappingString.indexOf("${replace(", lastEndIndex);
        }
        if (errorOccurred) {
            return null;
        }
        if (lastEndIndex < mappingString.length()) {
            replacedMappingString = replacedMappingString.concat(mappingString.substring(lastEndIndex, mappingString.length()));
        }
        return replacedMappingString;
    }

    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean retval;
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            return true;
        }
        String mappingString = (String)theContext.get((Object)"mappingString");
        String newMappingString = this.substituteMappingIdentities(mappingString, theContext);
        if ((newMappingString = this.getReplacedMappingString(newMappingString)) == null) {
            retval = false;
        } else {
            LdapContext ldapContext = (LdapContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.ldap.common.LdapConstants:LDAP_CONTEXT");
            newMappingString = this.appendBaseDN(ldapContext, newMappingString);
            theContext.put((Object)"userLookup", (Object)newMappingString);
            retval = true;
        }
        return retval;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration configMgr = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        this.baseDNString = configMgr.getMandatoryValue("./*[local-name()='parameter'][@name=\"baseDN\"]/*[local-name()='value']/text()");
    }

    private String replaceAll(String source, String key, String value) {
        int startIndex = source.indexOf(key);
        int pos = 0;
        String replacedString = new String();
        while (startIndex != -1) {
            replacedString = replacedString.concat(source.substring(pos, startIndex));
            replacedString = replacedString.concat(value);
            pos = startIndex + key.length();
            startIndex = source.indexOf(key, pos);
        }
        if (pos < source.length()) {
            replacedString = replacedString.concat(source.substring(pos, source.length()));
        }
        return replacedString;
    }

    private String[] splitReplacingString(String replacingString) {
        String token = "\"";
        int pos = 0;
        String[] retval = new String[3];
        for (int i = 0; i < retval.length; ++i) {
            int startPos = replacingString.indexOf("\"", pos);
            int endPos = replacingString.indexOf("\"", startPos + 1);
            if (startPos == -1 || endPos == -1) {
                retval = null;
                break;
            }
            retval[i] = replacingString.substring(startPos + 1, endPos);
            pos = endPos + 1;
        }
        return retval;
    }

    private String substituteMappingIdentities(String mappingString, MessageContext theContext) {
        HashMap mappingIdentities = (HashMap)theContext.get((Object)"mappingIdentities");
        Set keySet = mappingIdentities.keySet();
        Iterator it = keySet.iterator();
        String retval = new String(mappingString);
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)mappingIdentities.get(key);
            retval = this.replaceAll(retval, key, value);
        }
        return retval;
    }
}

