/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashMap;

public class GetUserLogonInfo
extends DefaultHandler {
    private String userLookup;

    private boolean findCredentials(MessageContext theContext) throws SoapFaultException {
        theContext.put((Object)"mappingString", (Object)this.userLookup);
        String username = null;
        String passwd = null;
        try {
            Credential credential = (Credential)theContext.get((Object)"requestCredentials");
            if (credential != null) {
                username = credential.getCredentialValue("username");
                passwd = credential.getCredentialValue("password");
            } else {
                SoapEnvelope soapEnvelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
                if (soapEnvelope != null) {
                    BiBusHeader biBusHeader = soapEnvelope.getHeader().getBiBusHeader();
                    username = biBusHeader.getFormFieldValue("CAMUsername");
                    passwd = biBusHeader.getFormFieldValue("CAMPassword");
                }
            }
        }
        catch (LocalizableException e) {
            Message msg = new Message("AAA_CAP_INVALID_CREDENTIALS");
            throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), GetUserLogonInfo.class.toString(), null, "AAA_CAP_INVALID_CREDENTIALS", (LocalizableMessage)msg, (Throwable)e);
        }
        boolean retval = true;
        if (username != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("username", username);
            map.put("password", passwd);
            theContext.put((Object)"logonCredentials", map);
            if (this.userLookup.indexOf("${userID}") != -1) {
                HashMap<String, String> mappingIdentities = new HashMap<String, String>();
                mappingIdentities.put("${userID}", username);
                theContext.put((Object)"mappingIdentities", mappingIdentities);
            }
        } else {
            retval = false;
        }
        return retval;
    }

    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            return true;
        }
        boolean retval = true;
        retval = this.userLookup == null || this.userLookup.equals("") ? false : this.findCredentials(theContext);
        return retval;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration configMgr = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        this.userLookup = LdapUtil.getUserLookup(configMgr);
    }
}

