/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.exception.AuthenticationException;
import com.ibm.cognos.camaaa.internal.auth.exception.InvalidCredentialsException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapServerType;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import com.ibm.cognos.camaaa.internal.ldap.control.PasswordExpiredResponseControl;
import com.ibm.cognos.camaaa.internal.ldap.control.PasswordExpiringResponseControl;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;

abstract class LDAPConnectionHandler
extends DefaultHandler {
    private static final String ACTOR = LDAPConnectionHandler.class.toString();
    private int serverType;
    private NamespaceConfiguration namespaceConfiguration;

    LDAPConnectionHandler() {
    }

    private boolean checkActiveDirectoryADAM(Attributes attrs) throws NamingException {
        boolean adOrAdamServer = false;
        this.serverType = 1;
        Attribute schemaAttr = attrs.get("schemanamingcontext");
        if (schemaAttr != null) {
            String schemaNamingContextValue = (String)schemaAttr.get();
            if (schemaNamingContextValue != null && schemaNamingContextValue.contains("CN=Schema,CN=Configuration")) {
                this.checkADAM(attrs);
            }
            adOrAdamServer = true;
        }
        return adOrAdamServer;
    }

    private void checkADAM(Attributes attrs) throws NamingException {
        Attribute supportedCapabilitiesAttr = attrs.get("supportedCapabilities");
        NamingEnumeration<?> capabilitiesValues = supportedCapabilitiesAttr.getAll();
        while (capabilitiesValues.hasMore()) {
            String capabilityAttrValue = (String)capabilitiesValues.next();
            if (capabilityAttrValue == null || !capabilityAttrValue.startsWith("1.2.840.113556.1.4.1851")) continue;
            this.serverType = 4;
        }
    }

    private boolean checkNetscape(Attributes attrs) {
        boolean netscapeDirectoryServer = false;
        Attribute netscapeAttr = attrs.get("netscapemdsuffix");
        try {
            if (netscapeAttr != null && netscapeAttr.get() != null) {
                this.serverType = 2;
                netscapeDirectoryServer = true;
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return netscapeDirectoryServer;
    }

    private boolean checkTivioli(Attributes attrs) {
        boolean tivioliServer = false;
        Attribute vendorAttr = attrs.get("vendorname");
        if (vendorAttr != null) {
            try {
                String vendorName = (String)vendorAttr.get();
                if (vendorName.toUpperCase().contains("International Business Machines (IBM)")) {
                    this.serverType = 3;
                    tivioliServer = true;
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return tivioliServer;
    }

    private void checkOID(Attributes attrs) {
        int netscapeOIDs = 0;
        int microsoftOIDs = 0;
        int tivioliOIDs = 0;
        Attribute controlAttr = attrs.get("supportedcontrol");
        if (controlAttr != null) {
            try {
                NamingEnumeration<?> controlValues = controlAttr.getAll();
                while (controlValues.hasMore()) {
                    String controlValue = (String)controlValues.next();
                    if (controlValue != null && controlValue.contains("2.16.840.1.113730")) {
                        ++netscapeOIDs;
                        continue;
                    }
                    if (controlValue != null && controlValue.contains("1.2.840.113556")) {
                        ++microsoftOIDs;
                        continue;
                    }
                    if (controlValue == null || !controlValue.contains("1.3.18.0")) continue;
                    ++tivioliOIDs;
                }
                this.determineServerTypeUsingOIDs(netscapeOIDs, microsoftOIDs, tivioliOIDs);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    private void determineServerTypeUsingOIDs(int netscapeOIDs, int microsoftOIDs, int tivioliOIDs) {
        this.serverType = tivioliOIDs >= microsoftOIDs && tivioliOIDs >= netscapeOIDs ? 3 : (netscapeOIDs > microsoftOIDs ? 2 : 1);
    }

    protected NamespaceConfiguration getConfiguration() {
        return this.namespaceConfiguration;
    }

    protected LdapContext getContext() throws NamingException, LocalizableException {
        return this.getContext(this.namespaceConfiguration.getBindCredentialDn(), this.namespaceConfiguration.getBindCredentialPassword());
    }

    protected LdapContext getContext(String theBindDN, String theBindPassword) throws NamingException, LocalizableException {
        Control[] controls = new Control[]{new PasswordExpiredResponseControl(), new PasswordExpiringResponseControl()};
        return this.namespaceConfiguration.getContext(theBindDN, theBindPassword, controls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int determineServerType() throws NamingException, LocalizableException {
        this.serverType = 0;
        try (LdapContext rootDSEContext = null;){
            rootDSEContext = this.namespaceConfiguration.getRootDSEContext();
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(LdapServerType.SERVER_TYPE_ATTRIBUTES);
            ctls.setSearchScope(0);
            String rootDSE = "";
            NamingEnumeration<SearchResult> answer = rootDSEContext.search("", "(objectClass=*)", ctls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                if (this.checkNetscape(attrs)) {
                    break;
                }
                if (this.checkActiveDirectoryADAM(attrs)) {
                    break;
                }
                if (this.checkTivioli(attrs)) {
                    break;
                }
                this.checkOID(attrs);
            }
        }
        return this.serverType;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.namespaceConfiguration = (NamespaceConfiguration)theConfig.get((Object)NamespaceConfiguration.class.getName());
        this.logonUser(this.namespaceConfiguration.getBindCredentialDn(), this.namespaceConfiguration.getBindCredentialPassword());
        try {
            this.serverType = this.determineServerType();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public int getServertype() {
        return this.serverType;
    }

    protected LdapContext logonUser(String theBindDN, String theBindPassword) throws LocalizableException {
        return this.logonUser(theBindDN, theBindPassword, null);
    }

    protected LdapContext logonUser(String theBindDN, String theOldPassword, String theNewPassword) throws LocalizableException {
        LdapContext context = null;
        if (theBindDN != null) {
            try {
                this.validatePassword(theOldPassword);
                context = this.getContext(theBindDN, theOldPassword);
            }
            catch (NamingException e) {
                context = this.processLogonFailure(e, theNewPassword);
            }
        }
        return context;
    }

    protected LdapContext processLogonFailure(NamingException e, String theNewPassword) throws AuthenticationException {
        throw new InvalidCredentialsException(ACTOR, (Exception)e);
    }

    protected LdapContext processLogonSuccess(LdapContext theContext) {
        return theContext;
    }

    private void validatePassword(String theBindPassword) throws LocalizableException {
        if (!(theBindPassword != null && theBindPassword.length() != 0 || this.namespaceConfiguration.isEmptyPasswordAllowed())) {
            throw new InvalidCredentialsException(ACTOR);
        }
    }
}

