/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.exception.AuthenticationException;
import com.ibm.cognos.camaaa.internal.auth.exception.InvalidCredentialsException;
import com.ibm.cognos.camaaa.internal.auth.exception.PasswordExpiredException;
import com.ibm.cognos.camaaa.internal.ldap.auth.handler.LogonToGenericLDAPWithCredentials;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;

public class LogonToSunOneWithCredentials
extends LogonToGenericLDAPWithCredentials {
    private static final String ACTOR = LogonToSunOneWithCredentials.class.toString();

    private LdapContext changePassword(LdapContext theContext, String theNewPassword) throws AuthenticationException {
        throw new PasswordExpiredException(ACTOR);
    }

    private boolean isPasswordExpired(LdapContext theContext) throws NamingException {
        Control[] controls = theContext.getResponseControls();
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                if (!controls[i].getID().equals("2.16.840.1.113730.3.4.4")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected LdapContext processLogonFailure(NamingException e, String theNewPassword) throws AuthenticationException {
        Object obj = e.getResolvedObj();
        if (obj == null || !(obj instanceof LdapContext)) {
            throw new InvalidCredentialsException(ACTOR, (Exception)e);
        }
        LdapContext context = (LdapContext)obj;
        try {
            if (this.isPasswordExpired(context)) {
                if (theNewPassword != null) {
                    return this.changePassword(context, theNewPassword);
                }
                throw new PasswordExpiredException(ACTOR);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        throw new InvalidCredentialsException(ACTOR, (Exception)e);
    }
}

