/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.exception.InvalidCredentialsException;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public class PromptForCredentials
extends DefaultHandler {
    private boolean isUserLookupEmpty;
    private String nsDisplayName;
    private String nsId;

    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            return true;
        }
        String requestType = (String)theContext.get((Object)"requestType");
        if (requestType.equals("provider_logonTC") || requestType.equals("provider_logon") && this.isUserLookupEmpty) {
            throw new UnrecoverableException(PromptForCredentials.class.getName(), (LocalizableMessage)new Message("AAA_CAP_COULD_NOT_AUTHENTICATE_USER"), (LocalizableMessage)new Message("AAA_AUT_CREDENTIALS_INVALID"));
        }
        if (requestType.equals("provider_logon") && !this.isUserLookupEmpty) {
            throw new InvalidCredentialsException(PromptForCredentials.class.getName(), this.nsDisplayName, this.nsId, "logonAs");
        }
        return true;
    }

    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration configMgr = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        String userLookup = LdapUtil.getUserLookup(configMgr);
        this.isUserLookupEmpty = userLookup == null || userLookup.equals("");
        this.nsId = configMgr.getMandatoryValue("./*[local-name()='parameter'][@name=\"id\"]/*[local-name()='value']/text()");
        this.nsDisplayName = configMgr.getMandatoryValue("./@name");
    }
}

