/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.common;

import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.HeaderRequestConverter;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.ldap.admin.ObjectTypeDeterminer;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class NamespaceConfigurationImpl
implements NamespaceConfiguration {
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String OBJECTCLASS_FILTER = "(objectclass=";
    private static final String ID_ATTRIBUTE_PARM = NamespaceConfigurationImpl.getXpathForProperty("id");
    private static final String CAMID_ATTRIBUTE_PARM = NamespaceConfigurationImpl.getXpathForProperty("camidAttribute");
    private static final String REFERRAL_HOPS_PARM = NamespaceConfigurationImpl.getXpathForAdvancedProperty("referralHops");
    private static final String DEFAULT_REFERRAL_HOPS_VALUE = Integer.toString(0);
    private static final String CONNECTION_TIMEOUT_PARM = NamespaceConfigurationImpl.getXpathForAdvancedProperty("connectionTimeout");
    private static final String DEFAULT_CONNECTION_TIMEOUT_VALUE = "10000";
    private static final String ALLOW_EMPTY_PASSWORD_PARM = NamespaceConfigurationImpl.getXpathForProperty("allowEmptyPswd");
    private static final String DEFAULT_ALLOW_EMPTY_PASSWORD_VALUE = "false";
    private static final String BIND_CREDENTIAL_USERNAME_PARM = NamespaceConfigurationImpl.getXpathForBindCredentialProperty("username");
    private static final String BIND_CREDENTIAL_PASSWORD_PARM = NamespaceConfigurationImpl.getXpathForBindCredentialProperty("password");
    private static final String SSL_CERT_DB_PARM = NamespaceConfigurationImpl.getXpathForProperty("sslCertificateDatabase");
    private static final String CONNECTION_PARM = NamespaceConfigurationImpl.getXpathForProperty("connection");
    private static final String BASEDN_PARM = NamespaceConfigurationImpl.getXpathForProperty("baseDN");
    private static final String SEARCH_SIZE_LIMIT_PARM = NamespaceConfigurationImpl.getXpathForProperty("sizeLimit");
    private static final String DEFAULT_SEARCH_SIZE_LIMIT_VALUE = Integer.toString(0);
    private static final String SEARCH_TIME_LIMIT_PARM = NamespaceConfigurationImpl.getXpathForProperty("timeOut");
    private static final String DEFAULT_SEARCH_TIME_LIMIT_VALUE = Integer.toString(0);
    private static final String ACCOUNT_PARAMETERS_PARM = "./*[local-name()='parameter'][@name=\"customProperties\"]/*[local-name()='value']";
    private static final String ACCOUNT_OBJ_CLASS = "accountObjectClass";
    private static boolean hasReadCredential;
    private final Configuration configuration;
    private final Map objectPropertyMappings;
    private final Map objectFilters;
    private final Map objectClasses;
    private final Map accountParameters;
    private final ObjectTypeDeterminer objectTypeDeterminer;
    private String bindCredentialUsername;
    private String bindCredentialPassword;

    public NamespaceConfigurationImpl(Configuration theConfiguration) throws LocalizableException {
        this.configuration = theConfiguration;
        this.objectPropertyMappings = new HashMap();
        this.accountParameters = new HashMap();
        this.objectFilters = new HashMap();
        this.objectClasses = new HashMap();
        this.loadObjectclasses();
        this.convertObjectclassesToArray();
        this.loadObjectClassFilters();
        this.loadAccountMappings();
        this.loadDistributionListMappings();
        this.loadGroupMappings();
        this.loadNamespaceFolderMappings();
        this.objectTypeDeterminer = new ObjectTypeDeterminer(this.getObjectClasses("account"), this.getObjectClasses("group"), this.getObjectClasses("namespaceFolder"), this.getObjectClasses("distributionList"));
        hasReadCredential = false;
    }

    private static void addDefaultProperties(Map theMapping) {
        if (theMapping.containsKey("description")) {
            theMapping.put("defaultDescription", theMapping.get("description"));
        }
        if (theMapping.containsKey("name")) {
            theMapping.put("defaultName", theMapping.get("name"));
        }
    }

    private static String getXpathForAdvancedProperty(String thePropertyName) {
        return NamespaceConfigurationImpl.getXpathForPropertyFrom("./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']", thePropertyName);
    }

    private static String getXpathForBindCredentialProperty(String thePropertyName) {
        return "./*[local-name()='parameter'][@name=\"bindCredentials\"]/*[local-name()='value']/*[local-name()='credential']/*[local-name()='" + thePropertyName + "']/text()";
    }

    private static String getXpathForProperty(String thePropertyName) {
        return NamespaceConfigurationImpl.getXpathForPropertyFrom(".", thePropertyName);
    }

    private static String getXpathForPropertyFrom(String theStartingPoint, String thePropertyName) {
        return theStartingPoint + "/*[local-name()='parameter'][@name=\"" + thePropertyName + "\"]/*[local-name()='value']/text()";
    }

    private void addMandatoryPropertyMapping(Map thePropertyMapping, String theConfigPropName, String thePropertyName) throws LocalizableException {
        String ldapAttributeName = this.getMandatoryValue(theConfigPropName);
        this.addPropertyAttributeMapping(thePropertyMapping, thePropertyName, ldapAttributeName);
    }

    private void addPropertyAttributeMapping(Map thePropertyMapping, String thePropertyName, String ldapAttributeName) {
        if (ldapAttributeName != null) {
            ArrayList<String> value = (ArrayList<String>)thePropertyMapping.get(thePropertyName);
            if (value == null) {
                value = new ArrayList<String>();
            }
            value.add(ldapAttributeName);
            thePropertyMapping.put(thePropertyName, ldapAttributeName);
        }
    }

    private void addPropertyMapping(Map thePropertyMapping, String theConfigPropName, String thePropertyName) {
        String ldapAttributeName = this.getOptionalValue(theConfigPropName);
        this.addPropertyAttributeMapping(thePropertyMapping, thePropertyName, ldapAttributeName);
    }

    private void convertObjectclassesToArray() {
        this.convertObjectclassToListForObject("account");
        this.convertObjectclassToListForObject("distributionList");
        this.convertObjectclassToListForObject("group");
        this.convertObjectclassToListForObject("namespaceFolder");
    }

    private void convertObjectclassToListForObject(String objectType) {
        String objectclassAttributes = (String)this.objectClasses.get(objectType);
        if (objectclassAttributes != null && objectclassAttributes.length() > 0) {
            String[] objectclassArray = objectclassAttributes.split(",");
            this.objectClasses.put(objectType, objectclassArray);
        }
    }

    @Override
    public Map getAccountParameters() {
        return this.accountParameters;
    }

    @Override
    public String getBaseDN() throws LocalizableException {
        return this.configuration.getMandatoryValue(BASEDN_PARM);
    }

    private void getBindCredential() throws LocalizableException {
        String encryptedValue = this.configuration.getOptionalValue("./*[local-name()='parameter'][@name=\"bindCredentials\"]/*[local-name()='value'][@encrypted=\"true\"]/text()", null);
        String bindCredentialValue = null;
        if (encryptedValue != null) {
            byte[] decodedValue = base64.decode((int)0, (String)encryptedValue);
            try {
                bindCredentialValue = HeaderRequestConverter.decryptData((byte[])decodedValue);
                SAXReader reader = null;
                reader = new SAXReader();
                try {
                    Document doc = reader.read((Reader)new StringReader(bindCredentialValue));
                    CredentialImpl bindCredential = new CredentialImpl(doc.getRootElement());
                    this.bindCredentialUsername = bindCredential.getCredentialValue(USERNAME_PROPERTY);
                    this.bindCredentialPassword = bindCredential.getCredentialValue(PASSWORD_PROPERTY);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
            }
            catch (FunctionCallFailedException e) {
                e.printStackTrace();
            }
        } else {
            this.bindCredentialUsername = this.configuration.getOptionalValue(BIND_CREDENTIAL_USERNAME_PARM, null);
            this.bindCredentialPassword = this.configuration.getOptionalValue(BIND_CREDENTIAL_PASSWORD_PARM, null);
            hasReadCredential = true;
        }
    }

    @Override
    public String getBindCredentialDn() throws LocalizableException {
        if (!hasReadCredential) {
            this.getBindCredential();
            hasReadCredential = true;
        }
        return this.bindCredentialUsername;
    }

    @Override
    public String getBindCredentialPassword() throws LocalizableException {
        if (!hasReadCredential) {
            this.getBindCredential();
            hasReadCredential = true;
        }
        return this.bindCredentialPassword;
    }

    @Override
    public String getCAMIDAttribute() {
        return this.configuration.getOptionalValue(CAMID_ATTRIBUTE_PARM, "dn");
    }

    private Properties getRootDSEConnectionProperties() throws LocalizableException {
        Properties properties = this.getConnectionProperties();
        properties.put("java.naming.provider.url", this.getServerRootDSEUrl());
        return properties;
    }

    private Properties getConnectionProperties() throws LocalizableException {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.referral", "ignore");
        properties.put("java.naming.provider.url", this.getServerBaseDNUrls());
        String value = this.getReferralHops().toString();
        properties.put("java.naming.ldap.referral.limit", value);
        properties.put("java.naming.ldap.derefAliases", "always");
        properties.put("java.naming.ldap.version", "3");
        value = this.getConnectionTimeout().toString();
        properties.put("com.sun.jndi.ldap.connect.timeout", value);
        properties.put("com.sun.jndi.ldap.connect.pool", "true");
        return properties;
    }

    @Override
    public Integer getConnectionTimeout() {
        return Integer.valueOf(this.configuration.getOptionalValue(CONNECTION_TIMEOUT_PARM, DEFAULT_CONNECTION_TIMEOUT_VALUE));
    }

    @Override
    public LdapContext getContext(Control[] controls) throws NamingException, LocalizableException {
        return this.getContext(this.getBindCredentialDn(), this.getBindCredentialPassword(), controls);
    }

    @Override
    public LdapContext getContext(String theBindDN, String theBindPassword, Control[] controls) throws NamingException, LocalizableException {
        Properties properties = this.getConnectionProperties();
        this.setSecurityAuthenticationProperties(theBindDN, theBindPassword, properties);
        return new InitialLdapContext(properties, controls);
    }

    @Override
    public LdapContext getRootDSEContext() throws NamingException, LocalizableException {
        Properties properties = this.getRootDSEConnectionProperties();
        this.setSecurityAuthenticationProperties(this.getBindCredentialDn(), this.getBindCredentialPassword(), properties);
        return new InitialLdapContext(properties, null);
    }

    private void setSecurityAuthenticationProperties(String theBindDN, String theBindPassword, Properties properties) throws LocalizableException {
        if (theBindDN == null || theBindPassword == null || theBindDN.length() == 0) {
            properties.put("java.naming.security.authentication", "none");
        } else {
            if (theBindPassword.length() == 0 && !this.isEmptyPasswordAllowed()) {
                throw new LocalizableException((LocalizableMessage)new Message("AAA_CAP_EMPTY_PWD_NOT_ALLOWED"));
            }
            properties.put("java.naming.security.authentication", "simple");
            properties.put("java.naming.security.principal", theBindDN);
            properties.put("java.naming.security.credentials", theBindPassword);
        }
    }

    @Override
    public String getID() throws LocalizableException {
        return this.configuration.getMandatoryValue(ID_ATTRIBUTE_PARM);
    }

    private String getMandatoryValue(String thePropertyName) throws LocalizableException {
        return this.configuration.getMandatoryValue(NamespaceConfigurationImpl.getXpathForProperty(thePropertyName));
    }

    @Override
    public String[] getObjectClasses(String theObjectType) {
        return (String[])this.objectClasses.get(theObjectType);
    }

    private String getObjectClassesAsFilter(String[] theObjectClasses) {
        StringBuffer theObjectClassesAsFilter = new StringBuffer();
        if (theObjectClasses.length > 1) {
            theObjectClassesAsFilter.append("(|");
        }
        for (int i = 0; i < theObjectClasses.length; ++i) {
            theObjectClassesAsFilter.append(OBJECTCLASS_FILTER);
            theObjectClassesAsFilter.append(theObjectClasses[i]);
            theObjectClassesAsFilter.append(")");
        }
        if (theObjectClasses.length > 1) {
            theObjectClassesAsFilter.append(")");
        }
        return theObjectClassesAsFilter.toString();
    }

    @Override
    public String getObjectClassFilter(String theObjectType) {
        String theObjectClassFilter = null;
        String[] theObjectClasses = (String[])this.objectClasses.get(theObjectType);
        String theObjectfilters = (String)this.objectFilters.get(theObjectType);
        if (theObjectClasses != null) {
            String theObjectClassesAsFilter = this.getObjectClassesAsFilter(theObjectClasses);
            theObjectClassFilter = theObjectfilters != null ? "(&" + theObjectClassesAsFilter + theObjectfilters + ")" : theObjectClassesAsFilter;
        }
        return theObjectClassFilter;
    }

    @Override
    public Map getObjectPropertyMappings(String theObjectType) {
        return (Map)this.objectPropertyMappings.get(theObjectType);
    }

    @Override
    public ObjectTypeDeterminer getObjectTypeDeterminer() {
        return this.objectTypeDeterminer;
    }

    private String getOptionalValue(String thePropertyName) {
        return this.configuration.getOptionalValue(NamespaceConfigurationImpl.getXpathForProperty(thePropertyName), null);
    }

    @Override
    public Integer getReferralHops() {
        return Integer.valueOf(this.configuration.getOptionalValue(REFERRAL_HOPS_PARM, DEFAULT_REFERRAL_HOPS_VALUE));
    }

    @Override
    public Integer getSearchSizeLimit() {
        return Integer.valueOf(this.configuration.getOptionalValue(SEARCH_SIZE_LIMIT_PARM, DEFAULT_SEARCH_SIZE_LIMIT_VALUE));
    }

    @Override
    public Integer getSearchTimeLimit() {
        return Integer.valueOf(this.configuration.getOptionalValue(SEARCH_TIME_LIMIT_PARM, DEFAULT_SEARCH_TIME_LIMIT_VALUE));
    }

    @Override
    public String getServerBaseDNUrls() throws LocalizableException {
        StringBuffer serverURL = new StringBuffer();
        serverURL.append(this.getServerRootDSEUrl());
        serverURL.append("/");
        String baseDN = this.configuration.getMandatoryValue(BASEDN_PARM);
        serverURL.append(baseDN);
        return serverURL.toString();
    }

    @Override
    public String getServerRootDSEUrl() throws LocalizableException {
        StringBuffer serverURL = new StringBuffer();
        if (this.isSslEnabled()) {
            serverURL.append("ldaps://");
        } else {
            serverURL.append("ldap://");
        }
        String connection = this.configuration.getMandatoryValue(CONNECTION_PARM);
        serverURL.append(connection);
        return serverURL.toString();
    }

    @Override
    public boolean isEmptyPasswordAllowed() throws LocalizableException {
        return Boolean.valueOf(this.configuration.getOptionalValue(ALLOW_EMPTY_PASSWORD_PARM, DEFAULT_ALLOW_EMPTY_PASSWORD_VALUE));
    }

    @Override
    public boolean isSslEnabled() {
        String sslCertDB = this.configuration.getOptionalValue(SSL_CERT_DB_PARM, null);
        return sslCertDB != null && sslCertDB.length() > 0;
    }

    private void loadAccountMappings() throws LocalizableException {
        if (this.objectClasses.containsKey("account")) {
            HashMap mapping = new HashMap();
            this.addMandatoryPropertyMapping(mapping, "accountName", "name");
            this.addPropertyMapping(mapping, "accountBusinessPhone", "businessPhone");
            this.addPropertyMapping(mapping, "accountContentLocale", "contentLocale");
            this.addPropertyMapping(mapping, "accountDescription", "description");
            this.addPropertyMapping(mapping, "accountEmail", "email");
            this.addPropertyMapping(mapping, "accountFaxPhone", "faxPhone");
            this.addPropertyMapping(mapping, "accountGivenName", "givenName");
            this.addPropertyMapping(mapping, "accountHomePhone", "homePhone");
            this.addPropertyMapping(mapping, "accountMobilePhone", "mobilePhone");
            this.addPropertyMapping(mapping, "accountPagerPhone", "pagerPhone");
            this.addPropertyMapping(mapping, "accountPassword", PASSWORD_PROPERTY);
            this.addPropertyMapping(mapping, "accountPostalAddress", "postalAddress");
            this.addPropertyMapping(mapping, "accountProductLocale", "productLocale");
            this.addPropertyMapping(mapping, "accountSurname", "surname");
            this.addPropertyMapping(mapping, "accountUserName", "userName");
            NamespaceConfigurationImpl.addDefaultProperties(mapping);
            this.objectPropertyMappings.put("account", mapping);
            String[] names = this.configuration.getOptionalValues("./*[local-name()='parameter'][@name=\"customProperties\"]/*[local-name()='value']/*[local-name()='parameter']/@name", null);
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String key = NamespaceConfigurationImpl.getXpathForPropertyFrom(ACCOUNT_PARAMETERS_PARM, names[i]);
                    String value = this.configuration.getOptionalValue(key.toString(), null);
                    this.accountParameters.put(names[i], value);
                }
            }
        }
    }

    private void loadConfigItemForObject(Map theContainer, String configurationItem, String key) throws LocalizableException {
        String ldapAttribute = configurationItem == ACCOUNT_OBJ_CLASS ? this.getMandatoryValue(configurationItem) : this.getOptionalValue(configurationItem);
        if (ldapAttribute != null && ldapAttribute.length() > 0) {
            theContainer.put(key, ldapAttribute);
        }
    }

    private void loadDistributionListMappings() throws LocalizableException {
        if (this.objectClasses.containsKey("distributionList")) {
            HashMap mapping = new HashMap();
            this.addPropertyMapping(mapping, "distributionListDescription", "description");
            this.addMandatoryPropertyMapping(mapping, "distributionListMembers", "members");
            this.addMandatoryPropertyMapping(mapping, "distributionListName", "name");
            NamespaceConfigurationImpl.addDefaultProperties(mapping);
            this.objectPropertyMappings.put("distributionList", mapping);
        }
    }

    private void loadGroupMappings() throws LocalizableException {
        if (this.objectClasses.containsKey("group")) {
            HashMap mapping = new HashMap();
            this.addPropertyMapping(mapping, "groupDescription", "description");
            this.addMandatoryPropertyMapping(mapping, "groupMembers", "members");
            this.addMandatoryPropertyMapping(mapping, "groupName", "name");
            this.objectPropertyMappings.put("group", mapping);
            NamespaceConfigurationImpl.addDefaultProperties(mapping);
        }
    }

    private void loadNamespaceFolderMappings() throws LocalizableException {
        if (this.objectClasses.containsKey("namespaceFolder")) {
            HashMap mapping = new HashMap();
            this.addPropertyMapping(mapping, "folderDescription", "description");
            this.addMandatoryPropertyMapping(mapping, "folderName", "name");
            NamespaceConfigurationImpl.addDefaultProperties(mapping);
            this.objectPropertyMappings.put("namespaceFolder", mapping);
        }
    }

    private void loadObjectclasses() throws LocalizableException {
        this.objectClasses.clear();
        this.loadConfigItemForObject(this.objectClasses, ACCOUNT_OBJ_CLASS, "account");
        this.loadConfigItemForObject(this.objectClasses, "distributionListObjectClass", "distributionList");
        this.loadConfigItemForObject(this.objectClasses, "groupObjectClass", "group");
        this.loadConfigItemForObject(this.objectClasses, "folderObjectClass", "namespaceFolder");
    }

    private void loadObjectClassFilters() throws LocalizableException {
        this.objectFilters.clear();
        this.loadConfigItemForObject(this.objectFilters, "accountFilter", "account");
        this.loadConfigItemForObject(this.objectFilters, "folderFilter", "namespaceFolder");
        this.loadConfigItemForObject(this.objectFilters, "groupFilter", "group");
        this.loadConfigItemForObject(this.objectFilters, "distributionListFilter", "distributionList");
    }
}

