/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.exception;

import com.ibm.cognos.camaaa.internal.auth.exception.SelectOption;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import java.util.Locale;

public abstract class DisplayObject {
    public static final String TEXT = "text";
    public static final String TEXTNOECHO = "textnoecho";
    public static final String VERIFYTEXTNOECHO = "verifytextnoecho";
    public static final String SINGLESELECT = "singleselect";
    public static final String MULTISELECT = "multiselect";
    public static final String HIDDEN = "hidden";
    public static final String DISPLAY = "display";
    public static final String REDIRECT = "redirect";
    private final String name;
    private String value;
    private LocalizableMessage caption;
    private final String type;

    public DisplayObject(String theType, String theName) {
        this.type = theType;
        this.name = theName;
        this.caption = null;
        this.value = null;
    }

    public DisplayObject(String theType, String theName, LocalizableMessage theCaption) {
        this(theType, theName);
        this.caption = theCaption;
    }

    public DisplayObject(String theType, String theName, LocalizableMessage theCaption, String theValue) {
        this(theType, theName, theCaption);
        this.value = theValue;
    }

    private boolean areCaptionsEqual(DisplayObject other) {
        boolean areEqual = false;
        if (this.caption == null && other.caption == null) {
            areEqual = true;
        } else if (this.caption != null && other.caption != null) {
            areEqual = this.caption.equals(other.caption);
        }
        return areEqual;
    }

    private boolean areValuesEqual(DisplayObject other) {
        boolean areEqual = false;
        if (this.value == null && other.value == null) {
            areEqual = true;
        } else if (this.value != null && other.value != null) {
            areEqual = this.value.equals(other.value);
        }
        return areEqual;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        DisplayObject other = (DisplayObject)otherObject;
        return this.name.equals(other.name) && this.type.equals(other.type) && this.areValuesEqual(other) && this.areCaptionsEqual(other);
    }

    public String getCaption(Locale theLocale) {
        if (this.caption == null) {
            return null;
        }
        return this.caption.getLocalizedMessage(theLocale);
    }

    public String getName() {
        return this.name;
    }

    public SelectOption[] getOptions() {
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int theHashCode = 0;
        if (this.value != null) {
            theHashCode += this.value.hashCode();
        }
        if (this.caption != null) {
            theHashCode += this.caption.hashCode();
        }
        if (this.name != null) {
            theHashCode += this.name.hashCode();
        }
        if (this.type != null) {
            theHashCode += this.type.hashCode();
        }
        return theHashCode;
    }

    public void setValue(String theValue) {
        this.value = theValue;
    }
}

