/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.exception;

import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizedMessage;
import java.util.ArrayList;
import java.util.Locale;

public class LocalizableException
extends Exception {
    private static final long serialVersionUID = -3371645834717908397L;
    private final LocalizableMessage message;

    public LocalizableException(LocalizableMessage theErrorDetail) {
        super(theErrorDetail == null ? null : theErrorDetail.getLocalizedMessage(Locale.getDefault()));
        this.message = theErrorDetail;
    }

    public LocalizableException(LocalizableMessage theErrorDetail, Throwable theCause) {
        super(theErrorDetail == null ? null : theErrorDetail.getLocalizedMessage(Locale.getDefault()), theCause);
        this.message = theErrorDetail;
    }

    public LocalizableMessage getLocalizableMessage() {
        return this.message;
    }

    public LocalizableMessage[] getLocalizableMessageStack() {
        ArrayList<LocalizableMessage> list = new ArrayList<LocalizableMessage>();
        for (Throwable t = this; t != null; t = t.getCause()) {
            LocalizableMessage msg = null;
            if (t instanceof LocalizableException) {
                LocalizableException e = t;
                msg = e.getLocalizableMessage();
            } else {
                msg = new LocalizedMessage(t.toString());
            }
            if (msg == null) continue;
            list.add(msg);
        }
        return list.toArray(new LocalizableMessage[list.size()]);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.message != null) {
            return this.message.getLocalizedMessage(Locale.getDefault());
        }
        return super.getLocalizedMessage();
    }
}

