/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.messages;

import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundleMessage
implements LocalizableMessage {
    private final String bundleName;
    private final String messageID;
    private Object[] parameters;

    public ResourceBundleMessage(String theBundleName, String theMessageID) {
        this.bundleName = theBundleName;
        this.messageID = theMessageID;
        this.parameters = null;
        ResourceBundle.getBundle(this.bundleName);
    }

    public ResourceBundleMessage(String theBundleName, String theMessageID, Object[] theParameters) {
        this(theBundleName, theMessageID);
        this.parameters = theParameters;
    }

    private boolean areParametersEqual(ResourceBundleMessage other) {
        boolean areEqual = false;
        if (this.parameters == null && other.parameters == null) {
            areEqual = true;
        } else if (this.parameters != null && other.parameters != null) {
            if (this.parameters.length == other.parameters.length) {
                areEqual = true;
            }
            for (int i = 0; i < this.parameters.length && areEqual; ++i) {
                areEqual = areEqual && this.parameters[i].equals(other.parameters[i]);
            }
        }
        return areEqual;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ResourceBundleMessage other = (ResourceBundleMessage)otherObject;
        return this.bundleName.equals(other.bundleName) && this.messageID.equals(other.messageID) && this.areParametersEqual(other);
    }

    @Override
    public String getLocalizedMessage(Locale theLocale) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.bundleName, theLocale);
        return MessageFormat.format(bundle.getString(this.messageID), this.parameters);
    }

    public int hashCode() {
        int theHashCode = 0;
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                theHashCode += this.parameters[i].hashCode();
            }
        }
        return this.bundleName.hashCode() + this.messageID.hashCode() + theHashCode;
    }
}

