/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.cognosns;

import com.ibm.cognos.camaaa.internal.admin.cognosns.MembershipCache;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.AccountImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.GroupImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.NamespaceImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResultImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.RoleImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.UiClassImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessorHTTP;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class CognosNSCache {
    private static final String[] ANONYMOUS_PROPERTIES = new String[]{"searchPath", "name", "userName", "ancestors"};
    private static final String[] COGNOS_NS_PROPERTIES = new String[]{"searchPath", "members", "objectClass", "tenantID"};
    private static final String[] COGNOS_NS_REFPROPS = new String[]{"searchPath", "objectClass", "tenantID"};
    private static final String QUERY_RESPONSE = "./*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']";
    private static final XPath QUERY_RESPONSE_ITEMS_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']");
    private static final XPath MEMBERS_VALUE_ITEM_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='members']/*[local-name()='value']/*[local-name()='item']");
    private static final XPath SEARCHPATH_VALUE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='searchPath']/*[local-name()='value']");
    private static final XPath SEARCHPATH_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='searchPath']");
    private static final XPath OBJECTCLASS_VALUE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='objectClass']/*[local-name()='value']");
    private static final XPath OBJECTCLASS_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='objectClass']");
    private static final XPath TENANTID_VALUE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='tenantID']/*[local-name()='value']");
    private static final XPath NAME_VALUE_ITEM_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='name']/*[local-name()='value']/*[local-name()='item']");
    private static final XPath USERNAME_VALUE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='userName']/*[local-name()='value']");
    private static final XPath ANCESTORS_VALUE_ITEM_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='ancestors']/*[local-name()='value']/*[local-name()='item']");
    private static final XPath TITLE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='title']");
    private static final XPath LOCALE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='locale']");
    private static final XPath VALUE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='value']");
    private static CognosNSCache instance;
    private String intDispURL;
    private boolean cacheLoaded = false;
    private final MembershipCache membershipCache = new MembershipCache();
    private CMAccessorHTTP cmAccessor;
    private QueryResultImpl queryResponse;
    private boolean cmIsDisabled;

    protected CognosNSCache() {
    }

    public static synchronized void destroyInstance() {
        if (instance != null) {
            instance = null;
        }
    }

    public static synchronized CognosNSCache getInstance() {
        if (instance == null) {
            instance = new CognosNSCache();
        }
        return instance;
    }

    private void addMembersToCache(BaseClass cognosNSObject, String cognosNSObjectTenantID, List<Element> objectMembers) {
        for (Element aMember : objectMembers) {
            String memberSearchPath = DocumentHelper.valueOf((XPath)SEARCHPATH_VALUE_XPATH, (Node)aMember);
            String memberObjectClass = DocumentHelper.valueOf((XPath)OBJECTCLASS_VALUE_XPATH, (Node)aMember);
            String memberTenantID = DocumentHelper.valueOf((XPath)TENANTID_VALUE_XPATH, (Node)aMember);
            if (memberTenantID == null) {
                memberTenantID = "";
            }
            this.membershipCache.addMember(cognosNSObject, cognosNSObjectTenantID, this.getBaseClassObject(memberSearchPath, memberObjectClass), memberTenantID);
        }
    }

    public QueryResult getAnonymousUser() throws SoapFaultException {
        this.loadCache();
        return this.queryResponse;
    }

    private Document getAnonymousUserFromCM() throws SoapFaultException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" ");
        buffer.append("xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ");
        buffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">");
        buffer.append("<SOAP-ENV:Header><bus:biBusHeader xsi:type=\"bus:biBusHeader\"><CAM xsi:type=\"bus:CAM\"/>");
        buffer.append("</bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body><bus:query>");
        buffer.append("<bus:requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:queryRequest[]\">");
        buffer.append("<item><search xsi:type=\"xsd:string\">CAMID(\"::Anonymous\")</search>");
        buffer.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[" + ANONYMOUS_PROPERTIES.length + "]\">");
        for (int i = 0; i < ANONYMOUS_PROPERTIES.length; ++i) {
            buffer.append("<item xsi:type=\"cm:propEnum\">");
            buffer.append(ANONYMOUS_PROPERTIES[i]);
            buffer.append("</item>");
        }
        buffer.append("</properties></item></bus:requests></bus:query>");
        buffer.append("</SOAP-ENV:Body></SOAP-ENV:Envelope>");
        if (this.cmAccessor != null) {
            Document response = this.cmAccessor.invokeDoc(buffer.toString());
            return response;
        }
        return null;
    }

    private BaseClass getBaseClassObject(String cognosNSObjectSearchPath, String cognosNSObjectClass) {
        UiClassImpl baseClassObject = null;
        SearchPathImpl searchPath = new SearchPathImpl(cognosNSObjectSearchPath);
        if (cognosNSObjectClass.equals("group")) {
            baseClassObject = new GroupImpl(searchPath);
        } else if (cognosNSObjectClass.equals("role")) {
            baseClassObject = new RoleImpl(searchPath);
        } else if (cognosNSObjectClass.equals("account")) {
            baseClassObject = new AccountImpl(searchPath);
        } else if (cognosNSObjectClass.equals("namespace")) {
            baseClassObject = new NamespaceImpl(searchPath);
        }
        return baseClassObject;
    }

    private void getCMAccessor() throws LocalizableException {
        if (this.cmAccessor == null && this.intDispURL != null) {
            URL theIntDispURL = null;
            try {
                theIntDispURL = new URL(this.intDispURL);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            this.cmAccessor = new CMAccessorHTTP(theIntDispURL, "CAMSASVC");
        }
    }

    private Document getCognosNSFromCM() throws SoapFaultException {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" ");
        buffer.append("xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ");
        buffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">");
        buffer.append("<SOAP-ENV:Header><bus:biBusHeader xsi:type=\"bus:biBusHeader\"><CAM xsi:type=\"bus:CAM\"/>");
        buffer.append("</bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body>");
        buffer.append("<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" ");
        buffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" ");
        buffer.append("xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        buffer.append("<search xsi:type=\"xsd:string\">camInternal(\"/directory/*[@defaultName='Cognos']//*\")</search>");
        buffer.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[" + COGNOS_NS_PROPERTIES.length + "]\">");
        for (i = 0; i < COGNOS_NS_PROPERTIES.length; ++i) {
            buffer.append("<item xsi:type=\"cm:propEnum\">");
            buffer.append(COGNOS_NS_PROPERTIES[i]);
            buffer.append("</item>");
        }
        buffer.append("</properties>");
        buffer.append("<options xsi:type=\"cm:queryOptions\">");
        buffer.append("<refProps xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:refProp[1]\">");
        buffer.append("<item xsi:type=\"cm:refProp\">");
        buffer.append("<refPropName xsi:type=\"cm:propEnum\">members</refPropName>");
        buffer.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[" + COGNOS_NS_REFPROPS.length + "]\">");
        for (i = 0; i < COGNOS_NS_REFPROPS.length; ++i) {
            buffer.append("<item xsi:type=\"cm:propEnum\">");
            buffer.append(COGNOS_NS_REFPROPS[i]);
            buffer.append("</item>");
        }
        buffer.append("</properties></item></refProps></options></cm:query></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        if (this.cmAccessor != null) {
            Document response = this.cmAccessor.invokeDoc(buffer.toString());
            return response;
        }
        return null;
    }

    public LinkedHashSet<BaseClass> getMembership(BaseClass theCamId, String tenantID) throws SoapFaultException {
        this.loadCache();
        return this.membershipCache.getCompleteMembershipOf(theCamId, tenantID);
    }

    public void initialize(String theIntDispURL, boolean disableCM) throws LocalizableException {
        this.intDispURL = theIntDispURL;
        this.cmIsDisabled = disableCM;
    }

    private void loadAnonymousUser(Document response) {
        if (response != null) {
            Element responseItem = DocumentHelper.selectSingleElement((XPath)QUERY_RESPONSE_ITEMS_XPATH, (Node)response);
            String searchPath = DocumentHelper.valueOf((XPath)SEARCHPATH_VALUE_XPATH, (Node)responseItem);
            if (this.queryResponse == null && searchPath != null) {
                this.queryResponse = new QueryResultImpl();
                AccountImpl anonymousAccount = new AccountImpl(new SearchPathImpl(searchPath));
                this.queryResponse.add(anonymousAccount);
                this.setAnonymousNames(responseItem, anonymousAccount);
                this.setAnonymousUserName(responseItem, anonymousAccount);
                this.setAnonymousAncestors(responseItem, anonymousAccount);
            }
        }
    }

    private void loadCache() throws SoapFaultException {
        if (!this.cmIsDisabled && !this.cacheLoaded) {
            try {
                this.getCMAccessor();
            }
            catch (LocalizableException e) {
                throw new InternalErrorException(CognosNSCache.class.toString(), (Exception)((Object)e));
            }
            Document response = this.getCognosNSFromCM();
            this.loadMembershipCache(response);
            response = this.getAnonymousUserFromCM();
            this.loadAnonymousUser(response);
            this.cacheLoaded = true;
        }
    }

    private void loadMembershipCache(Document response) {
        if (response != null) {
            List cognosObjects = DocumentHelper.selectElements((XPath)QUERY_RESPONSE_ITEMS_XPATH, (Node)response);
            Iterator aCognosNSObject = cognosObjects.iterator();
            while (aCognosNSObject.hasNext()) {
                this.processCognosNSObject((Element)aCognosNSObject.next());
            }
        }
    }

    private void processCognosNSObject(Element aCognosNSObject) {
        List objectMembers = DocumentHelper.selectElements((XPath)MEMBERS_VALUE_ITEM_XPATH, (Node)aCognosNSObject);
        if (objectMembers != null) {
            String cognosNSObjectSearchPath = DocumentHelper.valueOf((XPath)SEARCHPATH_VALUE_XPATH, (Node)aCognosNSObject);
            String cognosNSObjectClass = DocumentHelper.valueOf((XPath)OBJECTCLASS_VALUE_XPATH, (Node)aCognosNSObject);
            String cognosNSObjectTenantID = DocumentHelper.valueOf((XPath)TENANTID_VALUE_XPATH, (Node)aCognosNSObject);
            if (cognosNSObjectTenantID == null) {
                cognosNSObjectTenantID = "";
            }
            this.addMembersToCache(this.getBaseClassObject(cognosNSObjectSearchPath, cognosNSObjectClass), cognosNSObjectTenantID, objectMembers);
        }
    }

    private void setAnonymousAncestors(Element responseItem, Account anonymousAccount) {
        List ancestors = DocumentHelper.selectElements((XPath)ANCESTORS_VALUE_ITEM_XPATH, (Node)responseItem);
        if (ancestors != null) {
            for (Element anAncestor : ancestors) {
                String objectclass = DocumentHelper.valueOf((XPath)OBJECTCLASS_XPATH, (Node)anAncestor);
                if (objectclass.equals("directory")) continue;
                String theSearchPath = DocumentHelper.valueOf((XPath)SEARCHPATH_XPATH, (Node)anAncestor);
                NamespaceImpl theNamespace = new NamespaceImpl(new SearchPathImpl(theSearchPath));
                String theTitle = DocumentHelper.valueOf((XPath)TITLE_XPATH, (Node)anAncestor);
                theNamespace.addName(Locale.ENGLISH, theTitle);
                BaseClass[] theAncestors = new BaseClass[]{theNamespace};
                anonymousAccount.setAncestors(theAncestors);
            }
        }
    }

    private void setAnonymousNames(Element responseItem, Account anonymousAccount) {
        List names = DocumentHelper.selectElements((XPath)NAME_VALUE_ITEM_XPATH, (Node)responseItem);
        for (Element aName : names) {
            String locale = DocumentHelper.valueOf((XPath)LOCALE_XPATH, (Node)aName);
            String theName = DocumentHelper.valueOf((XPath)VALUE_XPATH, (Node)aName);
            if (locale == null || locale.length() <= 0 || theName == null || theName.length() <= 0) continue;
            anonymousAccount.addName(new Locale(locale), theName);
        }
    }

    private void setAnonymousUserName(Element responseItem, Account anonymousAccount) {
        String userName = DocumentHelper.valueOf((XPath)USERNAME_VALUE_XPATH, (Node)responseItem);
        if (userName != null) {
            anonymousAccount.setUserName(userName);
        }
    }

    protected void setCache(Document membershipResponse, Document anonymousUserResponse) {
        this.loadMembershipCache(membershipResponse);
        this.loadAnonymousUser(anonymousUserResponse);
        this.cacheLoaded = true;
    }

    public void setCMAccessor(CMAccessorHTTP theCmAccessor) {
        this.cmAccessor = theCmAccessor;
    }
}

